<?php

/*

Menu Single Content Template

*/

// Post
$post_class = array( 'fy-post', 'fy-post-single', 'fy-post-menu', 'fy-post-menu-single' );

// Thumbnail
$thumbnail_attr = array( 'class' => 'fy-image fy-image-responsive js-lazy' );
$thumbnail_image = wp_get_attachment_image_src( get_post_thumbnail_id(), 'fy-huge' );

// Vars
$prices = array_filter( forqy_meta( 'fy_menu_price' ) );
$badges = array_filter( forqy_meta( 'fy_menu_badges' ) );

// Prices
if ( ! empty( $prices ) ) {
	foreach ( $prices as $price => $item ) {
		if ( preg_replace( '/\s/', '', $item ) === '' ) {
			unset( $prices[ $price ] );
		}
	}
}

// Badges
if ( ! empty( $badges ) ) {
	foreach ( $badges as $badge => $item ) {
		if ( preg_replace( '/\s/', '', $item ) === '' ) {
			unset( $badge[ $badge ] );
		}
	}
}
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( $post_class ); ?>>
    <div class="fy-flex-container">

        <div class="fy-flex-column-100 fy-align-center">
			<?php get_template_part( 'templates/post/content' ); ?>
        </div>

        <div class="fy-flex-column-100 fy-align-center">

			<?php if ( ! empty( $badges ) ) { ?>
                <div class="fy-post-badges">
                    <ul>
						<?php foreach ( $badges as $badge ) { ?>
                            <li><?php echo esc_html( $badge ); ?></li>
						<?php } ?>
                    </ul>
                </div>
			<?php }

			if ( ! empty( $prices ) ) { ?>
                <div class="fy-post-prices" itemprop="offers" itemscope itemtype="http://schema.org/AggregateOffer">
                    <span itemprop="lowPrice"><?php echo esc_html( implode( ', ', $prices ) ); ?></span>
                </div>
			<?php } ?>

        </div>

        <div class="fy-flex-column-100 fy-align-center">

			<?php if ( has_term( '', 'ingredient' ) ) { ?>
                <div class="fy-post-taxonomies">
					<?php if ( get_theme_mod( 'fy_menu_filter_by_ingredients' ) == 'disabled' ) { ?>
						<?php linguini_terms_post( $post->ID, 'ingredient', 0 ); ?>
					<?php } else { ?>
						<?php linguini_terms_post( $post->ID, 'ingredient', 1 ); ?>
					<?php } ?>
                </div>
			<?php } ?>

            <div class="fy-post-author fy-hide vcard author">
                <span class="fn"><?php echo get_bloginfo( 'name' ); ?></span>
            </div>

            <footer class="fy-post-footer">
                <div class="fy-divider"></div>

                <div class="fy-flex-container fy-flex-container-center">

					<?php if ( has_term( '', 'section' ) ) { ?>
                        <div class="fy-flex-column-auto fy-flex-column-tablet-100">
                            <div class="fy-post-taxonomies">
								<?php linguini_terms_post( $post->ID, 'section' ); ?>
                            </div>
                        </div>
					<?php }

					if ( get_theme_mod( 'fy_share' ) != 'disabled' ) { ?>
                        <div class="fy-flex-column fy-flex-column-tablet-100">
							<?php get_template_part( 'templates/social/share' ); ?>
                        </div>
					<?php } ?>

                </div>

            </footer>

        </div>

    </div>
</article>