<?php

/*

Gallery Content Template

*/

global $post;

// Type
$type = 'gallery';

// Post
$post_class = array( 'fy-post', 'fy-post-category', 'fy-post-gallery' );

// Thumbnail
$thumbnail_attr = array( 'class' => 'fy-image fy-image-responsive' );
$thumbnail_image = wp_get_attachment_image_src( get_post_thumbnail_id(), 'fy-huge' );

// Images
$images = get_post_meta( $post->ID, 'fy-gallery-images', true );
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( $post_class ); ?>>
    <div class="fy-flex-container">

		<?php if ( has_post_thumbnail() ) { ?>
            <div class="fy-flex-column-100">
				<?php get_template_part( 'templates/image/thumbnail' ); ?>
            </div>
		<?php } else if ( ! empty( $images ) ) {

			$i   = 0;
			$a   = count( $images );
			$max = 1;

			foreach ( $images as $image ) { ?>
                <div class="fy-flex-column-100">
                    <div class="fy-post-image">
                        <a href="<?php the_permalink(); ?>"
                           title="<?php the_title_attribute(); ?>"
                           class="js-lazy-parent">
							<?php
                            echo wp_get_attachment_image( $image, 'fy-medium-fixed' );
                            get_template_part( 'templates/element/loading' );
                            ?>

                            <div class="fy-post-image-counter">
								<?php echo esc_html( $a ); ?><br>
								<?php esc_html_e( 'images', 'linguini' ); ?>
                            </div>
                        </a>
                    </div>
                </div>
				<?php
                $i ++;
                if ( $i == $max ) {
                    break;
                }
			}

		} ?>

        <header class="fy-post-header fy-flex-column-100">
            <h2>
                <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
                    <?php the_title(); ?>
                </a>
            </h2>
        </header>

        <div class="fy-flex-column-auto">
	        <?php get_template_part( 'templates/post/excerpt' ); ?>

            <footer class="fy-post-footer fy-flex-container fy-flex-container-center">
                <div class="fy-flex-column-auto fy-flex-column-phone-100">
					<?php if ( function_exists( 'linguini_post_meta' ) ) {
						linguini_post_meta();
					} ?>
                </div>

                <div class="fy-flex-column fy-flex-column-phone-100">
	                <?php get_template_part('templates/post/more'); ?>
                </div>
            </footer>

            <div class="fy-divider"></div>
        </div>

    </div>

    <div class="fy-post-author fy-hide vcard author" itemprop="author">
        <span class="fn"><?php the_author(); ?></span>
    </div>
    <div class="fy-post-date-published fy-hide">
        <time class="date updated" itemprop="datePublished" datetime="<?php the_time( 'Y-m-d' ); ?>">
            <a href="<?php the_permalink(); ?>">
				<?php the_time( get_option( 'date_format' ) ); ?>
            </a>
        </time>
    </div>
    <div class="fy-post-date-modified fy-hide">
        <time class="date updated" itemprop="dateModified" datetime="<?php the_time( 'Y-m-d' ); ?>">
			<?php the_modified_date( get_option( 'date_format' ) ); ?>
        </time>
    </div>

</article>