<?php

/*

Gallery Single Content Template

*/

// Post
$post_class = array( 'fy-post', 'fy-post-single', 'fy-post-gallery', 'fy-post-gallery-single' );

// Thumbnail
$thumbnail_attr  = array( 'class' => 'fy-image fy-image-responsive' );
$thumbnail_image = wp_get_attachment_image_src( get_post_thumbnail_id(), 'fy-huge' );

// Images
$images = get_post_meta( $post->ID, 'fy-gallery-images', true );
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( $post_class ); ?>>
    <div class="fy-flex-container">

		<?php if ( ! empty( $images ) ) { ?>
            <div class="fy-flex-column-100">

                <div class="fy-post-media fy-post-gallery fy-flex-container fy-flex-gutter-small js-images" itemscope itemtype="https://schema.org/ImageGallery">

					<?php
					$index = '0';

					foreach ( $images as $image ) {
						$attachment = get_post( $image );
						$meta       = wp_get_attachment_metadata( $image );

						if ( $attachment ) { ?>
                            <div class="fy-post-image-column fy-flex-column-20 fy-flex-column-desktop-25 fy-flex-column-tablet-33 fy-flex-column-phone-50">

                                <figure class="fy-post-image" itemscope itemprop="associatedMedia" itemtype="https://schema.org/ImageObject">
                                    <a href="<?php echo wp_get_attachment_url( $image ); ?>"
                                       data-size="<?php echo esc_attr( $meta['width'] ); ?>x<?php echo esc_attr( $meta['height'] ); ?>"
                                       data-index="<?php echo esc_attr( $index ++ ); ?>"
                                       class="js-image js-lazy-parent"
                                       itemprop="contentUrl">
										<?php echo wp_get_attachment_image( $image, 'fy-medium-fixed' ); ?>

										<?php get_template_part( 'templates/element/loading' ); ?>
                                    </a>

                                    <figcaption itemprop="caption description" class="fy-post-image-caption fy-hide">
										<?php echo esc_html( $attachment->post_title ); ?>
                                    </figcaption>
                                </figure>

                            </div>
						<?php }
					} ?>

                </div>
            </div>
		<?php } ?>

        <div class="fy-flex-column-100">
			<?php get_template_part( 'templates/post/content' ); ?>

            <footer class="fy-post-footer">
                <div class="fy-divider"></div>

                <div class="fy-flex-container fy-flex-container-center">

                    <div class="fy-flex-column-auto fy-flex-column-tablet-100">
						<?php if ( function_exists( 'linguini_post_terms' ) ) {
							linguini_post_terms();
						} ?>
                    </div>

					<?php if ( get_theme_mod( 'fy_share' ) != 'disabled' ) { ?>
                        <div class="fy-flex-column fy-flex-column-tablet-100">
							<?php get_template_part( 'templates/social/share' ); ?>
                        </div>
					<?php } ?>

                </div>

            </footer>

        </div>

    </div>

    <?php
    get_template_part( 'templates/post/microdata/post' );
    get_template_part( 'templates/post/microdata/image' );
    get_template_part( 'templates/post/microdata/publisher' );
    ?>
</article>