<?php

/*

Event Content Template

*/

// Post
$post_class = array( 'fy-post', 'fy-post-category', 'fy-post-event' );

// Thumbnail
$thumbnail_attr = array( 'class' => 'fy-image fy-image-responsive js-lazy' );
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( $post_class ); ?>>
    <div class="fy-flex-container fy-flex-container-center fy-flex-gutter-large">

		<?php if ( has_post_thumbnail() ) { ?>
            <div class="fy-post-image-column fy-flex-column-33 fy-flex-column-tablet-50 fy-flex-column-phone-100">
				<?php get_template_part( 'templates/image/thumbnail' ); ?>
            </div>
		<?php } ?>

        <div class="fy-post-content-column fy-flex-column-auto">

            <header class="fy-post-header">
                <h3>
                    <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
						<?php the_title(); ?>
                    </a>

                    <small class="fy-post-date">
						<?php if ( function_exists( 'forqy_date_event' ) ) {
							forqy_date_event( array(
								'date_start' => forqy_meta( 'fy_event_date' ),
								'date_end'   => forqy_meta( 'fy_event_date_end' ),
							) );
						} ?>
                    </small>
                </h3>
            </header>

			<?php get_template_part( 'templates/post/excerpt' ); ?>

            <footer class="fy-post-footer fy-flex-container fy-flex-container-center">
                <div class="fy-flex-column-auto fy-flex-column-phone-100">
					<?php if ( function_exists( 'linguini_event_location' ) ) {
						linguini_event_location( array(
							'heading' => false,
							'address' => false
						) );
					} ?>
                </div>

                <div class="fy-flex-column fy-flex-column-phone-100">
					<?php get_template_part( 'templates/post/more' ); ?>
                </div>
            </footer>

        </div>

    </div>
</article>