<?php

/*

Event Single Content Template

*/

// Post
$post_class = array( 'fy-post', 'fy-post-single', 'fy-post-event', 'fy-post-event-single' );

// Thumbnail
$thumbnail_attr = array( 'class' => 'fy-image fy-image-responsive' );
$thumbnail_image = wp_get_attachment_image_src( get_post_thumbnail_id(), 'fy-huge' );
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( $post_class ); ?>>
    <div class="fy-flex-container">

        <div class="fy-flex-column-100 fy-align-center">
			<?php get_template_part( 'templates/event/content' ); ?>
        </div>

        <div class="fy-flex-column-100 fy-align-center">
			<?php
            if ( function_exists( 'linguini_event_location' ) ) {
				linguini_event_location();
			}

			if ( forqy_meta( 'fy_event_map_embed' ) ) { ?>
                <div class="fy-post-map" itemscope itemtype="https://schema.org/Map">
					<?php echo wp_kses( forqy_meta( 'fy_event_map_embed' ), array(
						'iframe' => array(
							'src'                   => array(),
							'width'                 => array(),
							'height'                => array(),
							'frameborder'           => array(),
							'allowfullscreen'       => array(),
							'webkitallowfullscreen' => array(),
							'mozallowfullscreen'    => array()
						),
						'p'      => array()
					) ); ?>
                </div>
			<?php } ?>
        </div>

        <div class="fy-flex-column-100 fy-align-center">
			<?php if ( function_exists( 'linguini_event_tickets' ) ) {
				linguini_event_tickets();
			} ?>
        </div>

        <div class="fy-flex-column-100">

            <footer class="fy-post-footer">
                <div class="fy-divider"></div>

                <div class="fy-flex-container fy-flex-container-center">

                    <div class="fy-flex-column-auto fy-flex-column-tablet-100">
						<?php if ( function_exists( 'linguini_post_terms' ) ) {
							linguini_post_terms();
						} ?>
                    </div>

					<?php if ( get_theme_mod( 'fy_share' ) != 'disabled' ) { ?>
                        <div class="fy-flex-column fy-flex-column-tablet-100">
							<?php get_template_part( 'templates/social/share' ); ?>
                        </div>
					<?php } ?>

                </div>

            </footer>

        </div>

    </div>

    <?php
    get_template_part('templates/post/microdata/image');
    get_template_part('templates/post/microdata/event');
    ?>
</article>
