<?php

/*

Slideshow Component Template

*/

$post_type = 'slide';
?>

<div class="fy-slideshow-container">

	<?php if ( get_theme_mod( 'fy_slideshow_badge', 0 ) == 1 ) {
		if ( get_theme_mod( 'fy_slideshow_badge_link_custom' ) != '' ) { ?>
            <a href="<?php echo esc_url( get_theme_mod( 'fy_slideshow_badge_link_custom' ) ); ?>"
               class="fy-slideshow-badge cs-badge">
				<?php echo wp_kses( get_theme_mod( 'fy_slideshow_badge_text', esc_html__( 'Book a table online', 'linguini' ) ), array(
					'br'     => array(),
					'em'     => array(),
					'strong' => array()
				) ); ?>
            </a>
			<?php
		} else {
			if ( get_theme_mod( 'fy_slideshow_badge_link' ) != '' ) { ?>
                <a href="<?php echo get_permalink( get_theme_mod( 'fy_slideshow_badge_link' ) ); ?>"
                   class="fy-slideshow-badge cs-badge">
					<?php echo wp_kses( get_theme_mod( 'fy_slideshow_badge_text', esc_html__( 'Book a table online', 'linguini' ) ), array(
						'br'     => array(),
						'em'     => array(),
						'strong' => array()
					) ); ?>
                </a>
			<?php } else { ?>
                <div class="fy-slideshow-badge cs-badge">
					<?php echo wp_kses( get_theme_mod( 'fy_slideshow_badge_text', esc_html__( 'Book a table online', 'linguini' ) ), array(
						'br'     => array(),
						'em'     => array(),
						'strong' => array()
					) ); ?>
                </div>
			<?php }
		}
	}

	// Counter
	$slide_count = 1;
	$total       = wp_count_posts( $post_type )->publish;

	// Query
	$slideshowQuery = new WP_Query( array(
		'post_type'      => $post_type,
		'posts_per_page' => - 1,
		'orderby'        => 'date',
		'order'          => 'DESC',
	) );

	if ( $slideshowQuery->have_posts() ) { ?>

        <div class="fy-slideshow-centerer">
            <div class="fy-slideshow js-slideshow-height<?php if ( $total >= 2 ) { ?> js-slideshow<?php } else { ?> fy-slideshow-one-image<?php } ?>">

                <div class="fy-slideshow-wrapper swiper-wrapper">

					<?php while ( $slideshowQuery->have_posts() ) {
						$slideshowQuery->the_post();

						// Caption
						$slide_caption_title   = forqy_meta( 'fy_slide_caption_title' );
						$slide_caption_content = forqy_meta( 'fy_slide_caption_content' );

						$slide_caption_button               = forqy_meta( 'fy_slide_caption_button' );
						$slide_caption_button_url           = forqy_meta( 'fy_slide_caption_url' );
						$slide_caption_button_secondary     = forqy_meta( 'fy_slide_caption_button_secondary' );
						$slide_caption_button_secondary_url = forqy_meta( 'fy_slide_caption_secondary_url' );

						// Images
						$slide_image_url = wp_get_attachment_image_src( get_post_thumbnail_id(), 'fy-huge' );
						?>

                        <article class="fy-slide swiper-slide">

                            <div class="fy-slide-background swiper-lazy<?php if ( ! has_post_thumbnail() ) { ?> has-no-image<?php } ?><?php if ( $total == 1 ) { ?> js-lazy<?php } ?>"
							     <?php if ( $total >= 2 ) { ?>data-background="<?php echo esc_url( $slide_image_url[0] ); ?>"<?php } ?>
							     <?php if ( $total == 1 ) { ?>data-src="<?php echo esc_url( $slide_image_url[0] ); ?>"<?php } ?>>

                                <div class="fy-caption">

									<?php if ( $slide_caption_title == '1' ) { ?>
                                        <header class="fy-caption-header">
                                            <h2>
												<?php if ( $slide_caption_button_url ) { ?>
                                                    <a href="<?php echo esc_url( $slide_caption_button_url ); ?>">
														<?php the_title(); ?>
                                                    </a>
												<?php } else {
													the_title();
												} ?>
                                            </h2>
                                        </header>
									<?php }

									if ( ! empty( $slide_caption_content ) ) { ?>
                                        <div class="fy-caption-content">
											<?php echo do_shortcode( wp_kses_post( $slide_caption_content ) ); ?>
                                        </div>
									<?php }

									if ( ! empty( $slide_caption_button ) && ! empty( $slide_caption_button_url ) ) { ?>
                                        <div class="fy-caption-button">
                                            <a href="<?php echo esc_url( $slide_caption_button_url ); ?>"
                                               class="fy-button fy-button-bordered">
												<?php echo esc_html( $slide_caption_button ); ?>
                                            </a>
                                        </div>
									<?php }

									if ( ! empty( $slide_caption_button_secondary ) && ! empty( $slide_caption_button_secondary_url ) ) { ?>
                                        <div class="fy-caption-button">
                                            <a href="<?php echo esc_url( $slide_caption_button_secondary_url ); ?>"
                                               class="fy-button fy-button-bordered">
												<?php echo esc_html( $slide_caption_button_secondary ); ?>
                                            </a>
                                        </div>
									<?php } ?>

                                </div>

                            </div>

                            <div class="fy-loading swiper-lazy-preloader">
								<?php get_template_part( 'images/icons/icon', 'loader' ); ?>
                            </div>

                        </article>

						<?php
						$slide_count ++;
					} ?>

                </div>

				<?php if ( $total >= 2 ) { ?>
                    <div class="fy-slideshow-prev js-slideshow-prev">
						<?php get_template_part( 'images/icons/icon', 'prev' ); ?>
                    </div>
                    <div class="fy-slideshow-next js-slideshow-next">
						<?php get_template_part( 'images/icons/icon', 'next' ); ?>
                    </div>
				<?php } ?>

            </div>
        </div>

		<?php
		wp_reset_postdata();
	} ?>

</div>
