<?php

/*

Posts Component Template

*/

$postsQuery = new WP_Query( array(
	'ignore_sticky_posts' => 1,
	'posts_per_page'      => get_theme_mod( 'fy_homepage_posts_count', linguini_default( 'fy_homepage_posts_count' ) )
) );

if ( $postsQuery->have_posts() ) { ?>

    <div class="fy-homepage-posts">

        <div class="fy-centerer">

            <header class="fy-content-heading">
                <h2>
					<?php if ( get_option( 'page_for_posts' ) != 0 ) { ?>
                        <a href="<?php echo get_permalink( get_option( 'page_for_posts' ) ); ?>">
							<?php esc_html_e( 'Recent news', 'linguini' ); ?>
                        </a>
					<?php } else {
						esc_html_e( 'Recent news', 'linguini' );
					} ?>
                </h2>
            </header>

            <div class="fy-flex-container fy-flex-gutter-large">
				<?php while ( $postsQuery->have_posts() ) {
					$postsQuery->the_post(); ?>

                    <div class="fy-post-column fy-flex-column-auto fy-flex-column-tablet-50 fy-flex-column-phone-100">
						<?php
						if ( get_post_type() != 'post' ) {
							get_template_part( 'content', get_post_type() );
						} else if ( get_post_type() == 'post' ) {

							if ( get_post_format() ) {
								get_template_part( 'content', get_post_format() );
							} else {
								get_template_part( 'content', 'standard' );
							}

						}
						?>
                    </div>

				<?php } ?>
            </div>

        </div>
    </div>

	<?php
	wp_reset_postdata();
}
