<?php

/*

Posts Component Template

*/

// Type
$type = 'event';

// Current Date
$current_date = date( 'Y/m/d', current_time( 'timestamp' ) );

// Query
$eventsQuery = new WP_Query( array(
	'post_type'           => $type,
	'meta_key'            => 'fy_event_date',
	'meta_value'          => 'fy_event_date_end',
	'meta_compare'        => '<',
	'meta_query'          => array(
		'relation' => 'AND',
		array(
			'key'     => 'fy_event_date',
			'value'   => 'fy_event_date_end',
			'compare' => '<='
		),
		array(
			'key'     => 'fy_event_date_end',
			'value'   => $current_date,
			'compare' => '>='
		)
	),
	'order'               => 'ASC',
	'orderby'             => 'meta_value',
	'ignore_sticky_posts' => 1,
	'paged'               => $paged,
	'posts_per_page'      => get_theme_mod( 'fy_homepage_events_count', linguini_default( 'fy_homepage_events_count' ) )
) );

if ( $eventsQuery->have_posts() ) { ?>

    <div class="fy-homepage-events">

        <div class="fy-centerer">
            <header class="fy-content-heading">
                <h2>
					<?php if ( get_theme_mod( 'fy_page_events' ) ) { ?>
                        <a href="<?php echo get_permalink( get_theme_mod( 'fy_page_events' ) ); ?>">
							<?php echo get_the_title( get_theme_mod( 'fy_page_events' ) ); ?>
                        </a>
					<?php } else {
						esc_html_e( 'Events', 'linguini' );
					} ?>
                </h2>
            </header>
        </div>

        <div class="fy-centerer">

			<?php while ( $eventsQuery->have_posts() ) {
				$eventsQuery->the_post();

				get_template_part( 'content', $type );
			} ?>

        </div>
    </div>

	<?php
	wp_reset_postdata();
}
