<?php

/*

About Component Template

*/

if ( get_theme_mod( 'fy_restaurant_headline' ) || get_theme_mod( 'fy_restaurant_description' ) ) { ?>

    <div class="fy-about<?php if ( get_theme_mod( 'fy_restaurant_image' ) == '' ) { ?> has-no-image<?php } ?>">
        <div class="fy-centerer">

            <div class="fy-flex-container fy-flex-container-stretch fy-flex-gutter-0">
                <div class="fy-about-content-column fy-flex-column-auto fy-flex-column-tablet-100">

                    <div class="fy-about-content">

						<?php if ( get_theme_mod( 'fy_restaurant_headline' ) ) { ?>
                            <header class="fy-about-header">
                                <h2>
									<?php echo wp_kses_post( get_theme_mod( 'fy_restaurant_headline' ) ); ?>
                                </h2>
                            </header>
						<?php }

						if ( get_theme_mod( 'fy_restaurant_description' ) ) { ?>
                            <div class="fy-about-description">
								<?php echo wp_kses_post( get_theme_mod( 'fy_restaurant_description' ) ); ?>
                            </div>
						<?php }

						if ( get_theme_mod( 'fy_page_about' ) || get_theme_mod( 'fy_page_reservation' ) ) { ?>
                            <div class="fy-about-buttons">
								<?php if ( get_theme_mod( 'fy_page_about' ) ) { ?>
                                    <a href="<?php echo get_permalink( get_theme_mod( 'fy_page_about' ) ); ?>"
                                       class="fy-button fy-button-bordered">
										<?php echo get_the_title( get_theme_mod( 'fy_page_about' ) ); ?>
                                    </a>
								<?php }

								if ( get_theme_mod( 'fy_page_reservation' ) ) { ?>
                                    <a href="<?php echo get_permalink( get_theme_mod( 'fy_page_reservation' ) ); ?>"
                                       class="fy-button fy-button-bordered">
										<?php echo get_the_title( get_theme_mod( 'fy_page_reservation' ) ); ?>
                                    </a>
								<?php } ?>
                            </div>
						<?php } ?>

                    </div>

                </div>
				<?php if ( get_theme_mod( 'fy_restaurant_image' ) ) { ?>
                    <div class="fy-about-image-column fy-flex-column-auto fy-flex-column-tablet-100 js-lazy-parent">

                        <div class="fy-about-image js-lazy"
                             data-src="<?php echo esc_url( get_theme_mod( 'fy_restaurant_image' ) ); ?>">
                            <img src="<?php echo esc_url( get_template_directory_uri() . '/images/placeholder.png' ); ?>"
                                 alt="" class="fy-image fy-image-responsive">
                        </div>
						<?php get_template_part( 'templates/element/loading' ); ?>

                    </div>
				<?php } ?>
            </div>

        </div>
    </div>

<?php }
