<?php

/*

Comments Template

*/

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if ( post_password_required() ) {
	return;
}
?>

<div id="comments" class="fy-comments">

    <header class="fy-comments-header">
        <h2><?php comments_number( esc_html__( 'No comments', 'linguini' ), esc_html__( '1 comment', 'linguini' ), esc_html__( '% comments', 'linguini' ) ); ?></h2>
    </header>

	<?php if ( have_comments() ) { ?>

        <div class="fy-comments-list">
			<?php
			wp_list_comments( array(
				'style'       => 'div',
				'avatar_size' => 96,
				'short_ping'  => true,
				'callback'    => 'forqy_comments_list'
			) );
			?>
        </div>

	<?php } else {
		if ( comments_open() ) { ?>

            <div class="fy-comments-no">
				<?php esc_html_e( 'You can be the first one to leave a comment.', 'linguini' ); ?>
            </div>

		<?php }
	}

	if ( (int) get_option( 'page_comments' ) > 1 ) { ?>

        <div class="fy-comments-pagination fy-pagination">
			<?php
			paginate_comments_links( array(
				'prev_text' => esc_html__( '&lsaquo; Previous', 'linguini' ),
				'next_text' => esc_html__( 'Next &rsaquo;', 'linguini' )
			) );
			?>
        </div>

	<?php }

	if ( comments_open() || pings_open() ) { ?>

        <div class="fy-comments-form fy-form">
			<?php comment_form(); ?>
        </div>

	<?php }

	if ( ! comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) { ?>

        <div class="fy-comments-closed">
			<?php esc_html_e( 'Comments are closed.', 'linguini' ); ?>
        </div>

	<?php } ?>

</div>
