<?php

/*

Archive Template

*/

// Get Page ID
$page_id = get_queried_object_id();

// Main
$main_class = is_active_sidebar( 'blog' ) ? 'fy-sidebar-active' : 'fy-sidebar-inactive';

get_header();
?>
    <header class="fy-heading">
        <div class="fy-centerer">

            <h1>
				<?php if ( is_category() ) {
					single_cat_title();
				} else if ( is_tag() ) {
					printf( esc_html__( 'Tag: %s', 'linguini' ), single_tag_title( '', false ) );
				} else if ( is_author() ) {
					printf( esc_html__( 'Author: %s', 'linguini' ), get_the_author() );
				} else if ( is_day() ) {
					esc_html_e( 'Archive:', 'linguini' );
					the_time( esc_html__( 'F jS, Y', 'linguini' ) );
				} else if ( is_month() ) {
					esc_html_e( 'Archive:', 'linguini' );
					the_time( esc_html__( 'F, Y', 'linguini' ) );
				} else if ( is_year() ) {
					esc_html_e( 'Archive:', 'linguini' );
					the_time( esc_html__( 'Y', 'linguini' ) );
				} else if ( get_post_format() ) {
					printf( esc_html__( 'Archive: %s', 'linguini' ), get_post_format() );
				} else if ( isset( $_GET['paged'] ) && ! empty( $_GET['paged'] ) ) {
					esc_html_e( 'Archive', 'linguini' );
				} ?>
            </h1>

        </div>
    </header>

    <div class="fy-wrap">

        <div class="fy-centerer">
            <div class="fy-flex-container fy-flex-gutter-xxlarge">

                <main class="fy-main fy-flex-column-auto <?php echo esc_attr( $main_class ); ?>">

					<?php if ( category_description() ) { ?>
                        <div class="fy-page-content fy-content">
							<?php echo category_description(); ?>
                        </div>
					<?php }

					if ( have_posts() ) { ?>
                        <div class="fy-flex-container fy-flex-gutter-large">
							<?php while ( have_posts() ) {
								the_post(); ?>

                                <div class="fy-post-column fy-post-column-<?php echo esc_attr( $i ); ?><?php if ( is_active_sidebar( 'blog' ) ) { ?> fy-flex-column-50 fy-flex-column-tablet-100<?php } else { ?> fy-flex-column-33 fy-flex-column-tablet-50<?php } ?> fy-flex-column-phone-100">

									<?php
									if ( get_post_type() != 'post' ) {
										get_template_part( 'content', get_post_type() );
									} else if ( get_post_type() == 'post' ) {
										if ( get_post_format() ) {
											get_template_part( 'content', get_post_format() );
										} else {
											get_template_part( 'content', 'standard' );
										}
									}
									?>

                                </div>

								<?php
								$i ++;
							} ?>
                        </div>

						<?php
						if ( function_exists( 'linguini_pagination' ) ) {
							linguini_pagination();
						}

					} ?>

                </main>

				<?php if ( is_active_sidebar( 'blog' ) ) {
					get_sidebar( 'blog' );
				} ?>

            </div>

        </div>

    </div>

<?php
get_footer();
