<?php 
/* add_ons_php */

class Lambert_Widget_Tweets extends WP_Widget {

	public function __construct() {
		$widget_ops = array('classname' => 'widget_cth-tweets footer-info', 'description' => __( 'A list of your recent twitter feeds.','lambert-add-ons') );
		parent::__construct('cth_tweets', __('Lambert Twitter Feed','lambert-add-ons'), $widget_ops);
	}

	public function widget( $args, $instance ) {

		if ( ! isset( $args['widget_id'] ) ) {
			$args['widget_id'] = $this->id;
		}

		$title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : '';

		/** This filter is documented in wp-includes/widgets/class-wp-widget-pages.php */
		$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );

		
		$username = $instance['username'];
		$list = $instance['list'];
		$hashtag = $instance['hashtag'];
		$count = ( ! empty( $instance['count'] ) ) ? absint( $instance['count'] ) : 2;
		if ( ! $count )
			$count = 2;

		$follow_url = $instance['follow_url'];
		$list_ticker = $instance['list_ticker'];

		?>
		<?php echo $args['before_widget']; ?>
		<?php if ( $title ) {
			echo $args['before_title'] . $title . $args['after_title'];
		} ?>
		<div class="tweet lambert-tweet tweet-count-<?php echo esc_attr($count );?> tweet-ticker-<?php echo esc_attr($list_ticker );?>" data-username="<?php echo esc_attr($username );?>" data-list="<?php echo esc_attr($list );?>" data-hashtag="<?php echo esc_attr($hashtag );?>" data-ticker="<?php echo esc_attr($list_ticker );?>" data-count="<?php echo esc_attr($count );?>"></div>
		<?php 
		if($follow_url != '') : ?>
		<div class="follow-wrap">
			<a  href="<?php echo esc_url( $follow_url );?>" target="_blank" class="twiit-button"><i class="fa fa-twitter"></i><?php _e(' Follow Us','lambert-add-ons');?></a>  
		</div>
		<?php endif;?>

		<?php echo $args['after_widget']; ?>
		<?php
	}

	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = sanitize_text_field( $new_instance['title'] );
		$instance['username'] = $new_instance['username'];
		$instance['list'] = $new_instance['list'];
		$instance['hashtag'] = $new_instance['hashtag'];
		$instance['follow_url'] = $new_instance['follow_url'];
		$instance['count'] = (int) $new_instance['count'];

		$instance['list_ticker'] = $new_instance['list_ticker'];

		return $instance;
	}

	public function form( $instance ) {
		$title     = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
		$username    = isset( $instance['username'] ) ?  $instance['username'] : '';
		$list    = isset( $instance['list'] ) ?  $instance['list'] : '';
		$hashtag    = isset( $instance['hashtag'] ) ?  $instance['hashtag'] : '';
		$count    = isset( $instance['count'] ) ? absint( $instance['count'] ) : 2;

		$follow_url    = isset( $instance['follow_url'] ) ?  $instance['follow_url'] : '';

		$list_ticker    = isset( $instance['list_ticker'] ) ?  $instance['list_ticker'] : '';

	?>
		<p><label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title' ,'lambert-add-ons'); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo $title; ?>" /></p>

		
		<p><label for="<?php echo $this->get_field_id( 'username' ); ?>"><?php _e( 'Username' ,'lambert-add-ons'); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'username' ); ?>" name="<?php echo $this->get_field_name( 'username' ); ?>" type="text" value="<?php echo $username; ?>" /></p>
		<p><?php _e('Option to load tweets from another account - Optional. Leave this empty to load from your own (account with API keys on <strong>Settings -> Lambert Add-Ons -> Twitter Feeds Section</strong> tab).','lambert-add-ons');?></p>
		
		<p><label for="<?php echo $this->get_field_id( 'list' ); ?>"><?php _e( 'List name' ,'lambert-add-ons'); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'list' ); ?>" name="<?php echo $this->get_field_name( 'list' ); ?>" type="text" value="<?php echo $list; ?>" /></p>

		<p><?php _e('List name to load tweets from - Optional. If you define list name you also must define the username of the list owner in the Username option.','lambert-add-ons');?></p>

		<p><label for="<?php echo $this->get_field_id( 'hashtag' ); ?>"><?php _e( 'Hashtag' ,'lambert-add-ons'); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'hashtag' ); ?>" name="<?php echo $this->get_field_name( 'hashtag' ); ?>" type="text" value="<?php echo $hashtag; ?>" /></p>
		<p><?php _e('Option to load tweets with a specific hashtag - Optional.','lambert-add-ons');?></p>
		
		
		<p><label for="<?php echo $this->get_field_id( 'count' ); ?>"><?php _e( 'Number of tweets you want to display.' ,'lambert-add-ons'); ?></label>
		<input class="tiny-text" id="<?php echo $this->get_field_id( 'count' ); ?>" name="<?php echo $this->get_field_name( 'count' ); ?>" type="number" step="1" min="1" value="<?php echo $count; ?>" size="3" /></p>

		<p><label for="<?php echo $this->get_field_id( 'follow_url' ); ?>"><?php _e( 'Follow Us link' ,'lambert-add-ons'); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'follow_url' ); ?>" name="<?php echo $this->get_field_name( 'follow_url' ); ?>" type="text" value="<?php echo $follow_url; ?>" /></p>

		<p>
			<label for="<?php echo $this->get_field_id( 'list_ticker' ); ?>"><?php _e( 'Display tweets as a list ticker','lambert-add-ons'); ?></label>
			<select id="<?php echo $this->get_field_id( 'list_ticker' ); ?>" name="<?php echo $this->get_field_name( 'list_ticker' ); ?>">
				<option value="no" <?php selected( $list_ticker, 'no' ); ?>>
					<?php _e( 'No','lambert-add-ons'); ?>
				</option>
				<option value="yes" <?php selected( $list_ticker, 'yes' ); ?>>
					<?php _e( 'Yes','lambert-add-ons'); ?>
				</option>
				
			</select>
		</p>

		


	<?php
	}
}
