<?php
if ( ! defined( 'ABSPATH' ) ) {
    die( '-1' );
}
/**
 * Shortcode attributes
 * @var $atts
 * @var $el_class
 * @var $full_width
 * @var $full_height
 * @var $equal_height
 * @var $columns_placement
 * @var $content_placement
 * @var $parallax
 * @var $parallax_image
 * @var $css
 * @var $el_id
 * @var $video_bg
 * @var $video_bg_url
 * @var $video_bg_parallax
 * @var $parallax_speed_bg
 * @var $parallax_speed_video
 * @var $content - shortcode content
 *
 * @var $cth_layout
 *
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_Row
 */
$el_class = $full_height = $parallax_speed_bg = $parallax_speed_video = $full_width = $equal_height = $flex_row = $columns_placement = $content_placement = $parallax = $parallax_image = $css = $el_id = $video_bg = $video_bg_url = $video_bg_parallax = '';
$disable_element = '';
$output = $after_output = '';

// for custom fields
$cth_layout = $no_padding
= $parallax_inner = $parallax_inner_op = $parallax_inner_val
= $bg_video = $video_type 
= $scroll_link
= $remove_border 
= $is_mute
='';

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

?>

<?php
if ($cth_layout === 'hero_sec'): ?>
<?php
    $el_class = $this->getExtraClass( $el_class );

    $css_classes = array(
        'content lambert_sec lambert_hero_sec',
        'full-height',
        'hero-content',
        vc_shortcode_custom_css_class( $css ),
    );

    if ( 'yes' === $disable_element ) {
        if ( vc_is_page_editable() ) {
            $css_classes[] = 'vc_hidden-lg vc_hidden-xs vc_hidden-sm vc_hidden-md';
        } else {
            return '';
        }
    }

    $css_class = preg_replace( '/\s+/', ' ', implode( ' ', array_filter( $css_classes ) ) );
    
    ?>
<div <?php
    echo isset($el_id) && !empty($el_id) ? "id='" . esc_attr($el_id) . "'" : ""; ?> <?php
    echo !empty($css_class) ? "class='" . esc_attr( trim( $css_class ) ) . "'" : ""; ?>>
    <div class="hero-container">
        <div class="row <?php echo esc_attr($el_class );?>">
            <?php echo wpb_js_remove_wpautop($content); ?>
        </div>
    </div>  
</div>

<?php
elseif($cth_layout === 'hero_head_sec')://from version 2.x

$el_class = $this->getExtraClass( $el_class );

$css_classes = array(
    'lambert_sec lambert_hero_head_sec',
    'content full-height hero-content',
    $el_class,
    vc_shortcode_custom_css_class( $css ),
);
if($no_padding == 'yes'){
    $css_classes[] = 'no-padding';
}

if($remove_border == 'yes'){
    $css_classes[] = 'remove_border';
}

if ( 'yes' === $disable_element ) {
    if ( vc_is_page_editable() ) {
        $css_classes[] = 'vc_hidden-lg vc_hidden-xs vc_hidden-sm vc_hidden-md';
    } else {
        return '';
    }
}

$css_class = preg_replace( '/\s+/', ' ', implode( ' ', array_filter( $css_classes ) ) );
?>
<div <?php
    echo isset($el_id) && !empty($el_id) ? "id='" . esc_attr($el_id) . "'" : ""; ?> <?php
    echo !empty($css_class) ? "class='" . esc_attr( trim( $css_class ) ) . "'" : ""; ?>>
    <div class="slideshow-container">
        <?php if(!empty($bg_video) || !empty($parallax_inner) ) :
            if ($parallax_inner_val == '') {
                $parallax_inner_val = 0;
            }
        ?>
        <div class="media-container" data-top-bottom="transform: translateY(<?php echo esc_attr($parallax_inner_val);?>px);" data-bottom-top="transform: translateY(<?php echo 0-$parallax_inner_val;?>px);">
            <div class="video-container">
            <?php if($video_type == 'bg-image'):?>
                <div class="bg home-bg-image" style="background-image:url(<?php echo esc_url( wp_get_attachment_url($parallax_inner ) );?>)"></div>
            <?php else :?>
                <div class="bg mob-bg" style="background-image:url(<?php echo esc_url( wp_get_attachment_url($parallax_inner ) );?>)"></div>
            <?php endif;?>
            <?php if($video_type == 'hosted'):?>
                <video autoplay  loop <?php echo $is_mute == '1' ? ' muted' : '';?>  class="bgvid">
                    <source src="<?php echo esc_url($bg_video );?>" type="video/mp4">
                </video>
            <?php elseif($video_type == 'vimeo') :?>
                <div class="video-holder">
                    <iframe src="http://player.vimeo.com/video/<?php echo esc_attr($bg_video );?>?autoplay=1&amp;loop=1" webkitallowfullscreen mozallowfullscreen allowfullscreen class="vimeo-player"></iframe>
                </div>
            <?php elseif($video_type == 'youtube') :?>
                <div  class="background-video" data-vid="<?php echo esc_attr($bg_video );?>" data-mv="<?php echo esc_attr( $is_mute );?>"></div>
            <?php endif;?>
            </div>
        </div>
        
        <?php endif;?> 

        <div class="hero-title-holder">
            <div class="overlay" style="opacity:<?php echo esc_attr($parallax_inner_op );?>;"></div>
            <div class="hero-title">
                <div class="row">
                    <?php echo wpb_js_remove_wpautop($content); ?>
                </div>
            </div>
        </div>
        <?php if(!empty($scroll_link)):?>
        <div class="hero-link">
            <a class="custom-scroll-link" href="<?php echo esc_url($scroll_link );?>"><?php echo wp_kses(__('<i class="fa fa-angle-double-down"></i>','lambert-add-ons'),array('i'=>array('class'=>array())) );?></a>
        </div>
        <?php endif;?>
    </div>
</div>

<?php 
elseif ($cth_layout === 'hero_image_sec'): ?>
    <?php
    $el_class = $this->getExtraClass( $el_class );

    $css_classes = array(
        'bg',
        vc_shortcode_custom_css_class( $css ),
    );
    $css_class = preg_replace( '/\s+/', ' ', implode( ' ', array_filter( $css_classes ) ) );
    
    ?>

<?php
    //$sec_class = 'bg' . ' ' . $el_class . ' ' . $style_class; ?>
<div <?php echo isset($el_id) && !empty($el_id) ? "id='" . esc_attr($el_id) . "'" : ""; ?> class="content full-height hero-content lambert_sec lambert_hero_img_sec">
    <div class="home-image-container">
        <!-- slideshow -->  
        <div class="media-container" data-top-bottom="transform: translateY(300px);" data-bottom-top="transform: translateY(-300px);">
            <div class="<?php echo esc_attr($css_class); ?>"></div>
        </div>
        <div class="row <?php echo esc_attr($el_class );?>">
            <?php echo wpb_js_remove_wpautop($content); ?>
        </div>
    </div> 
</div>
<?php
elseif ($cth_layout === 'triangle_sec'): ?>
    <?php
    $el_class = $this->getExtraClass( $el_class );

    $css_classes = array(
        'content lambert_sec lambert_triangle_sec',
        vc_shortcode_custom_css_class( $css ),
    );

    if ( 'yes' === $disable_element ) {
        if ( vc_is_page_editable() ) {
            $css_classes[] = 'vc_hidden-lg vc_hidden-xs vc_hidden-sm vc_hidden-md';
        } else {
            return '';
        }
    }

    $css_class = preg_replace( '/\s+/', ' ', implode( ' ', array_filter( $css_classes ) ) );
    
    ?>
<?php
    //$sec_class = 'content' . ' ' . $el_class . ' ' . $style_class; ?>
<section  <?php
    echo isset($el_id) && !empty($el_id) ? "id='" . esc_attr($el_id) . "'" : ""; ?> <?php
    echo !empty($css_class) ? "class='" . esc_attr($css_class) . "'" : ""; ?>>
    <div class="triangle-decor"></div>  
    <?php 
        if ( ! empty( $full_width ) ) { ?>
        <div class="container-fluid">
    <?php }else { ?>
        <div class="container">
    <?php
    }    ?>
        <div class="row <?php echo esc_attr($el_class );?>">
            <?php echo wpb_js_remove_wpautop($content); ?>
        </div>
    </div>
</section>
<?php elseif($cth_layout === 'row_sec') :?>
    <?php
    $el_class = $this->getExtraClass( $el_class );

    $css_classes = array(
        'content lambert_sec lambert_row_sec' ,
        vc_shortcode_custom_css_class( $css ),
    );

    if ( 'yes' === $disable_element ) {
        if ( vc_is_page_editable() ) {
            $css_classes[] = 'vc_hidden-lg vc_hidden-xs vc_hidden-sm vc_hidden-md';
        } else {
            return '';
        }
    }

    $css_class = preg_replace( '/\s+/', ' ', implode( ' ', array_filter( $css_classes ) ) );
    
    ?>
<?php
    //$sec_class = 'content' . ' ' . $el_class . ' ' . $style_class; ?>
<section  <?php
    echo isset($el_id) && !empty($el_id) ? "id='" . esc_attr($el_id) . "'" : ""; ?> <?php
    echo !empty($css_class) ? "class='" . esc_attr($css_class) . "'" : ""; ?>> 
    <?php 
        if ( ! empty( $full_width ) ) { ?>
        <div class="container-fluid">
    <?php }else { ?>
        <div class="container">
    <?php
    }    ?>
        <div class="row <?php echo esc_attr($el_class );?>">
            <?php echo wpb_js_remove_wpautop($content); ?>
        </div>
    </div>
</section>
<?php elseif($cth_layout === 'header_sec') :?>
    <?php
    $el_class = $this->getExtraClass( $el_class );

    $css_classes = array(
        'bg',
        'bg-parallax',
        vc_shortcode_custom_css_class( $css ),
    );

    $css_class = preg_replace( '/\s+/', ' ', implode( ' ', array_filter( $css_classes ) ) );

    $section_cls = 'content parallax-section header-section lambert_sec lambert_header_sec';
    
    if ( 'yes' === $disable_element ) {
        if ( vc_is_page_editable() ) {
            $section_cls .= ' vc_hidden-lg vc_hidden-xs vc_hidden-sm vc_hidden-md';
        } else {
            return '';
        }
    }

    ?>
    <?php //$sec_class = 'bg bg-parallax '. $el_class . ' ' . $style_class; ?>
<section <?php
    echo isset($el_id) && !empty($el_id) ? "id='" . esc_attr($el_id) . "'" : ""; ?>
     class="<?php echo esc_attr($section_cls );?>">
    <div class="<?php echo esc_attr($css_class) ; ?> " 
        data-top-bottom="transform: translateY(300px);" 
        data-bottom-top="transform: translateY(-300px);">
    </div>
    <div class="overlay"></div>
    <?php 
        if ( ! empty( $full_width ) ) { ?>
        <div class="container-fluid">
    <?php }else { ?>
        <div class="container">
    <?php
    }    ?>
        <div class="row <?php echo esc_attr($el_class );?>">
            <?php echo wpb_js_remove_wpautop($content); ?>
        </div>
    </div>
</section>

<?php elseif($cth_layout === 'parallax_sec') :?>
    <?php
    $el_class = $this->getExtraClass( $el_class );

    $css_classes = array(
        'bg',
        'bg-parallax',
        vc_shortcode_custom_css_class( $css ),
    );
    $css_class = preg_replace( '/\s+/', ' ', implode( ' ', array_filter( $css_classes ) ) );

    $section_cls = 'content parallax-section lambert_sec lambert_parallax_sec';
    
    if ( 'yes' === $disable_element ) {
        if ( vc_is_page_editable() ) {
            $section_cls .= ' vc_hidden-lg vc_hidden-xs vc_hidden-sm vc_hidden-md';
        } else {
            return '';
        }
    }
    
    ?>
    <?php //$sec_class = 'bg bg-parallax '. $el_class . ' ' . $style_class; ?>
<section <?php
    echo isset($el_id) && !empty($el_id) ? "id='" . esc_attr($el_id) . "'" : ""; ?>
     class="<?php echo esc_attr($section_cls );?>">
    <div class="<?php echo esc_attr($css_class) ; ?> " 
        data-top-bottom="transform: translateY(300px);" 
        data-bottom-top="transform: translateY(-300px);">
    </div>
    <div class="overlay"></div>
    <?php 
        if ( ! empty( $full_width ) ) { ?>
        <div class="container-fluid">
    <?php }else { ?>
        <div class="container">
    <?php
    }    ?>
        <div class="row <?php echo esc_attr($el_class );?>">
            <?php echo wpb_js_remove_wpautop($content); ?>
        </div>
    </div>
</section>
<?php elseif($cth_layout === 'home_full_height') :?>
    <?php
    $el_class = $this->getExtraClass( $el_class );

    $css_classes = array(
        'no-vc-margin lambert_sec lambert_home_full_height_sec',
        'home-full-height',
        $el_class,
        vc_shortcode_custom_css_class( $css ),
    );

    if ( 'yes' === $disable_element ) {
        if ( vc_is_page_editable() ) {
            $css_classes[] = 'vc_hidden-lg vc_hidden-xs vc_hidden-sm vc_hidden-md';
        } else {
            return '';
        }
    }


    $css_class = preg_replace( '/\s+/', ' ', implode( ' ', array_filter( $css_classes ) ) );
    
    ?>

<?php
    //$sec_class = 'no-vc-margin home-full-height' . ' ' . $el_class . ' ' . $style_class; ?>
<div  <?php
    echo isset($el_id) && !empty($el_id) ? "id='" . esc_attr($el_id) . "'" : ""; ?> <?php
    echo !empty($css_class) ? "class='" . esc_attr($css_class) . "'" : ""; ?> 
>    
        <!-- <div class="row wpb_row home-full-height"> -->
            <?php
    echo wpb_js_remove_wpautop($content); ?>
        <!-- </div> -->
</div> 
<div class="clearfix"></div>
<?php
elseif($cth_layout === 'fullwidth_sec'): //version 2.x

$el_class = $this->getExtraClass( $el_class );

$css_classes = array(
    'lambert_sec lambert_page_sec',
    $el_class,
    vc_shortcode_custom_css_class( $css ),
);
if($no_padding == 'yes'){
    $css_classes[] = 'no-padding';
}

if ( 'yes' === $disable_element ) {
    if ( vc_is_page_editable() ) {
        $css_classes[] = 'vc_hidden-lg vc_hidden-xs vc_hidden-sm vc_hidden-md';
    } else {
        return '';
    }
}

$css_class = preg_replace( '/\s+/', ' ', implode( ' ', array_filter( $css_classes ) ) );
?>
<section <?php
    echo isset($el_id) && !empty($el_id) ? "id='" . esc_attr($el_id) . "'" : ""; ?> <?php
    echo !empty($css_class) ? "class='" . esc_attr( trim( $css_class ) ) . "'" : ""; ?>>
    
    <?php 
        if ( ! empty( $full_width ) ) { ?>
        <div class="container-fluid">
    <?php }else { ?>
        <div class="container">
    <?php
    }    ?>
            <div class="row">
                <?php echo wpb_js_remove_wpautop($content); ?>
            </div>
        </div>
</section>
<?php
elseif($cth_layout === 'fullwidth_image_parallax_sec')://version 2.x

$el_class = $this->getExtraClass( $el_class );

$css_classes = array(
    'lambert_sec lambert_page_sec',
    'parallax-section parallax-img-bg',
    $el_class,
    vc_shortcode_custom_css_class( $css ),
);
if($no_padding == 'yes'){
    $css_classes[] = 'no-padding';
}

if ( 'yes' === $disable_element ) {
    if ( vc_is_page_editable() ) {
        $css_classes[] = 'vc_hidden-lg vc_hidden-xs vc_hidden-sm vc_hidden-md';
    } else {
        return '';
    }
}

$css_class = preg_replace( '/\s+/', ' ', implode( ' ', array_filter( $css_classes ) ) );
?>
<section <?php
    echo isset($el_id) && !empty($el_id) ? "id='" . esc_attr($el_id) . "'" : ""; ?> <?php
    echo !empty($css_class) ? "class='" . esc_attr( trim( $css_class ) ) . "'" : ""; ?>>
    <?php if(!empty($parallax_inner)) :

    if ($parallax_inner_val == '') {
        $parallax_inner_val = 0;
    }
    ?>
        <div class="bg bg-parallax" style="background-image:url(<?php echo esc_url( wp_get_attachment_url($parallax_inner ) );?>)" data-top-bottom="transform: translateY(<?php echo esc_attr($parallax_inner_val);?>px);" data-bottom-top="transform: translateY(<?php echo 0-$parallax_inner_val;?>px);"></div>
        <div class="overlay" style="opacity:<?php echo esc_attr($parallax_inner_op );?>;"></div>
    <?php endif;?> 
    <?php 
        if ( ! empty( $full_width ) ) { ?>
        <div class="container-fluid">
    <?php }else { ?>
        <div class="container">
    <?php
    }    ?>
            <div class="row">
                <?php echo wpb_js_remove_wpautop($content); ?>
            </div>
        </div>
</section>

<?php
elseif($cth_layout === 'fullwidth_video_parallax_sec'):

$el_class = $this->getExtraClass( $el_class );

$css_classes = array(
    'lambert_sec lambert_page_sec',
    'parallax-section parallax-video-bg',
    $el_class,
    vc_shortcode_custom_css_class( $css ),
);
if($no_padding == 'yes'){
    $css_classes[] = 'no-padding';
}

if ( 'yes' === $disable_element ) {
    if ( vc_is_page_editable() ) {
        $css_classes[] = 'vc_hidden-lg vc_hidden-xs vc_hidden-sm vc_hidden-md';
    } else {
        return '';
    }
}


$css_class = preg_replace( '/\s+/', ' ', implode( ' ', array_filter( $css_classes ) ) );
?>
<section <?php
    echo isset($el_id) && !empty($el_id) ? "id='" . esc_attr($el_id) . "'" : ""; ?> <?php
    echo !empty($css_class) ? "class='" . esc_attr( trim( $css_class ) ) . "'" : ""; ?>>
    <?php if(!empty($bg_video)) :
    if ($parallax_inner_val == '') {
        $parallax_inner_val = 0;
    }
    ?>
        <div class="media-container video-parallax" data-top-bottom="transform: translateY(<?php echo esc_attr($parallax_inner_val);?>px);" data-bottom-top="transform: translateY(<?php echo 0-$parallax_inner_val;?>px);">
            <div class="video-container">
                <div class="bg mob-bg" style="background-image:url(<?php echo esc_url( wp_get_attachment_url($parallax_inner ) );?>)"></div>
            <?php if($video_type == 'hosted'):?>
                <video autoplay  loop <?php echo $is_mute == '1' ? ' muted' : '';?>   class="bgvid">
                    <source src="<?php echo esc_url($bg_video );?>" type="video/mp4">
                </video>
            <?php elseif($video_type == 'vimeo') :?>
                <div class="video-holder">
                    <iframe src="http://player.vimeo.com/video/<?php echo esc_attr($bg_video );?>?autoplay=1&amp;loop=1" webkitallowfullscreen mozallowfullscreen allowfullscreen class="vimeo-player"></iframe>
                </div>
            <?php else :?>
                <div  class="background-video" data-vid="<?php echo esc_attr($bg_video );?>" data-mv="<?php echo esc_attr( $is_mute );?>"></div>
            <?php endif;?>
            </div>
        </div>
        <div class="overlay" style="opacity:<?php echo esc_attr($parallax_inner_op );?>;"></div>
    <?php endif;?> 
    <?php 
        if ( ! empty( $full_width ) ) { ?>
        <div class="container-fluid">
    <?php }else { ?>
        <div class="container">
    <?php
    }    ?>
            <div class="row">
                <?php echo wpb_js_remove_wpautop($content); ?>
            </div>
        </div>
</section>
<?php
else :
    
    wp_enqueue_script( 'wpb_composer_front_js' );

    $el_class = $this->getExtraClass( $el_class );

    $css_classes = array(
        'vc_row',
        'wpb_row', //deprecated
        'vc_row-fluid',
        $el_class,
        vc_shortcode_custom_css_class( $css ),
    );

    if ( 'yes' === $disable_element ) {
        if ( vc_is_page_editable() ) {
            $css_classes[] = 'vc_hidden-lg vc_hidden-xs vc_hidden-sm vc_hidden-md';
        } else {
            return '';
        }
    }

    if (vc_shortcode_custom_css_has_property( $css, array('border', 'background') ) || $video_bg || $parallax) {
        $css_classes[]='vc_row-has-fill';
    }

    if (!empty($atts['gap'])) {
        $css_classes[] = 'vc_column-gap-'.$atts['gap'];
    }

    $wrapper_attributes = array();
    // build attributes for wrapper
    if ( ! empty( $el_id ) ) {
        $wrapper_attributes[] = 'id="' . esc_attr( $el_id ) . '"';
    }
    if ( ! empty( $full_width ) ) {
        $wrapper_attributes[] = 'data-vc-full-width="true"';
        $wrapper_attributes[] = 'data-vc-full-width-init="false"';
        if ( 'stretch_row_content' === $full_width ) {
            $wrapper_attributes[] = 'data-vc-stretch-content="true"';
        } elseif ( 'stretch_row_content_no_spaces' === $full_width ) {
            $wrapper_attributes[] = 'data-vc-stretch-content="true"';
            $css_classes[] = 'vc_row-no-padding';
        }
        $after_output .= '<div class="vc_row-full-width vc_clearfix"></div>';
    }

    if ( ! empty( $full_height ) ) {
        $css_classes[] = 'vc_row-o-full-height';
        if ( ! empty( $columns_placement ) ) {
            $flex_row = true;
            $css_classes[] = 'vc_row-o-columns-' . $columns_placement;
            if ( 'stretch' === $columns_placement ) {
                $css_classes[] = 'vc_row-o-equal-height';
            }
        }
    }

    if ( ! empty( $equal_height ) ) {
        $flex_row = true;
        $css_classes[] = 'vc_row-o-equal-height';
    }

    if ( ! empty( $content_placement ) ) {
        $flex_row = true;
        $css_classes[] = 'vc_row-o-content-' . $content_placement;
    }

    if ( ! empty( $flex_row ) ) {
        $css_classes[] = 'vc_row-flex';
    }

    $has_video_bg = ( ! empty( $video_bg ) && ! empty( $video_bg_url ) && vc_extract_youtube_id( $video_bg_url ) );

    $parallax_speed = $parallax_speed_bg;
    if ( $has_video_bg ) {
        $parallax = $video_bg_parallax;
        $parallax_speed = $parallax_speed_video;
        $parallax_image = $video_bg_url;
        $css_classes[] = 'vc_video-bg-container';
        wp_enqueue_script( 'vc_youtube_iframe_api_js' );
    }

    if ( ! empty( $parallax ) ) {
        wp_enqueue_script( 'vc_jquery_skrollr_js' );
        $wrapper_attributes[] = 'data-vc-parallax="' . esc_attr( $parallax_speed ) . '"'; // parallax speed
        $css_classes[] = 'vc_general vc_parallax vc_parallax-' . $parallax;
        if ( false !== strpos( $parallax, 'fade' ) ) {
            $css_classes[] = 'js-vc_parallax-o-fade';
            $wrapper_attributes[] = 'data-vc-parallax-o-fade="on"';
        } elseif ( false !== strpos( $parallax, 'fixed' ) ) {
            $css_classes[] = 'js-vc_parallax-o-fixed';
        }
    }

    if ( ! empty( $parallax_image ) ) {
        if ( $has_video_bg ) {
            $parallax_image_src = $parallax_image;
        } else {
            $parallax_image_id = preg_replace( '/[^\d]/', '', $parallax_image );
            $parallax_image_src = wp_get_attachment_image_src( $parallax_image_id, 'full' );
            if ( ! empty( $parallax_image_src[0] ) ) {
                $parallax_image_src = $parallax_image_src[0];
            }
        }
        $wrapper_attributes[] = 'data-vc-parallax-image="' . esc_attr( $parallax_image_src ) . '"';
    }
    if ( ! $parallax && $has_video_bg ) {
        $wrapper_attributes[] = 'data-vc-video-bg="' . esc_attr( $video_bg_url ) . '"';
    }
    $css_class = preg_replace( '/\s+/', ' ', apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, implode( ' ', array_filter( array_unique( $css_classes ) ) ), $this->settings['base'], $atts ) );
    $wrapper_attributes[] = 'class="' . esc_attr( trim( $css_class ) ) . '"';

    $output .= '<div class="clearfix"></div><div ' . implode( ' ', $wrapper_attributes ) . '>';
    $output .= wpb_js_remove_wpautop( $content );
    $output .= '</div>';
    $output .= $after_output;

    $output .= '<div class="clearfix"></div>';

    echo $output;



endif; ?>