<?php
$el_class = $css = $count = $order_by = $order = $ids = $show_avatar = $show_title = $show_rating = '';
$items = $autoplay = $autoplayspeed = $autoplaytimeout = $responsive = $autoheight = $loop = $nav = $dots = $smartspeed = $center = $autowidth =  $slideby = '';
$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$css_classes = array(
    'testimonials-slider-wrap',
    $el_class,
    vc_shortcode_custom_css_class( $css ),
);
$css_class = preg_replace( '/\s+/', ' ', implode( ' ', array_filter( $css_classes ) ) );

$dataArr = array();

if($autoplayspeed == 'true'){
    $dataArr['autoplaySpeed'] = true;
}elseif(is_numeric($autoplayspeed)){
    $dataArr['autoplaySpeed'] = (int)$autoplayspeed;
}
$dataArr['autoplayTimeout'] = (int)$autoplaytimeout;
if($autoheight === 'yes'){
    $dataArr['autoHeight'] = true;
}else{
    $dataArr['autoHeight'] = false;
}
if($autoplay === 'yes'){
    $dataArr['autoplay'] = true;
}else{
    $dataArr['autoplay'] = false;
}
$dataArr['items'] = (int)$items;
if(!empty($responsive)){
    $el_class .=' resp-ena';
    $dataArr['responsive'] = $responsive;
}else{
    $dataArr['responsive'] = false;
}
if($loop === 'yes'){
    $dataArr['loop'] = true;
}else{
    $dataArr['loop'] = false;
}
if($nav === 'yes'){
    $dataArr['nav'] = true;
}else{
    $dataArr['nav'] = false;
}
if($dots === 'yes'){
    $dataArr['dots'] = true;
}else{
    $dataArr['dots'] = false;
}
if($center === 'yes'){
    $dataArr['center'] = true;
}else{
    $dataArr['center'] = false;
}
if($autowidth === 'yes'){
    $dataArr['autoWidth'] = true;
}else{
    $dataArr['autoWidth'] = false;
}

$dataArr['smartSpeed'] = (int)$smartspeed;
$dataArr['slideBy'] = (int)$slideby;


if(!empty($ids)){
	$ids = explode(",", $ids);
	$args = array(
	    'post_type'		 => 'testimonial',
	    'post__in' => $ids,
	    'orderby'=> $order_by,
	    'order'=> $order,
	);
}else{
	$args = array(
	    'post_type'		 => 'testimonial',
	    'posts_per_page' => $count,
	    'orderby'=> $order_by,
	    'order'=> $order,
	);
}
$testimonials = new WP_Query($args);
if($testimonials->have_posts()) {  

?>

<div class="<?php echo esc_attr($css_class ); ?>">
	<div class="testimonials-holder">
	<?php  if($nav != 'yes') : ?>
	    <div class="customNavigation">
	        <a class="prev-slide transition"><i class="fa fa-long-arrow-left"></i></a>
	        <a class="next-slide transition"><i class="fa fa-long-arrow-right"></i></a>
	    </div>
	<?php endif;?>
	    <div class="testimonials-slider owl-carousel refrestonresizeowl" data-options='<?php echo json_encode($dataArr);?>'>
	        <?php        
	        while($testimonials->have_posts()) : $testimonials->the_post();  
	        ?>
	        <div class="item">
	            <div class="testi-item">
	            <?php if($show_avatar == 'yes') :?>
	                <?php the_post_thumbnail('thumbnail' ); ?>
	            <?php endif;?>
	            <?php if($show_title === 'yes') :?>
	                <h3><?php the_title( );?></h3>
	            <?php endif;?>
	                <?php 
	                if($show_rating === 'yes') :
	                    $rated = get_post_meta(get_the_id(), '_cmb_testim_rate', true ); 
	                    if($rated != '' && $rated != 'no'){
	                        $ratedval = floatval($rated);
	                        echo '<ul class="star-rating">';
	                        for ($i=1; $i <= 5; $i++) { 
	                            if($i <= $ratedval){
	                                echo '<li><i class="fa fa-star"></i></li>';
	                            }else{
	                                if($i - 0.5 == $ratedval){
	                                    echo '<li><i class="fa fa-star-half-o"></i></li>';
	                                }else{
	                                	echo '<li><i class="fa fa-star-o"></i></li>';
	                                }
	                            }
	                            
	                        }
	                        echo '</ul>';
	                    }else{
	                        esc_html_e('Not Rated','lambert-add-ons' );
	                    }

	                endif;

	                ?>
	                <?php the_content( ); ?>
	            </div>
	        </div>

	        <?php 
	        endwhile; ?>
	    </div>
	</div>
	<div class="section-icon"><i class="fa fa-quote-left"></i></div>
</div>

<?php
}
/* Restore original Post Data */
wp_reset_postdata();