<?php
/**
 * Shortcode attributes
 * @var $atts
 * @var $el_class
 * @var $count
 * @var $order_by
 * @var $order
 * @var $ids
 * @var $columns
 * Shortcode class
 * @var $this WPBakeryShortCode_Cth_team
 */
$el_class = $count = $order_by = $order = $ids = $columns = $dis_popup = '';
$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

if(!empty($ids)){
	$ids = explode(",", $ids);
	$args = array(
	    'post_type'		 => 'member',
	    'post__in' => $ids,
	    'orderby'=> $order_by,
	    'order'=> $order,
	);
}else{
	$args = array(
	    'post_type'		 => 'member',
	    'posts_per_page' => $count,
	    'orderby'=> $order_by,
	    'order'=> $order,
	);
}
$members = new WP_Query($args);
$wpml                         = apply_filters( 'wpml_current_language', null );
?>
<?php if($members->have_posts()) {       ?>
    <div  class="team-links">
    <?php        
    while($members->have_posts()) : $members->the_post();  
        $mem_job = get_post_meta(get_the_ID(),'_cmb_mem_job',true);
    ?>
    	<div class="team-item item<?php echo esc_attr($columns );?>">
        <?php if($dis_popup == 'yes') :?>
            <a href="<?php the_permalink();?>">
            <span class="team-details"><?php _e('More info','lambert-add-ons');?></span>
        <?php else :?>
            <a href="<?php echo admin_url('admin-ajax.php');?>?action=lambert_member_popup&amp;id=<?php the_id();?>&amp;lang=<?php echo $wpml; ?>" class="popup-with-move-anim">
            <span class="team-details"><?php _e('More info','lambert-add-ons');?></span>
        <?php endif;?>
            
            <?php the_post_thumbnail('member-thumb',array('class'=>'res-image') ); ?>
            
            <span class="chefname"><?php the_title( );?></span>
            <?php if(!empty($mem_job)) :?>
            <span class="chefinfo"><?php echo wp_kses_post( $mem_job );?></span>
            <?php endif;?>
            </a>
        </div>

<?php 
    endwhile; ?>
    </div>
<?php
}

/* Restore original Post Data */
wp_reset_postdata();

?>
