<?php
/**
 * Shortcode attributes
 * @var $atts
 * @var $el_class
 * @var $el_id
 * @var $layout
 * @var $autoplay
 * @var $issingle
 * @var $itemscustom
 * @var $slidespeed
 * Shortcode class
 * @var $this WPBakeryShortCode_Lambert_Owl_Carousel_Images
 */
$el_class = $css = $el_id = $layout = $autoplay = $issingle = $itemscustom = $slidespeed = $slider_images = $thumbnail_size = '';
$items = $autoplay = $autoplayspeed = $autoplaytimeout = $responsive = $autoheight = $loop = $nav = $dots = $smartspeed = $center = $autowidth = $slideby = '';
$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$css_classes = array(
    'single-slider-holder',
    $el_class,
    vc_shortcode_custom_css_class( $css ),
);
$css_class = preg_replace( '/\s+/', ' ', implode( ' ', array_filter( $css_classes ) ) );

$dataArr = array();

if($autoplayspeed == 'true'){
    $dataArr['autoplaySpeed'] = true;
}elseif(is_numeric($autoplayspeed)){
    $dataArr['autoplaySpeed'] = (int)$autoplayspeed;
}
$dataArr['autoplayTimeout'] = (int)$autoplaytimeout;
if($autoheight === 'yes'){
    $dataArr['autoHeight'] = true;
}else{
    $dataArr['autoHeight'] = false;
}
if($autoplay === 'yes'){
    $dataArr['autoplay'] = true;
}else{
    $dataArr['autoplay'] = false;
}
$dataArr['items'] = (int)$items;
if(!empty($itemscustom)){
    $el_class .=' resp-ena';
    $dataArr['responsive'] = $itemscustom;
}else{
    $dataArr['responsive'] = false;
}
if($loop === 'yes'){
    $dataArr['loop'] = true;
}else{
    $dataArr['loop'] = false;
}
if($nav === 'yes'){
    $dataArr['nav'] = true;
}else{
    $dataArr['nav'] = false;
}
if($dots === 'yes'){
    $dataArr['dots'] = true;
}else{
    $dataArr['dots'] = false;
}
if($center === 'yes'){
    $dataArr['center'] = true;
}else{
    $dataArr['center'] = false;
}
if($autowidth === 'yes'){
    $dataArr['autoWidth'] = true;
}else{
    $dataArr['autoWidth'] = false;
}

$dataArr['smartSpeed'] = (int)$slidespeed;
$dataArr['slideBy'] = (int)$slideby;
?>
<?php
if(!empty($slider_images)){
$images = explode(",", $slider_images);

if(!empty($images)) : 

if( strpos($thumbnail_size, "x") !== false){
    $thumbnail_size = explode("x", $thumbnail_size);
}

?>

<div <?php if(!empty($el_id)) echo ' id="'.esc_attr($el_id).'" ';?> class="<?php echo esc_attr($css_class );?>">
    <div class="single-slider owl-carousel refrestonresizeowl" data-options='<?php echo json_encode($dataArr);?>'>
        <?php foreach ($images as $key => $img) {
            $at_img = get_post($img);

            // $at_tit = $at_img->post_title;
            // $at_cap = $at_img->post_excerpt;
            $at_des = $at_img->post_content;
        ?>
        <div class="item">
            <?php echo wp_get_attachment_image( $img, $thumbnail_size, false , array('class'=>'res-image') );?>
            <?php
            if($at_des) echo '<div class="slide-item-cap">' . $at_des . '</div>';
            ?>
        </div>

        <?php
        } ?>
    </div>
</div>
<?php
    endif;
}

?>