<?php
$css = $el_class = $cat_ids = $order = $order_by = $ids = $ids_not = $posts_per_page = $show_pagination =  $columns_grid = $show_loadmore  = $lmore_items = $show_filter = $spacing = $enable_gallery = '';
$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

if(is_front_page()) {
    $paged = (get_query_var('page')) ? get_query_var('page') : 1;
} else {
    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
}

if(!empty($ids)){
    $ids = explode(",", $ids);
    $post_args = array(
        'post_type' => 'cthgallery',
        'paged' => $paged,
        'posts_per_page'=> $posts_per_page,
        'post__in' => $ids,
        'orderby'=> $order_by,
        'order'=> $order,
    );
}elseif(!empty($ids_not)){
    $ids_not = explode(",", $ids_not);
    $post_args = array(
        'post_type' => 'cthgallery',
        'paged' => $paged,
        'posts_per_page'=> $posts_per_page,
        'post__not_in' => $ids_not,
        'orderby'=> $order_by,
        'order'=> $order,
    );
}else{
    $post_args = array(
        'post_type' => 'cthgallery',
        'paged' => $paged,
        'posts_per_page'=> $posts_per_page,
        'orderby'=> $order_by,
        'order'=> $order,
    );
}





if(!empty($cat_ids)){
    $term_args = array(
            'taxonomy'=> 'cthgallery_cat',
            'orderby'           => lambert_global_var('gallery_filter_orderby'), 
            'order'             => lambert_global_var('gallery_filter_order'),
            'include'           => $cat_ids,
            
        ); 

    $post_args['tax_query'][] = array(
            'taxonomy' => 'cthgallery_cat',
            'field' => 'term_id',
            'terms' => explode(',', $cat_ids),
        );
}else{
    $term_args = array(
        'taxonomy'=> 'cthgallery_cat',
        'orderby'           => lambert_global_var('gallery_filter_orderby'), 
        'order'             => lambert_global_var('gallery_filter_order'),
        
    );
}



$css_classes = array(
    'gallery-items',
    $el_class,
    //vc_shortcode_custom_css_class( $css ),
    $columns_grid.'-coulms',
    'grid-'.$spacing.'-pad'
);
if($enable_gallery == 'yes') $css_classes[] = 'popup-gallery';
$lmore_data = false;
if($show_loadmore == 'yes' && $posts_per_page != '-1'){
    $lmore_data = $post_args;
    $lmore_data['action'] = 'lambert_lm_gal';
    $lmore_data['lmore_items'] = $lmore_items;
    $lmore_data['enable_gallery'] = $enable_gallery;

}
$css_class = preg_replace( '/\s+/', ' ', implode( ' ', array_filter( $css_classes ) ) );

?>

<section class="no-padding <?php echo vc_shortcode_custom_css_class( $css );?>">
    <div class="containers container-gallery">

		<?php    
		if($show_filter == 'yes') : 

		    $cthgallery_cats = get_terms($term_args); 

		?>
		<?php if(count($cthgallery_cats)): ?>
		<div class="gallery-filters">
            <a href="#" class="gallery-filter gallery-filter-active"  data-filter="*"><?php esc_html_e('All','lambert-add-ons' );?></a>		
            <?php foreach($cthgallery_cats as $cthgallery_cat) { ?>
            <a href="#" class="gallery-filter " data-filter=".cthgallery_cat-<?php echo esc_attr($cthgallery_cat->slug ); ?>"><?php echo esc_html($cthgallery_cat->name ); ?></a>
            
            <?php } ?>
        </div>
        <div class="bold-separator"><span></span></div>
		<?php endif; 
		endif; //end showfillter
		?>

		<div class="gallery-grid-wrap">
		    <div class="<?php echo esc_attr($css_class );?>"

		    <?php if($show_loadmore == 'yes' && $posts_per_page != '-1'):?>
		     data-lm-request="<?php echo esc_url(admin_url( 'admin-ajax.php' ) ) ;?>"
		     data-lm-nonce="<?php echo wp_create_nonce( 'lambert_lm_gal' ); ?>"
		     data-lm-settings="<?php echo esc_attr(json_encode($lmore_data) ); ?>"
		    <?php endif;?>
		    >
		    <?php 
		        
		        $gal_posts = new WP_Query($post_args); ?>
		        <?php if($gal_posts->have_posts()) : ?>
		            <div class="grid-sizer"></div>
		            <div class="grid-sizer-second"></div>
		            <div class="grid-sizer-three"></div>
		            <?php while($gal_posts->have_posts()) : $gal_posts->the_post(); ?>
		                
		                <?php 
		                lambert_get_template_part( 'template-parts/gal/list', '', array( 'enable_gallery'=>$enable_gallery ) ); 
		                ?>

		            <?php endwhile; ?>

		        <?php endif; ?> 

		    </div>
		    <?php if($show_pagination == 'yes'){lambert_custom_pagination($gal_posts->max_num_pages,$range = 2,$gal_posts ); } ?>
		    <?php if($show_loadmore == 'yes' && ($posts_per_page != '-1'&& $gal_posts->found_posts && $gal_posts->found_posts > $posts_per_page )): ?>
		    <div class="gal-grid-lmore-holder">
		        <a class="load-more-post gal-load-more" data-click="1" href="#" data-remain="yes"><?php echo wp_kses(__('<i class="fa fa-refresh fa-spin" aria-hidden="true"></i> <span>Load more galleries</span>','lambert-add-ons'), array('i'=>array('class'=>array()),'span'=>array('class'=>array()),) );?></a>
		    </div>
		    <?php endif; ?>
		    <?php wp_reset_postdata();?>
		</div>

	</div>
</section>
