<?php
/**
 * Shortcode attributes
 * @var $atts
 * @var $el_class
 * @var $controls
 * @var $mute
 * @var $video
 * @var $bgimg
 * @var $containment
 * @var $autoplay
 * @var $video_type
 * Shortcode class
 * @var $this WPBakeryShortCode_Lambert_Home_Video
 */
$video_type = $video = $containment = $autoplay = $mute = $el_class = $bgimg = $parallax_val = '';
$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

if ($parallax_val == '') {
    $parallax_val = 0;
}
?>
<div class="media-container <?php echo esc_attr($el_class );?>" data-top-bottom="transform: translateY(<?php echo esc_attr($parallax_val);?>px);" data-bottom-top="transform: translateY(<?php echo 0-$parallax_val;?>px);">
  <div class="video-container">
    <div class="bg mob-bg" 
    <?php if(!empty($bgimg)) : ?>
    style="background-image:url(<?php echo wp_get_attachment_url($bgimg );?>);"
  <?php endif;?>></div>
  <?php if($video_type == 'vimeo') :?>
  	<div class="video-holder">
        <iframe src="http://player.vimeo.com/video/<?php echo esc_attr($video );?>?autoplay=<?php echo (int)$autoplay;?>&amp;loop=1&amp;autopause=0" webkitallowfullscreen mozallowfullscreen allowfullscreen class="vimeo-player"></iframe>
    </div>
  	
  <?php else :?>
    <div  class="background-video" data-vid="<?php echo esc_html($video );?>" data-mv="<?php echo esc_attr($mute );?>"></div>
  <?php endif;?>
  </div>
</div>
<?php echo wp_kses_post(rawurldecode(base64_decode(strip_tags($content))) );?>