<?php
/**
 * Shortcode attributes
 * @var $atts
 * @var $el_class
 * @var $el_id
 * @var $items
 * @var $autoplay
 * @var $issingle
 * @var $itemscustom
 * @var $slidespeed
 * Shortcode class
 * @var $this WPBakeryShortCode_Lambert_Owl_Carousel
 */
$el_class = $css = $el_id = $items = $issingle = $itemscustom = $slidespeed = $parallax_val = $thumbnail_size = '';
$items = $autoplay = $autoplayspeed = $autoplaytimeout = $responsive = $autoheight = $loop = $nav = $dots = $smartspeed = $center = $autowidth = $slideby = '';
$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$css_classes = array(
    'fullheight-carousel-holder',
    $el_class,
    vc_shortcode_custom_css_class( $css ),
);
$css_class = preg_replace( '/\s+/', ' ', implode( ' ', array_filter( $css_classes ) ) );

// if( strpos($thumbnail_size, "x") !== false){
//     $thumbnail_size = explode("x", $thumbnail_size);
// }

$dataArr = array();

if($autoplayspeed == 'true'){
    $dataArr['autoplaySpeed'] = true;
}elseif(is_numeric($autoplayspeed)){
    $dataArr['autoplaySpeed'] = (int)$autoplayspeed;
}
$dataArr['autoplayTimeout'] = (int)$autoplaytimeout;
if($autoheight === 'yes'){
    $dataArr['autoHeight'] = true;
}else{
    $dataArr['autoHeight'] = false;
}
if($autoplay === 'yes'){
    $dataArr['autoplay'] = true;
}else{
    $dataArr['autoplay'] = false;
}
$dataArr['items'] = (int)$items;
if(!empty($itemscustom)){
    $el_class .=' resp-ena';
    $dataArr['responsive'] = $itemscustom;
}else{
    $dataArr['responsive'] = false;
}
if($loop === 'yes'){
    $dataArr['loop'] = true;
}else{
    $dataArr['loop'] = false;
}
if($nav === 'yes'){
    $dataArr['nav'] = true;
}else{
    $dataArr['nav'] = false;
}
if($dots === 'yes'){
    $dataArr['dots'] = true;
}else{
    $dataArr['dots'] = false;
}
if($center === 'yes'){
    $dataArr['center'] = true;
}else{
    $dataArr['center'] = false;
}
if($autowidth === 'yes'){
    $dataArr['autoWidth'] = true;
}else{
    $dataArr['autoWidth'] = false;
}

$dataArr['smartSpeed'] = (int)$slidespeed;
$dataArr['slideBy'] = (int)$slideby;

if ($parallax_val == '') {
    $parallax_val = 0;
}

?>

<div <?php if(!empty($el_id)) echo ' id="'.esc_attr($el_id).'" ';?> class="<?php echo esc_attr($css_class );?>" data-top-bottom="transform: translateY(<?php echo esc_attr($parallax_val);?>px);" data-bottom-top="transform: translateY(<?php echo 0-$parallax_val;?>px);">
<?php if($nav !== 'yes') : ?>
    <div class="customNavigation">
        <a class="prev-slide transition"><i class="fa fa-long-arrow-left"></i></a>
        <a class="next-slide transition"><i class="fa fa-long-arrow-right"></i></a>
    </div>
<?php endif;?>
    <div class="fullheight-carousel owl-carousel refrestonresizeowl" data-options='<?php echo json_encode($dataArr);?>'>
        <?php echo wpb_js_remove_wpautop($content);?>
    </div>
</div>
