<?php
/**
 * Shortcode attributes
 * @var $atts
 * @var $el_class
 * @var $zoom
 * @var $latitude
 * @var $longitude
 * @var $address
 * @var $add_address
 * @var $marker
 * @var $parallax_val
 * Shortcode class
 * @var $this WPBakeryShortCode_Lambert_Gmap
 */
$el_class = $zoom = $latitude = $longitude = $address = $add_address = $marker = $parallax_val = '';
$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );
if(!empty($marker)){
	$marker = wp_get_attachment_url($marker );
}else{
	$marker = get_template_directory_uri() ."/assets/images/marker.png";
}
if ($parallax_val == '') {
    $parallax_val = 0;
}
?>
<div class="map-box <?php echo esc_attr($el_class ); ?>">
    <div class="map-holder" data-top-bottom="transform: translateY(<?php echo esc_attr($parallax_val);?>px);" data-bottom-top="transform: translateY(<?php echo 0-$parallax_val;?>px);">
        <div class="lambert_gmap map-canvas" data-latitude="<?php echo esc_attr($latitude );?>" data-longitude="<?php echo esc_attr($longitude);?>" data-location="<?php echo esc_attr($address);?>" data-zoom="<?php echo esc_attr($zoom);?>" data-marker="<?php echo esc_url($marker );?>" data-add="<?php echo esc_attr($add_address );?>"></div>
    </div>
</div>