<?php
/**
 * Shortcode attributes
 * @var $atts
 * @var $el_class
 * @var $title
 * @var $price
 * @var $sale
 * @var $desimg
 * Shortcode class
 * @var $this WPBakeryShortCode_Cth_Menu
 */
$el_class = $title = $price = $sale = $desimg = '';
$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

if(!empty($sale)){
    $el_class .= ' hot-deal';
}
?>
<div class="mn-menu-item <?php echo esc_attr($el_class );?>">
    <?php if(!empty($sale)):?>
        <span class="hot-desc"><?php echo esc_attr($sale );?></span>
    <?php endif;?>
    <div class="mn-menu-item-details">
        <div class="mn-menu-item-desc">
        <?php if(!empty($desimg)) :?>
            <a href="<?php echo wp_get_attachment_url($desimg );?>" class="image-popup">
        <?php endif;?>
                <?php echo esc_attr($title );?>
        <?php if(!empty($desimg)) :?>
            </a>
        <?php endif;?>
        </div>
        <div class="mn-menu-item-dot mn-menu-dot"></div>
        <?php if(!empty($price)) :?>
        <div class="mn-menu-item-prices">
            <div class="mn-menu-item-price"><?php echo esc_attr($price );?></div>
        </div>
        <?php endif;?>
    </div>
    <?php echo wpb_js_remove_wpautop($content,true); ?>
</div>