<?php
/* banner-php */

//For cthgallery_cat taxonomy
//https://make.wordpress.org/core/2015/09/04/taxonomy-term-metadata-proposal/
// Add term page
function lambert_cthgallery_cat_add_new_meta_field() {
    
    cth_select_media_file_field('cat_header_image',esc_html__('Header Background Image','lambert-add-ons'), array());
    
}
add_action('cthgallery_cat_add_form_fields', 'lambert_cthgallery_cat_add_new_meta_field', 10, 2);

// Edit term page
function lambert_cthgallery_cat_edit_meta_field($term) {
    
    // put the term ID into a variable
    $t_id = $term->term_id;
    
    // retrieve the existing value(s) for this meta field. This returns an array
    $term_meta = get_option("_lambert_taxonomy_cthgallery_cat_$t_id");
    
    cth_select_media_file_field('cat_header_image',esc_html__('Header Background Image','lambert-add-ons'), $term_meta,false);

}
add_action('cthgallery_cat_edit_form_fields', 'lambert_cthgallery_cat_edit_meta_field', 10, 2);

// Save extra taxonomy fields callback function.
function lambert_save_cthgallery_cat_custom_meta($term_id) {
    if (isset($_POST['term_meta'])) {
        $t_id = $term_id;
        $term_meta = get_option("_lambert_taxonomy_cthgallery_cat_$t_id");
        $cat_keys = array_keys($_POST['term_meta']);
        foreach ($cat_keys as $key) {
            if (isset($_POST['term_meta'][$key])) {
                $term_meta[$key] = $_POST['term_meta'][$key];
            }
        }
        
        // Save the option array.
        update_option("_lambert_taxonomy_cthgallery_cat_$t_id", $term_meta);
    }
}
add_action('edited_cthgallery_cat', 'lambert_save_cthgallery_cat_custom_meta', 10, 2);
add_action('edited_cthgallery_cat', 'lambert_save_cthgallery_cat_custom_meta', 10, 2);
