<?php
/* banner-php */

//For category taxonomy
// Add term page
function lambert_category_add_new_meta_field() {
    
    cth_select_media_file_field('cat_header_image',esc_html__('Header Background Image','lambert-add-ons'), array());
}
add_action('category_add_form_fields', 'lambert_category_add_new_meta_field', 10, 2);

// Edit term page
function lambert_category_edit_meta_field($term) {
    
    // put the term ID into a variable
    $t_id = $term->term_id;
    
    // retrieve the existing value(s) for this meta field. This returns an array
    $term_meta = get_option("taxonomy_category_$t_id");

    cth_select_media_file_field('cat_header_image',esc_html__('Header Background Image','lambert-add-ons'), $term_meta,false);
}
add_action('category_edit_form_fields', 'lambert_category_edit_meta_field', 10, 2);

// Save extra taxonomy fields callback function.
function lambert_save_category_custom_meta($term_id) {
    if (isset($_POST['term_meta'])) {
        $t_id = $term_id;
        $term_meta = get_option("taxonomy_category_$t_id");
        $cat_keys = array_keys($_POST['term_meta']);
        foreach ($cat_keys as $key) {
            if (isset($_POST['term_meta'][$key])) {
                $term_meta[$key] = $_POST['term_meta'][$key];
            }
        }
        
        // Save the option array.
        update_option("taxonomy_category_$t_id", $term_meta);
    }
}
add_action('edited_category', 'lambert_save_category_custom_meta', 10, 2);
add_action('create_category', 'lambert_save_category_custom_meta', 10, 2);
