<?php
/* add_ons_php */

class Bbt_Class_Reservation_CPT extends Bbt_Class_CPT
{
    protected $name = 'cth_reservation';
    protected function init(){
        parent::init();
        // add_action( 'init', array($this, 'taxonomies'), 0 );
        // add_filter('manage_edit-portfolio_cat_columns', array($this, 'tax_cat_columns_head') );
        // add_filter('manage_portfolio_cat_custom_column', array($this, 'tax_cat_columns_content'), 10, 3);
        add_filter('single_template', array($this, 'single_template'));

        // add_filter('use_block_editor_for_post_type', array($this, 'enable_gutenberg'), 10, 2 );

        add_filter( 'manage_edit-cth_reservation_sortable_columns', array($this, 'sortable_columns') );
        add_action( 'pre_get_posts', array($this, 'sort_order') );
    }
    public function enable_gutenberg($current_status, $post_type)
    {
        if ($post_type === 'cth_reservation') {
            return true;
        }

        return $current_status;
    }

    public function single_template($template)
    {
        global $post;
        if ($post->post_type == 'cth_reservation') {
            $template = lambert_addons_get_template_part('templates/single', 'reservation', null, false);
        }
        return $template;
    }

    public function register()
    {

        $labels = array(
            'name'               => __('Reservation', 'lambert-add-ons'),
            'singular_name'      => __('Reservation', 'lambert-add-ons'),
            'add_new'            => __('Add New Reservation', 'lambert-add-ons'),
            'add_new_item'       => __('Add New Reservation', 'lambert-add-ons'),
            'edit_item'          => __('Edit Reservation', 'lambert-add-ons'),
            'new_item'           => __('New Reservation', 'lambert-add-ons'),
            'view_item'          => __('View Reservation', 'lambert-add-ons'),
            'search_items'       => __('Search Reservations', 'lambert-add-ons'),
            'not_found'          => __('No Reservations found', 'lambert-add-ons'),
            'not_found_in_trash' => __('No Reservations found in Trash', 'lambert-add-ons'),
            'parent_item_colon'  => __('Parent Reservation:', 'lambert-add-ons'),
            'menu_name'          => __('Lambert Reservations', 'lambert-add-ons'),
        );

        $args = array(
            'labels'              => $labels,
            'hierarchical'        => false,
            'description'         => 'List Reservations',
            'supports'            => array('title', 'editor' /*, 'custom-fields','comments', 'post-formats'*/),
            //'taxonomies' => array('reservation-cat'),
            'public'              => false,
            'show_ui'             => true,
            'show_in_menu'        => true,
            'menu_position'       => 20,
            'menu_icon'           => 'dashicons-calendar-alt',

            'show_in_nav_menus'   => false,
            'publicly_queryable'  => false,
            'exclude_from_search' => true,
            'has_archive'         => false,
            'query_var'           => false, //false for can not use /?{query_var}={single_post_slug}
            'can_export'          => true,
            'rewrite'             => array('slug' => __('cth_reservation', 'lambert-add-ons'), 'with_front' => false),
            'capability_type'     => 'post',

        );
        register_post_type($this->name, $args);
    }
    protected function set_meta_columns()
    {
        $this->has_columns = true;
    }
    public function meta_columns_head($columns)
    {
        $columns['_date']        = __('Date', 'lambert-add-ons');
        $columns['_time'] = __('Time', 'lambert-add-ons');
        $columns['_status'] = __('Status', 'lambert-add-ons');
        return $columns;
    }
    public function meta_columns_content($column_name, $post_ID)
    {
        if ($column_name == '_date') {
            echo '<strong>'.get_post_meta( $post_ID, 'resdate', true ).'</strong>';
        }
        if ($column_name == '_time') {
            echo '<strong>'.get_post_meta( $post_ID, 'restime', true ).'</strong>';
        }
        if ($column_name == '_status') {
            echo '<strong>'.lambert_addons_get_reservation_status_text( get_post_meta( $post_ID, 'reservation_status', true ) ).'</strong>';
        }
    }

    public function sortable_columns($columns){
        $columns['_date'] = '_date';
        $columns['_status'] = '_status';
     
        //To make a column 'un-sortable' remove it from the array
        //unset($columns['date']);
     
        return $columns;
    }
    public function sort_order($query){
        if( ! is_admin() ) return;
 
        $orderby = $query->get( 'orderby');
     
        if( '_date' == $orderby ) {
            $query->set('meta_key','resdate');
            $query->set('orderby','meta_value meta_value_num');
        }elseif( '_status' == $orderby ) {
            $query->set('meta_key','reservation_status');
            $query->set('orderby','meta_value');
        }
    }
    protected function set_meta_boxes(){
        $this->meta_boxes = array(
            'status'       => array(
                'title'                 => __( 'Reservation Status', 'lambert-add-ons' ),
                'context'               => 'side', // normal - side - advanced
                'priority'              => 'high', // default - high - low
                'callback_args'         => array(),
            ),
        );
    }
    public function cth_reservation_status_callback($post, $args){
        wp_nonce_field( 'cth-cpt-fields', '_cth_cpt_nonce' );
        /*
         * Use get_post_meta() to retrieve an existing value
         * from the database and use the value for the form.
         */
        $value = get_post_meta( $post->ID, 'reservation_status', true );

        $statuses = lambert_addons_get_reservation_statuses();
        ?>
        <table class="form-table lorder-details">
            <tbody>
                <tr class="hoz">
                    <td>
                        <select name="reservation_status" class="w100">
                        <?php 
                        foreach ($statuses as $sts => $lbl) {
                            echo '<option value="'.$sts.'" '.selected( $value, $sts, false ).'>'.$lbl.'</option>';
                        }
                        ?>
                        </select>
                    </td>
                </tr>
                
            </tbody>
        </table>
        <?php 
    }
    public function save_post($post_id, $post, $update){
        if(!$this->can_save($post_id)) return;

        if(isset($_POST['reservation_status'])){
            $new_status = sanitize_text_field( $_POST['reservation_status'] ) ;
            $origin_status = get_post_meta( $post_id, 'reservation_status', true );
            if($new_status !== $origin_status){
                update_post_meta( $post_id, 'reservation_status', $new_status );

                // unhook this function so it doesn't loop infinitely
                remove_action( 'save_post_'.$this->name, array($this, 'save_post'), 10, 3  );
                    do_action('reservation_status_from_'.$origin_status.'_to_'.$new_status, $post_id );
                    do_action('reservation_change_status_to_'.$new_status, $post_id );
                // re-hook this function
                add_action( 'save_post_'.$this->name, array($this, 'save_post'), 10, 3  );
                    
            }
        }

    }

}

new Bbt_Class_Reservation_CPT();
