<?php
/* add_ons_php */

class Bbt_Class_Member_CPT extends Bbt_Class_CPT
{
    protected $name = 'member';
    protected function init()
    {
        parent::init();
        // add_filter('use_block_editor_for_post_type', array($this, 'enable_gutenberg'), 10, 2 );
        // add_filter('pre_get_posts', array($this, 'pre_get_posts'));
    }

    public function pre_get_posts($query)
    {
        if (!is_admin() && $query->is_main_query()) {
            if (is_post_type_archive('member')) {
                $query->set('posts_per_page', lambert_get_option('member_posts_per_page'));
                $query->set('orderby', lambert_get_option('member_archive_orderby'));
                $query->set('order', lambert_get_option('member_archive_order'));

            }
        }
    }

    public function enable_gutenberg($current_status, $post_type)
    {
        if ($post_type === 'member') {
            return true;
        }

        return $current_status;
    }

    public function register()
    {

        $labels = array(
            'name'               => __('Member', 'lambert-add-ons'),
            'singular_name'      => __('Member', 'lambert-add-ons'),
            'add_new'            => __('Add New Member', 'lambert-add-ons'),
            'add_new_item'       => __('Add New Member', 'lambert-add-ons'),
            'edit_item'          => __('Edit Member', 'lambert-add-ons'),
            'new_item'           => __('New Member', 'lambert-add-ons'),
            'view_item'          => __('View Member', 'lambert-add-ons'),
            'search_items'       => __('Search Members', 'lambert-add-ons'),
            'not_found'          => __('No Members found', 'lambert-add-ons'),
            'not_found_in_trash' => __('No Members found in Trash', 'lambert-add-ons'),
            'parent_item_colon'  => __('Parent Member:', 'lambert-add-ons'),
            'menu_name'          => __('Lambert Members', 'lambert-add-ons'),
        );

        $args = array(
            'labels'              => $labels,
            'hierarchical'        => true,
            'description'         => 'List Members',
            'supports'            => array('title', 'editor', 'thumbnail', 'excerpt' /*,'comments', 'post-formats'*/),
            'public'              => true,
            'show_ui'             => true,
            'show_in_menu'        => true,
            'menu_position'       => 20,
            'menu_icon'           => 'dashicons-groups',
            'show_in_nav_menus'   => true,
            'publicly_queryable'  => true,
            'exclude_from_search' => false,
            'has_archive'         => true,
            'query_var'           => true,
            'can_export'          => true,
            'rewrite'             => array('slug' => __('member', 'lambert-add-ons'), 'with_front' => false),
            'capability_type'     => 'post',
        );
        register_post_type($this->name, $args);
    }
    protected function set_meta_columns()
    {
        $this->has_columns = true;
    }
    public function meta_columns_head($columns)
    {
        $columns['_id']        = __('ID', 'lambert-add-ons');
        $columns['_thumbnail'] = __('Thumbnail', 'lambert-add-ons');
        return $columns;
    }
    public function meta_columns_content($column_name, $post_ID)
    {
        if ($column_name == '_id') {
            echo $post_ID;
        }
        if ($column_name == '_thumbnail') {
            echo get_the_post_thumbnail($post_ID, 'thumbnail', array('style' => 'width:100px;height:auto;'));
        }
    }

}

new Bbt_Class_Member_CPT();
