<?php
/* add_ons_php */

class Bbt_Class_CTHMenu_CPT extends Bbt_Class_CPT
{
    protected $name = 'cthmenu';
    protected function init()
    {
        parent::init();
        add_action('init', array($this, 'taxonomies'), 0);
        add_filter('manage_edit-cthmenu_cat_columns', array($this, 'tax_cat_columns_head'));
        add_filter('manage_cthmenu_cat_custom_column', array($this, 'tax_cat_columns_content'), 10, 3);
        // add_filter('single_template', array($this, 'single_template'));
    }
    public function enable_gutenberg($current_status, $post_type)
    {
        if ($post_type === 'cthmenu') {
            return true;
        }

        return $current_status;
    }

    public function single_template($single_template)
    {
        global $post;

        if ($post->post_type == 'cthmenu') {
            $single_template = lambert_addons_get_template_part('template-parts/cthmenu/single', '', null, false);
        }
        return $single_template;
    }

    public function register()
    {

        $labels = array(
            'name'               => __('Menu', 'lambert-add-ons'),
            'singular_name'      => __('Menu', 'lambert-add-ons'),
            'add_new'            => __('Add New Menu', 'lambert-add-ons'),
            'add_new_item'       => __('Add New Menu', 'lambert-add-ons'),
            'edit_item'          => __('Edit Menu', 'lambert-add-ons'),
            'new_item'           => __('New Menu', 'lambert-add-ons'),
            'view_item'          => __('View Menu', 'lambert-add-ons'),
            'search_items'       => __('Search Galleries', 'lambert-add-ons'),
            'not_found'          => __('No Galleries found', 'lambert-add-ons'),
            'not_found_in_trash' => __('No Galleries found in Trash', 'lambert-add-ons'),
            'parent_item_colon'  => __('Parent Menu:', 'lambert-add-ons'),
            'menu_name'          => __('Lambert Menu', 'lambert-add-ons'),
        );

        $args = array(
            'labels'              => $labels,
            'hierarchical'        => true,
            'description'         => 'List Galleries',
            'supports'            => array('title', 'editor', 'thumbnail', 'comments', 'excerpt' /*, 'post-formats'*/),
            'taxonomies'          => array('cthmenu_cat'),
            'public'              => true,
            'show_ui'             => true,
            'show_in_menu'        => true,
            'menu_position'       => 20,
            'menu_icon'           => 'dashicons-images-alt2',
            'show_in_nav_menus'   => true,
            'publicly_queryable'  => true,
            'exclude_from_search' => false,
            'has_archive'         => true,
            'query_var'           => true,
            'can_export'          => true,
            'rewrite'             => array('slug' => __('cthmenu', 'lambert-add-ons')),
            'capability_type'     => 'post',
        );
        register_post_type($this->name, $args);
    }
    public function taxonomies()
    {
        $labels = array(
            'name'              => __('Categories', 'lambert-add-ons'),
            'singular_name'     => __('Category', 'lambert-add-ons'),
            'search_items'      => __('Search Categories', 'lambert-add-ons'),
            'all_items'         => __('All Categories', 'lambert-add-ons'),
            'parent_item'       => __('Parent Category', 'lambert-add-ons'),
            'parent_item_colon' => __('Parent Category:', 'lambert-add-ons'),
            'edit_item'         => __('Edit Category', 'lambert-add-ons'),
            'update_item'       => __('Update Category', 'lambert-add-ons'),
            'add_new_item'      => __('Add New Category', 'lambert-add-ons'),
            'new_item_name'     => __('New Category Name', 'lambert-add-ons'),
            'menu_name'         => __('Categories', 'lambert-add-ons'),
        );

        // Now register the taxonomy

        register_taxonomy('cthmenu_cat', array('cthmenu'), array(
            'hierarchical'      => true,
            'labels'            => $labels,
            'show_ui'           => true,
            'show_in_nav_menus' => true,
            'show_admin_column' => true,
            'query_var'         => true,
            'rewrite'           => array('slug' => __('cthmenu_cat', 'lambert-add-ons'), 'with_front' => false),
        ));

    }
    public function tax_cat_columns_head($columns)
    {
        // $columns['_thumbnail'] = __('Thumbnail','lambert-add-ons');
        $columns['_id'] = __('ID', 'lambert-add-ons');
        return $columns;
    }

    public function tax_cat_columns_content($c, $column_name, $term_id)
    {
        if ($column_name == '_id') {
            echo $term_id;
        }
        // if ($column_name == '_thumbnail') {
        //     $term_meta = get_term_meta( $term_id, BBT_META_PREFIX.'term_meta', true );
        //     if(isset($term_meta['featured_img']) && !empty($term_meta['featured_img'])){
        //         echo wp_get_attachment_image( $term_meta['featured_img']['id'], 'thumbnail', false, array('style'=>'width:100px;height:auto;') );

        //     }
        // }
    }
    protected function set_meta_columns()
    {
        $this->has_columns = true;
    }
    public function meta_columns_head($columns)
    {
        $columns['_id']        = __('ID', 'lambert-add-ons');
        $columns['_thumbnail'] = __('Thumbnail', 'lambert-add-ons');
        return $columns;
    }
    public function meta_columns_content($column_name, $post_ID)
    {
        if ($column_name == '_id') {
            echo $post_ID;
        }
        if ($column_name == '_thumbnail') {
            echo get_the_post_thumbnail($post_ID, 'thumbnail', array('style' => 'width:100px;height:auto;'));
        }
    }

}

new Bbt_Class_CTHMenu_CPT();
