<?php 
/* add_ons_php */


// Plugin Options
/** Step 2 (from text above). */
add_action( 'admin_menu', 'cth_reservation_plugin_menu' );

/** Step 1. */
function cth_reservation_plugin_menu() {
    //Create new option menu

    add_submenu_page( 
        'edit.php?post_type=cth_reservation',
        __('Reservation Options','lambert-add-ons'), // $page_title - (string) (required) The text to be displayed in the title tags of the page when the menu is selected 
        __('Settings (old)','lambert-add-ons'), //  $menu_title - (string) (required) The text to be used for the menu 
        'manage_options', // $capability - (string) (required) The capability required for this menu to be displayed to the user. 
        'cth_reservation', //menu_slug - (string) (required) The slug name to refer to this menu by (should be unique for this menu). 
        'cth_reservation_plugin_options' // $function - (callback) (optional) The function to be called to output the content for this page. 
    );


    // add_options_page( 
    //     __('Lambert Reservation Options','lambert-add-ons'), // $page_title - (string) (required) The text to be displayed in the title tags of the page when the menu is selected 
    //     __('Lambert Reservation','lambert-add-ons'), //  $menu_title - (string) (required) The text to be used for the menu 
    //     'manage_options', // $capability - (string) (required) The capability required for this menu to be displayed to the user. 
    //     'cth_reservation_plugin_menu_slug', //menu_slug - (string) (required) The slug name to refer to this menu by (should be unique for this menu). 
    //     'cth_reservation_plugin_options' // $function - (callback) (optional) The function to be called to output the content for this page. 
    // );
    //call register settings function
    add_action( 'admin_init', 'register_cth_reservation_settings' );
}

function register_cth_reservation_settings() { // whitelist options
    register_setting( 'cth_reservation', '_reservation_form_field' );
    register_setting( 'cth_reservation', '_reservation_show_captcha' );


    register_setting( 'cth_reservation', '_reservation_title_field' );
    register_setting( 'cth_reservation', '_reservation_content_template' );
    
    register_setting( 'cth_reservation', '_reservation_email_sender' );
    register_setting( 'cth_reservation', '_reservation_email_sender_email' );
    register_setting('cth_reservation','_reservation_confirming_email_to' );
    register_setting( 'cth_reservation', '_reservation_confirm_after_booked' );
    register_setting( 'cth_reservation', '_reservation_email_content_type' );


    // confirming
    register_setting( 'cth_reservation', '_reservation_confirming_email' );
    register_setting('cth_reservation','_reservation_confirming_email_subject' );
    register_setting('cth_reservation','_reservation_confirming_email_template' );
    //confirmed
    register_setting( 'cth_reservation', '_reservation_confirmed_email' );
    register_setting('cth_reservation','_reservation_confirmed_email_subject' );
    register_setting('cth_reservation','_reservation_confirmed_email_template' );
    //complete
    register_setting( 'cth_reservation', '_reservation_complete_email' );
    register_setting('cth_reservation','_reservation_complete_email_subject' );
    register_setting('cth_reservation','_reservation_complete_email_template' );

    register_setting('cth_reservation','_reservation_confirmed_page_message' );
}

/** Step 3. */
function cth_reservation_plugin_options() {
    if ( !current_user_can( 'manage_options' ) )  {
        wp_die( __( 'You do not have sufficient permissions to access this page.', 'lambert-add-ons' ) );
    }
    include BBT_ABSPATH .'older_2_dot_4/options.php';
}
