<?php 
/* add_ons_php */


function cth_reservation_email_set_html_content_type() {
    return 'text/html';
}

if(!function_exists('cth_reservation_get_comfirm_code')){
    function cth_reservation_get_comfirm_code($res_id){
        if(is_numeric($res_id)){
            if($res_post = get_post($res_id)){
                return md5($res_id.$res_post->post_name.'maybeyourcompanynamereversed?');
            }else {
                return 'reservation_error';
            }
        }else{
            return 'reservation_error';
        }
        
    }
}

if(!function_exists('cth_reservation_custom_wp_mail_from_name')){
    function cth_reservation_custom_wp_mail_from_name( $original_email_from ) {
        $sender_option = get_option('_reservation_email_sender','Lambert' );
        return $sender_option;
    }
}



add_action('cth_reservation_booked','cth_reservation_booked_action_callback' );
if(!function_exists('cth_reservation_booked_action_callback')){
    function cth_reservation_booked_action_callback($res_id){
        if(get_option('_reservation_confirm_after_booked','yes') == 'yes'){
            
            $sender_option = get_option('_reservation_email_sender','Lambert' );
            $sender_email_option = get_option('_reservation_email_sender_email','contact.cththemes@gmail.com' );

            $to_option = get_option('_reservation_confirming_email_to','email' );
            
            if($mail_to = get_post_meta($res_id, $to_option ,true)){
                
                $subject_meta_option = get_option('_reservation_confirming_email_subject','email_subject_no_exist' );
                $subject_meta = get_post_meta($res_id, $subject_meta_option, true );
                
                if(!empty($subject_meta)){
                    $mail_subject = $subject_meta;
                }else{
                    $mail_subject = $subject_meta_option;
                }
                

                $email_template = get_option('_reservation_confirming_email_template', 'Hi [name],

You received this email because you have booked a table at [resrest] - Restaurant. Bellow is the detail:
<p align="left"><em>Name: [name]</em></p>
<p align="left"><em>Phone: [phone]</em></p>
<p align="left"><em>E-mail: [email]</em></p>
<p align="left"><em>Resturant: [resrest]</em></p>
<p align="left"><em>Reservation Date: [resdate]</em></p>
<p align="left"><em>Reservation Time: [restime]</em></p>
<p align="left"><em>Persons: [numperson]</em></p>
<p align="left"><em><strong>Additional Message</strong></em></p>
<p><em>[comments]</em></p>

<p>To comfirm the reservation please click this link: [reservation_confirm_link]</p>

<p><strong>Sincerely,</strong></p>

<p><strong>Cththemes</strong></p>' ); 

                if(preg_match_all("/\[([\w\-]+)[^\w\-]*\]/", $email_template, $matches)!= FALSE){
                    $fieldsPattern = array();//$matches[0];
                    $fieldsReplace = array();
                    foreach ($matches[1] as $key => $fn) {
                        $fieldsPattern[] = "/\[(".$fn.")[^\w\-]*\]/";
                        if($fn == 'reservation_confirm_link'){
                            $cfkey = cth_reservation_get_comfirm_code($res_id);
                            $cf_page_id = get_option('cth_reservation_page_id' ,'1');
                            //get reservation form page link + reservation_id + confirm code
                            $fieldsReplace[] = get_permalink($cf_page_id, false).esc_url('?resid='.$res_id.'&cfkey='.$cfkey );
                        }else{
                            $m_val = get_post_meta( $res_id, $fn , true );
                            if(!empty($m_val)){
                                $fieldsReplace[] = $m_val;//get_post_meta( $res_id, $fn , true );
                            }else{
                                $fieldsReplace[] = '['.$fn.']';
                            }
                            
                        }
                        
                    }


                    $email_template = preg_replace($fieldsPattern, $fieldsReplace, $email_template);
                }


                $headers = array();
                if(get_option('_reservation_email_content_type','yes' ) == 'yes'){
                    $headers[] = 'Content-Type: text/html; charset=UTF-8';
                }
                //$headers[] = 'From: '. $sender_option.' ' . '<'.$sender_email_option.'>';
                add_filter( 'wp_mail_from_name', 'cth_reservation_custom_wp_mail_from_name' );
                $headers[] = 'Reply-To: '. $sender_option.' ' . '<'.$sender_email_option.'>';

                //$e_return = wp_mail( $mail_to, $mail_subject , $message, $headers);
                $e_return = wp_mail( $mail_to, $mail_subject , $email_template, $headers);
                remove_filter( 'wp_mail_from_name', 'cth_reservation_custom_wp_mail_from_name' );

            }


        }
    }
}

add_action( 'reservation_status_from_booked_to_confirming', 'cth_reservation_booked_to_confirming_action_callback' );
if(!function_exists('cth_reservation_booked_to_confirming_action_callback')){
    function cth_reservation_booked_to_confirming_action_callback($res_id){
        
        if(get_option('_reservation_confirming_email','yes') == 'yes'){
            
            $sender_option = get_option('_reservation_email_sender','Lambert' );
            $sender_email_option = get_option('_reservation_email_sender_email','contact.cththemes@gmail.com');

            $to_option = get_option('_reservation_confirming_email_to','email' );
            
            if($mail_to = get_post_meta($res_id, $to_option ,true)){
                
                $subject_meta_option = get_option('_reservation_confirming_email_subject','email_subject_no_exist' );
                $subject_meta = get_post_meta($res_id, $subject_meta_option, true );
                
                if(!empty($subject_meta)){
                    $mail_subject = $subject_meta;
                }else{
                    $mail_subject = $subject_meta_option;
                }
                

                $email_template = get_option('_reservation_confirming_email_template', 'Hi [name],

You received this email because you have booked a table at [resrest] - Restaurant. Bellow is the detail:
<p align="left"><em>Name: [name]</em></p>
<p align="left"><em>Phone: [phone]</em></p>
<p align="left"><em>E-mail: [email]</em></p>
<p align="left"><em>Resturant: [resrest]</em></p>
<p align="left"><em>Reservation Date: [resdate]</em></p>
<p align="left"><em>Reservation Time: [restime]</em></p>
<p align="left"><em>Persons: [numperson]</em></p>
<p align="left"><em><strong>Additional Message</strong></em></p>
<p><em>[comments]</em></p>

<p>To comfirm the reservation please click this link: [reservation_confirm_link]</p>

<p><strong>Sincerely,</strong></p>

<p><strong>Cththemes</strong></p>'); 

                if(preg_match_all("/\[([\w\-]+)[^\w\-]*\]/", $email_template, $matches)!= FALSE){
                    $fieldsPattern = array();//$matches[0];
                    $fieldsReplace = array();
                    foreach ($matches[1] as $key => $fn) {
                        $fieldsPattern[] = "/\[(".$fn.")[^\w\-]*\]/";
                        if($fn == 'reservation_confirm_link'){
                            $cfkey = cth_reservation_get_comfirm_code($res_id);
                            $cf_page_id = get_option('cth_reservation_page_id' ,'1');
                            //get reservation form page link + reservation_id + confirm code
                            $fieldsReplace[] = get_permalink($cf_page_id, false).esc_url('?resid='.$res_id.'&cfkey='.$cfkey );
                            
                        }else{
                            $m_val = get_post_meta( $res_id, $fn , true );
                            if(!empty($m_val)){
                                $fieldsReplace[] = $m_val;//get_post_meta( $res_id, $fn , true );
                            }else{
                                $fieldsReplace[] = '['.$fn.']';
                            }
                            
                        }
                        
                    }


                    $email_template = preg_replace($fieldsPattern, $fieldsReplace, $email_template);
                }


                $headers = array();
                if(get_option('_reservation_email_content_type','yes' ) == 'yes'){
                    $headers[] = 'Content-Type: text/html; charset=UTF-8';
                }
                //$headers[] = 'From: '. $sender_option.' ' . '<'.$sender_email_option.'>';
                add_filter( 'wp_mail_from_name', 'cth_reservation_custom_wp_mail_from_name' );
                $headers[] = 'Reply-To: '. $sender_option.' ' . '<'.$sender_email_option.'>';

                //$e_return = wp_mail( $mail_to, $mail_subject , $message, $headers);
                $e_return = wp_mail( $mail_to, $mail_subject , $email_template, $headers);
                remove_filter( 'wp_mail_from_name', 'cth_reservation_custom_wp_mail_from_name' );

            }

            
        }
    }

}


add_action( 'reservation_status_from_confirming_to_confirmed', 'cth_reservation_confirming_to_confirmed_action_callback' );
if(!function_exists('cth_reservation_confirming_to_confirmed_action_callback')){
    function cth_reservation_confirming_to_confirmed_action_callback($res_id){
        if(get_option('_reservation_confirmed_email','yes') == 'yes'){

            $sender_option = get_option('_reservation_email_sender','Lambert');
            $sender_email_option = get_option('_reservation_email_sender_email','contact.cththemes@gmail.com' );

            $to_option = get_option('_reservation_confirming_email_to','email' );

            if($mail_to = get_post_meta($res_id, $to_option ,true)){

                $subject_meta_option = get_option('_reservation_confirmed_email_subject','email_subject_no_exist' );
                $subject_meta = get_post_meta($res_id, $subject_meta_option, true );

                if(!empty($subject_meta)){
                    $mail_subject = $subject_meta;
                }else{
                    $mail_subject = $subject_meta_option;
                }

                $email_template = get_option('_reservation_confirmed_email_template', '<p>Hi [name],</p>
<p>Thank you for confirmed your reservation at our [resrest] - Restaurant.</p>
<p><strong>Cththemes</strong></p>' ); 

                if(preg_match_all("/\[([\w\-]+)[^\w\-]*\]/", $email_template, $matches)!= FALSE){
                    $fieldsPattern = array();
                    $fieldsReplace = array();
                    foreach ($matches[1] as $key => $fn) {
                        $fieldsPattern[] = "/\[(".$fn.")[^\w\-]*\]/";
                        $m_val = get_post_meta( $res_id, $fn , true );
                        if(!empty($m_val)){
                            $fieldsReplace[] = $m_val;
                        }else{
                            $fieldsReplace[] = '['.$fn.']';
                        }
                        
                    }

                    $email_template = preg_replace($fieldsPattern, $fieldsReplace, $email_template);
                }

                $headers = array();
                if(get_option('_reservation_email_content_type','yes' ) == 'yes'){
                    $headers[] = 'Content-Type: text/html; charset=UTF-8';
                }
                //$headers[] = 'From: '. $sender_option.' ' . '<'.$sender_email_option.'>';
                add_filter( 'wp_mail_from_name', 'cth_reservation_custom_wp_mail_from_name' );
                $headers[] = 'Reply-To: '. $sender_option.' ' . '<'.$sender_email_option.'>';

                $e_return = wp_mail( $mail_to, $mail_subject , $email_template, $headers);
                remove_filter( 'wp_mail_from_name', 'cth_reservation_custom_wp_mail_from_name' );

            }
        }

    }
}

add_action( 'reservation_status_from_confirmed_to_complete', 'cth_reservation_confirmed_to_complete_action_callback' );
if(!function_exists('cth_reservation_confirmed_to_complete_action_callback')){
    function cth_reservation_confirmed_to_complete_action_callback($res_id){
        if(get_option('_reservation_complete_email','yes') == 'yes'){
            
            $sender_option = get_option('_reservation_email_sender','Lambert' );
            $sender_email_option = get_option('_reservation_email_sender_email','contact.cththemes@gmail.com' );

            $to_option = get_option('_reservation_confirming_email_to','email' );

            if($mail_to = get_post_meta($res_id, $to_option ,true)){

                $subject_meta_option = get_option('_reservation_complete_email_subject','email_subject_no_exist' );
                $subject_meta = get_post_meta($res_id, $subject_meta_option, true );

                if(!empty($subject_meta)){
                    $mail_subject = $subject_meta;
                }else{
                    $mail_subject = $subject_meta_option;
                }

                $email_template = get_option('_reservation_complete_email_template', '<p>Hi [name],</p>
<p>Thank you for your arrival. See you again.</p>
<p><strong>Cththemes</strong></p>' ); 

                if(preg_match_all("/\[([\w\-]+)[^\w\-]*\]/", $email_template, $matches)!= FALSE){
                    $fieldsPattern = array();
                    $fieldsReplace = array();
                    foreach ($matches[1] as $key => $fn) {
                        $fieldsPattern[] = "/\[(".$fn.")[^\w\-]*\]/";
                        $m_val = get_post_meta( $res_id, $fn , true );
                        if(!empty($m_val)){
                            $fieldsReplace[] = $m_val;
                        }else{
                            $fieldsReplace[] = '['.$fn.']';
                        }
                        
                    }

                    $email_template = preg_replace($fieldsPattern, $fieldsReplace, $email_template);
                }

                $headers = array();
                if(get_option('_reservation_email_content_type','yes' ) == 'yes'){
                    $headers[] = 'Content-Type: text/html; charset=UTF-8';
                }
                //$headers[] = 'From: '. $sender_option.' ' . '<'.$sender_email_option.'>';
                add_filter( 'wp_mail_from_name', 'cth_reservation_custom_wp_mail_from_name' );
                $headers[] = 'Reply-To: '. $sender_option.' ' . '<'.$sender_email_option.'>';

                $e_return = wp_mail( $mail_to, $mail_subject , $email_template, $headers);
                remove_filter( 'wp_mail_from_name', 'cth_reservation_custom_wp_mail_from_name' );
            }
        }

    }
}

// admin emails
add_action('cth_reservation_booked','cth_reservation_emails_booked_action_callback' );
if(!function_exists('cth_reservation_emails_booked_action_callback')){
    function cth_reservation_emails_booked_action_callback($res_id){
        //if(get_option('_reservation_confirm_after_booked','yes') == 'yes'){
            
            $sender_option = get_option('_reservation_email_sender','Lambert' );
            $sender_email_option = get_option('_reservation_email_sender_email','contact.cththemes@gmail.com' );

            $to_option = get_option('_emails_reservation_admin_email','email' );
            
            //if($mail_to = get_post_meta($res_id, $to_option ,true)){
                
                $subject_option = get_option('_emails_reservation_admin_subject','New Reservation Booked' );
                //$subject_meta = get_post_meta($res_id, $subject_meta_option, true );
                
                // if(!empty($subject_meta)){
                //     $mail_subject = $subject_meta;
                // }else{
                //     $mail_subject = $subject_meta_option;
                // }
                

                $email_template = get_option('_emails_reservation_admin_template', '<p align="left">New reservation was booked at [resrest] - Restaurant. Bellow is the detail:</p>
<p align="left"><em>Name: [name]</em></p>
<p align="left"><em>Phone: [phone]</em></p>
<p align="left"><em>E-mail: [email]</em></p>
<p align="left"><em>Resturant: [resrest]</em></p>
<p align="left"><em>Reservation Date: [resdate]</em></p>
<p align="left"><em>Reservation Time: [restime]</em></p>
<p align="left"><em>Persons: [numperson]</em></p>
<p align="left"><em><strong>Additional Message</strong></em></p>
<p align="left"><em>[comments]</em></p>' ); 

                if(preg_match_all("/\[([\w\-]+)[^\w\-]*\]/", $email_template, $matches)!= FALSE){
                    $fieldsPattern = array();//$matches[0];
                    $fieldsReplace = array();
                    foreach ($matches[1] as $key => $fn) {
                        $fieldsPattern[] = "/\[(".$fn.")[^\w\-]*\]/";
                        if($fn == 'reservation_confirm_link'){
                            $cfkey = cth_reservation_get_comfirm_code($res_id);
                            $cf_page_id = get_option('cth_reservation_page_id' ,'1');
                            //get reservation form page link + reservation_id + confirm code
                            $fieldsReplace[] = get_permalink($cf_page_id, false).esc_url('?resid='.$res_id.'&cfkey='.$cfkey );
                        }else{
                            $m_val = get_post_meta( $res_id, $fn , true );
                            if(!empty($m_val)){
                                $fieldsReplace[] = $m_val;//get_post_meta( $res_id, $fn , true );
                            }else{
                                $fieldsReplace[] = '['.$fn.']';
                            }
                            
                        }
                        
                    }


                    $email_template = preg_replace($fieldsPattern, $fieldsReplace, $email_template);
                }



                // $user_booked_email = get_post_meta($res_id, get_option('_reservation_confirming_email_to','email' ) , true);



                $headers = array();
                if(get_option('_reservation_email_content_type','yes' ) == 'yes'){
                    $headers[] = 'Content-Type: text/html; charset=UTF-8';
                }
                //$headers[] = 'From: '. $sender_option.' ' . '<'.$sender_email_option.'>';
                add_filter( 'wp_mail_from_name', 'cth_reservation_custom_wp_mail_from_name' );
                $headers[] = 'Reply-To: '. $sender_option.' ' . '<'.$sender_email_option.'>';

                //$e_return = wp_mail( $mail_to, $mail_subject , $message, $headers);
                $e_return = wp_mail( $to_option, $subject_option , $email_template, $headers);
                remove_filter( 'wp_mail_from_name', 'cth_reservation_custom_wp_mail_from_name' );

            //}


        //}
    }
}

add_action( 'reservation_status_from_booked_to_confirming', 'cth_reservation_emails_booked_to_confirming_action_callback' );
if(!function_exists('cth_reservation_emails_booked_to_confirming_action_callback')){
    function cth_reservation_emails_booked_to_confirming_action_callback($res_id){
        
        //if(get_option('_reservation_confirming_email','yes') == 'yes'){
            
            $sender_option = get_option('_reservation_email_sender','Lambert' );
            $sender_email_option = get_option('_reservation_email_sender_email','contact.cththemes@gmail.com');

            $mail_to = get_option('_emails_reservation_admin_email','email' );
            
            //if($mail_to = get_post_meta($res_id, $to_option ,true)){
                
                // $subject_meta_option = get_option('_reservation_confirming_email_subject','email_subject_no_exist' );
                // $subject_meta = get_post_meta($res_id, $subject_meta_option, true );
                
                // if(!empty($subject_meta)){
                //     $mail_subject = $subject_meta;
                // }else{
                //     $mail_subject = $subject_meta_option;
                // }
                $mail_subject = get_option('_emails_reservation_confirming_admin_subject','Reservation Confirming' );
                

                $email_template = get_option('_emails_reservation_confirming_admin_template', 'Hi [name],

You received this email because you have booked a table at [resrest] - Restaurant. Bellow is the detail:
<p align="left"><em>Name: [name]</em></p>
<p align="left"><em>Phone: [phone]</em></p>
<p align="left"><em>E-mail: [email]</em></p>
<p align="left"><em>Resturant: [resrest]</em></p>
<p align="left"><em>Reservation Date: [resdate]</em></p>
<p align="left"><em>Reservation Time: [restime]</em></p>
<p align="left"><em>Persons: [numperson]</em></p>
<p align="left"><em><strong>Additional Message</strong></em></p>
<p><em>[comments]</em></p>

<p>To comfirm the reservation please click this link: [reservation_confirm_link]</p>

<p><strong>Sincerely,</strong></p>

<p><strong>Cththemes</strong></p>'); 

                if(preg_match_all("/\[([\w\-]+)[^\w\-]*\]/", $email_template, $matches)!= FALSE){
                    $fieldsPattern = array();//$matches[0];
                    $fieldsReplace = array();
                    foreach ($matches[1] as $key => $fn) {
                        $fieldsPattern[] = "/\[(".$fn.")[^\w\-]*\]/";
                        if($fn == 'reservation_confirm_link'){
                            $cfkey = cth_reservation_get_comfirm_code($res_id);
                            $cf_page_id = get_option('cth_reservation_page_id' ,'1');
                            //get reservation form page link + reservation_id + confirm code
                            $fieldsReplace[] = get_permalink($cf_page_id, false).esc_url('?resid='.$res_id.'&cfkey='.$cfkey );
                            
                        }else{
                            $m_val = get_post_meta( $res_id, $fn , true );
                            if(!empty($m_val)){
                                $fieldsReplace[] = $m_val;//get_post_meta( $res_id, $fn , true );
                            }else{
                                $fieldsReplace[] = '['.$fn.']';
                            }
                            
                        }
                        
                    }


                    $email_template = preg_replace($fieldsPattern, $fieldsReplace, $email_template);
                }


                $headers = array();
                if(get_option('_reservation_email_content_type','yes' ) == 'yes'){
                    $headers[] = 'Content-Type: text/html; charset=UTF-8';
                }
                //$headers[] = 'From: '. $sender_option.' ' . '<'.$sender_email_option.'>';
                add_filter( 'wp_mail_from_name', 'cth_reservation_custom_wp_mail_from_name' );
                $headers[] = 'Reply-To: '. $sender_option.' ' . '<'.$sender_email_option.'>';

                //$e_return = wp_mail( $mail_to, $mail_subject , $message, $headers);
                $e_return = wp_mail( $mail_to, $mail_subject , $email_template, $headers);
                remove_filter( 'wp_mail_from_name', 'cth_reservation_custom_wp_mail_from_name' );

            //}


        //}
    }

}


add_action( 'reservation_status_from_confirming_to_confirmed', 'cth_reservation_emails_confirming_to_confirmed_action_callback' );
if(!function_exists('cth_reservation_emails_confirming_to_confirmed_action_callback')){
    function cth_reservation_emails_confirming_to_confirmed_action_callback($res_id){
        //if(get_option('_reservation_confirmed_email','yes') == 'yes'){

            $sender_option = get_option('_reservation_email_sender','Lambert');
            $sender_email_option = get_option('_reservation_email_sender_email','contact.cththemes@gmail.com' );

            $mail_to = get_option('_emails_reservation_admin_email','email' );

            //if($mail_to = get_post_meta($res_id, $to_option ,true)){

                $mail_subject = get_option('_emails_reservation_confirmed_admin_subject','Reservation Confirmed' );

                $email_template = get_option('_emails_reservation_confirmed_admin_template', '<p>Hi [name],</p>
<p>Thank you for confirmed your reservation at our [resrest] - Restaurant.</p>
<p><strong>Cththemes</strong></p>' ); 

                if(preg_match_all("/\[([\w\-]+)[^\w\-]*\]/", $email_template, $matches)!= FALSE){
                    $fieldsPattern = array();
                    $fieldsReplace = array();
                    foreach ($matches[1] as $key => $fn) {
                        $fieldsPattern[] = "/\[(".$fn.")[^\w\-]*\]/";
                        $m_val = get_post_meta( $res_id, $fn , true );
                        if(!empty($m_val)){
                            $fieldsReplace[] = $m_val;
                        }else{
                            $fieldsReplace[] = '['.$fn.']';
                        }
                        
                    }

                    $email_template = preg_replace($fieldsPattern, $fieldsReplace, $email_template);
                }

                $headers = array();
                if(get_option('_reservation_email_content_type','yes' ) == 'yes'){
                    $headers[] = 'Content-Type: text/html; charset=UTF-8';
                }
                //$headers[] = 'From: '. $sender_option.' ' . '<'.$sender_email_option.'>';
                add_filter( 'wp_mail_from_name', 'cth_reservation_custom_wp_mail_from_name' );
                $headers[] = 'Reply-To: '. $sender_option.' ' . '<'.$sender_email_option.'>';

                $e_return = wp_mail( $mail_to, $mail_subject , $email_template, $headers);
                remove_filter( 'wp_mail_from_name', 'cth_reservation_custom_wp_mail_from_name' );

            //}
        //}

    }
}

add_action( 'reservation_status_from_confirmed_to_complete', 'cth_reservation_emails_confirmed_to_complete_action_callback' );
if(!function_exists('cth_reservation_emails_confirmed_to_complete_action_callback')){
    function cth_reservation_emails_confirmed_to_complete_action_callback($res_id){
        //if(get_option('_reservation_complete_email','yes') == 'yes'){
            
            $sender_option = get_option('_reservation_email_sender','Lambert' );
            $sender_email_option = get_option('_reservation_email_sender_email','contact.cththemes@gmail.com' );

            $mail_to = get_option('_emails_reservation_admin_email','email' );

            //if($mail_to = get_post_meta($res_id, $to_option ,true)){

                $mail_subject = get_option('_emails_reservation_complete_admin_subject','Reservation Complete' );

                $email_template = get_option('_emails_reservation_complete_admin_template', '<p>Hi [name],</p>
<p>Thank you for your arrival. See you again.</p>
<p><strong>Cththemes</strong></p>' ); 

                if(preg_match_all("/\[([\w\-]+)[^\w\-]*\]/", $email_template, $matches)!= FALSE){
                    $fieldsPattern = array();
                    $fieldsReplace = array();
                    foreach ($matches[1] as $key => $fn) {
                        $fieldsPattern[] = "/\[(".$fn.")[^\w\-]*\]/";
                        $m_val = get_post_meta( $res_id, $fn , true );
                        if(!empty($m_val)){
                            $fieldsReplace[] = $m_val;
                        }else{
                            $fieldsReplace[] = '['.$fn.']';
                        }
                        
                    }

                    $email_template = preg_replace($fieldsPattern, $fieldsReplace, $email_template);
                }

                $headers = array();
                if(get_option('_reservation_email_content_type','yes' ) == 'yes'){
                    $headers[] = 'Content-Type: text/html; charset=UTF-8';
                }
                //$headers[] = 'From: '. $sender_option.' ' . '<'.$sender_email_option.'>';
                add_filter( 'wp_mail_from_name', 'cth_reservation_custom_wp_mail_from_name' );
                $headers[] = 'Reply-To: '. $sender_option.' ' . '<'.$sender_email_option.'>';

                $e_return = wp_mail( $mail_to, $mail_subject , $email_template, $headers);
                remove_filter( 'wp_mail_from_name', 'cth_reservation_custom_wp_mail_from_name' );
            //}
        //}

    }
}

/// end admin emails

if(!function_exists('cth_reservation_sc')) {

    function cth_reservation_sc( $atts, $content="" ) {
        //wp_enqueue_style('cth-res-style', BBT_DIR_URL  . "assets/css/res-style.css");

        // wp_register_script( "cth-res-scripts", BBT_DIR_URL  . "assets/js/res-scripts.js", array(), false, true);

        // wp_enqueue_script("cth-res-scripts");

        // //Login Ajax script 
        // wp_localize_script( 'cth-res-scripts', 'reservation_ajax', array(
        //     'url'        => admin_url( 'admin-ajax.php' ),
        //     'site_url'     => home_url('/' ),
        //     'plugin_url' => BBT_DIR_URL
        // ) );

        $res_form_fields = get_option('_reservation_form_field','<div class="row">
    <div class="col-md-6">
        <h3>Book a table</h3>
        <!--date-->
        <input name="resdate" type="text" class="myInput" id="resdate" data-lang="en" data-years="2015-2026" data-format="YYYY-MM-DD" data-sundayfirst="false" required aria-required="true" placeholder="Reservation Date - YYYY-MM-DD">
        <!--time--> 
        <select name="restime" id="restime" class="form-control">
            <option value="5:00am">5:00 am</option>
            <option value="5:30am">5:30 am</option>
            <option value="6:00am">6:00 am</option>
            <option value="6:30am">6:30 am</option>
            <option selected="selected" value="7:00am">7:00 am</option>
            <option value="7:30am">7:30 am</option>
            <option value="8:00am">8:00 am</option>
            <option value="8:30am">8:30 am</option>
            <option value="9:00am">9:00 am</option>
            <option value="9:30am">9:30 am</option>
            <option value="10:00am">10:00 am</option>
            <option value="10:30am">10:30 am</option>
            <option value="11:00am">11:00 am</option>
            <option value="11:30am">11:30 am</option>
            <option value="12:00pm">12:00 pm</option>
            <option value="12:30pm">12:30 pm</option>
            <option value="1:00pm">1:00 pm</option>
            <option value="1:30pm">1:30 pm</option>
            <option value="2:00pm">2:00 pm</option>
            <option value="2:30pm">2:30 pm</option>
            <option value="3:00pm">3:00 pm</option>
            <option value="3:30pm">3:30 pm</option>
            <option value="4:00pm">4:00 pm</option>
            <option value="4:30pm">4:30 pm</option>
            <option value="5:00pm">5:00 pm</option>
            <option value="5:30pm">5:30 pm</option>
            <option value="6:00pm">6:00 pm</option>
            <option value="6:30pm">6:30 pm</option>
            <option value="7:00pm">7:00 pm</option>
            <option value="7:30pm">7:30 pm</option>
            <option value="8:00pm">8:00 pm</option>
            <option value="8:30pm">8:30 pm</option>
            <option value="9:00pm">9:00 pm</option>
            <option value="9:30pm">9:30 pm</option>
            <option value="10:00pm">10:00 pm</option>
            <option value="10:30pm">10:30 pm</option>
            <option value="11:00pm">11:00 pm</option>
            <option value="11:30pm">11:30 pm</option>
        </select>
        <!--restaurant-->                                      
        <select name="resrest" class="form-control" id="resrest" onClick="this.select()">
            <option value="Lambert - New York City">Lambert  - New York City</option>
            <option value="Lambert - Washington">Lambert - Washington</option>
            <option value="Lambert - Florida ">Lambert - Florida</option>
        </select>
        <!--person-->    
        <select name="numperson" id="numperson" class="form-control" onClick="this.select()" >
            <option value="1">1 Person</option>
            <option value="2">2 People</option>
            <option value="3">3 People</option>
            <option value="4">4 People</option>
            <option value="5">5 People</option>
            <option value="6">6 People</option>
        </select>
    </div>
    <div class="col-md-6">
        <h3>Contact Details</h3>
        <!--name--> 
        <input name="name" type="text" id="name"   required aria-required="true" placeholder="Your Name">
        <!--mail--> 
        <input name="email" type="text" id="email"  required aria-required="true" placeholder="Your Email">
        <!--phone--> 
        <input name="phone" type="text" id="phone"  required aria-required="true" placeholder="Your Phone">         
        <!--message-->    
        <textarea name="comments" rows="5"  id="comments"  required aria-required="true" placeholder="Your Message"></textarea>
    </div>
</div>' );

        // create captcah image
        // cth_reservation_createCaptchaPNGImage();

        ob_start();
        ?>
        <div class="reservation-form-holder">
            <div class="reservation-form">
                <div class="res-message" id="message"></div>
                <form method="post" name="reservationform" id="reservation-form">
                    
                    <?php 
                    $res_form_fields = apply_filters('cth_reservation_form_fields', $res_form_fields );
                    echo htmlspecialchars_decode($res_form_fields );

                    do_action('lambert_res_additional');
                    ?>

                    <button type="submit"  id="submit-res"><?php _e('Make a reservation','lambert-add-ons');?></button> 

                                                                                                                        
                </form>
            </div>
        </div>

        <?php 
        $return_content = ob_get_contents();

        ob_end_clean();

        
        return $return_content;
     
    }
        
    add_shortcode( 'cth_reservation_form', 'cth_reservation_sc' ); //Icon
}

add_action('wp_ajax_nopriv_cth_reservation', 'cth_reservation_callback');
add_action('wp_ajax_cth_reservation', 'cth_reservation_callback');

/*
 *  @desc   Register user
*/
function cth_reservation_callback() {
    
    
    //$error = '';
    //$success = '';
    $output = array(
        'success'       => false,
        'POST'          => $_POST,
        'debug'         => false
    );
    
    if ( false == isset($_POST['_wpnonce']) || false == wp_verify_nonce($_POST['_wpnonce'], 'lambert-add-ons') ){
        $output['message'] = esc_html__( 'Security checked!, Cheatn huh?', 'lambert-add-ons' ) ;
        wp_send_json($output );
    }

    // verify google reCAPTCHA
    if( lambert_addons_verify_recaptcha() === false ){
        
        $output['message'] = esc_html__( 'reCAPTCHA failed, please try again.', 'lambert-add-ons' ) ;
        wp_send_json($output );
    }

    
    //$formData = array_slice($_POST, 3);
    $formData = $_POST;
    
    $datas = array();
    $metadatas = array();

    $metadatas = array_merge($formData,array('reservation_status'=>'booked'));

    $reservation_format = get_option('_reservation_content_template', "<h4 align=\"center\">Reservation Info</h4>
<br />
<p align=\"left\">Name: <strong>[name]</strong></p>
<p align=\"left\">Phone: <strong>[phone]</strong></p>
<p align=\"left\">E-mail: <strong>[email]</strong></p>
<p align=\"left\">Resturant: <strong>[resrest]</strong></p>
<p align=\"left\">Reservation Date: <strong>[resdate]</strong></p>
<p align=\"left\">Reservation Time: <strong>[restime]</strong></p>
<p align=\"left\">Persons: <strong>[numperson]</strong></p>
<p align=\"left\"><strong>Additional Message</strong></p><br />
[comments]" ); 

    if(preg_match_all("/\[([\w\-]+)[^\w\-]*\]/", $reservation_format, $matches)!= FALSE){
        $fieldsPattern = array();//$matches[0];
        $fieldsReplace = array();
        foreach ($matches[1] as $key => $fn) {
            $fieldsPattern[] = "/\[(".$fn.")[^\w\-]*\]/";
            if(isset($_POST[$fn])){
                $fieldsReplace[] = $_POST[$fn];
            }else{
                $fieldsReplace[] = '['.$fn.']';
            }
        }

        $reservation_format = preg_replace($fieldsPattern, $fieldsReplace, $reservation_format);
    }

    $title_field = get_option('_reservation_title_field','name' );

    $datas['post_type'] = 'cth_reservation';
    if(isset($_POST[$title_field])){
        $datas['post_title'] = $_POST[$title_field];
        $datas['post_name'] = sanitize_title($_POST[$title_field]);
    }else{
        $datas['post_title'] = __('Book a table','lambert-add-ons');
        $datas['post_name'] = sanitize_title( __('Book a table','lambert-add-ons'));
    }
    $datas['post_status'] ='publish';
    
    $datas['post_content'] = $reservation_format;
    $reservation_id = wp_insert_post($datas ,true );
    if (is_wp_error($reservation_id)) {
        $output['message'] = $reservation_id->get_error_message();
    }else{
        foreach ($metadatas as $key => $value) {
            update_post_meta( $reservation_id, $key, $value);
        }
        do_action('cth_reservation_booked', $reservation_id);
        $output['success'] = true;
        $output['message'] = __('Thank you! Please confirm your reservation via email.','lambert-add-ons');
    }   
    wp_send_json($output);
}

function cth_reservation_add_query_vars_filter( $vars ){
    $vars[] = 'resid';
    $vars[] = "cfkey";
    return $vars;
}
add_filter( 'query_vars', 'cth_reservation_add_query_vars_filter' );

add_filter( 'the_content', 'cth_reservation_page_filter' ); 
 function cth_reservation_page_filter( $content ) { 
    $the_page_id = get_option( 'cth_reservation_page_id','0' );
    if ( !is_admin() && $the_page_id && is_page( $the_page_id ) ) {
        
        $resid = get_query_var('resid','1');
        $cfkey = get_query_var('cfkey','cth');

        if(is_numeric($resid)){

            if($res_post = get_post($resid)){
                if(get_post_meta($resid, 'reservation_status',true ) == 'confirmed'){
                    $content = __('The reservation have already confirmed. Thank you.','lambert-add-ons');
                }else{
                    $compare_key = cth_reservation_get_comfirm_code($resid);

                    if($cfkey === $compare_key){
                        $content = __('The reservation confirmed. Thank you.','lambert-add-ons');
                        update_post_meta($resid,'reservation_status', 'confirmed');
                        do_action('reservation_status_from_confirming_to_confirmed',$resid);
                    }else{
                        $content = __('Sorry, reservation confirm fault. Please try again','lambert-add-ons');
                    }
                }
                
            }else{
                $content = __('The reservation not found. Please book new one.','lambert-add-ons');
            }

        }else{
            $content = __('Oops, there was an error. Please try again.','lambert-add-ons');
        }

        $confirmed_message = get_option( '_reservation_confirmed_page_message' );

        $content .= "<br>".$confirmed_message;

    }

    return $content;
}
