<?php 
/* add_ons_php */

// Plugin Options
/** Step 2 (from text above). */
add_action( 'admin_menu', 'cth_reservation_emails_plugin_menu' );

/** Step 1. */
function cth_reservation_emails_plugin_menu() {
    //Create new option menu
    // add_options_page( 
    //     __('Lambert Reservation Admin Emails Options','lambert-add-ons'), // $page_title - (string) (required) The text to be displayed in the title tags of the page when the menu is selected 
    //     __('Lambert Reservation Admin Emails','lambert-add-ons'), //  $menu_title - (string) (required) The text to be used for the menu 
    //     'manage_options', // $capability - (string) (required) The capability required for this menu to be displayed to the user. 
    //     'cth_reservation_emails', //menu_slug - (string) (required) The slug name to refer to this menu by (should be unique for this menu). 
    //     'cth_reservation_emails_plugin_options' // $function - (callback) (optional) The function to be called to output the content for this page. 
    // );
    add_submenu_page( 
        'edit.php?post_type=cth_reservation',
        __('Reservation Admin Emails','lambert-add-ons'), // $page_title - (string) (required) The text to be displayed in the title tags of the page when the menu is selected 
        __('Admin Emails (old)','lambert-add-ons'), //  $menu_title - (string) (required) The text to be used for the menu 
        'manage_options', // $capability - (string) (required) The capability required for this menu to be displayed to the user. 
        'cth_reservation_emails', //menu_slug - (string) (required) The slug name to refer to this menu by (should be unique for this menu). 
        'cth_reservation_emails_plugin_options' // $function - (callback) (optional) The function to be called to output the content for this page. 
    );
    //call register settings function
    add_action( 'admin_init', 'register_cth_reservation_emails_settings' );
}

function register_cth_reservation_emails_settings() { // whitelist options

    register_setting( 'cth_reservation_emails', '_emails_reservation_admin_email' );
    register_setting('cth_reservation_emails','_emails_reservation_admin_subject' );
    register_setting('cth_reservation_emails','_emails_reservation_admin_template' );

    register_setting('cth_reservation_emails','_emails_reservation_confirming_admin_subject' );
    register_setting('cth_reservation_emails','_emails_reservation_confirming_admin_template' );

    register_setting('cth_reservation_emails','_emails_reservation_confirmed_admin_subject' );
    register_setting('cth_reservation_emails','_emails_reservation_confirmed_admin_template' );

    register_setting('cth_reservation_emails','_emails_reservation_complete_admin_subject' );
    register_setting('cth_reservation_emails','_emails_reservation_complete_admin_template' );

}

/** Step 3. */
function cth_reservation_emails_plugin_options() {
    if ( !current_user_can( 'manage_options' ) )  {
        wp_die( __( 'You do not have sufficient permissions to access this page.', 'lambert-add-ons' ) );
    }
    include BBT_ABSPATH.'older_2_dot_4/adem_options.php';
}




