<?php 
/* add_ons_php */
vc_map( array(
    "name"      => esc_html__("Testimonials Slider", 'lambert-add-ons'),
    "base"      => "lambert_testimonials_slider",
    "icon"                     => BBT_DIR_URL . "/assets/cththemes-logo.png",
    "category"  => 'Lambert Theme',
    "show_settings_on_create" => true,
    "params"    => array(
        array(
            "type"      => "textfield",
            'admin_label' => true,
            "heading"   => esc_html__("Count", 'lambert-add-ons'),
            "param_name"=> "count",
            "value"     => "3",
            "description" => esc_html__("Number of testimonials to show", 'lambert-add-ons')
        ),
        array(
            "type" => "dropdown",
            "heading" => esc_html__('Order by', 'lambert-add-ons'),
            "param_name" => "order_by",
            "value" => array(   
                esc_html__('Date', 'lambert-add-ons') => 'date',  
                esc_html__('ID', 'lambert-add-ons') => 'ID',  
                esc_html__('Author', 'lambert-add-ons') => 'author',       
                esc_html__('Title', 'lambert-add-ons') => 'title',  
                esc_html__('Modified', 'lambert-add-ons') => 'modified',  
            ),
            "description" => esc_html__("Order by", 'lambert-add-ons'),  
            "std"=>'date',    
        ),
        array(
            "type" => "dropdown",
            "heading" => esc_html__('Order', 'lambert-add-ons'),
            "param_name" => "order",
            "value" => array(   
                            esc_html__('Descending', 'lambert-add-ons') => 'DESC',
                            esc_html__('Ascending', 'lambert-add-ons') => 'ASC',                                                                           
                            ),
            "description" => esc_html__("Order", 'lambert-add-ons'),   
            "std" => "DESC"   
        ),
        array(
            "type" => "textfield",
            "heading" => esc_html__("Or Enter Testimonial IDs", 'lambert-add-ons'),
            "param_name" => "ids",
            "description" => esc_html__("Enter testimonial ids to show, separated by a comma. (ex: 99,100)", 'lambert-add-ons')
        ),
        array(
            "type" => "dropdown",
            "heading" => esc_html__('Show Avatar', 'lambert-add-ons'),
            "param_name" => "show_avatar",
            "value" => array(   
                            esc_html__('No', 'lambert-add-ons') => 'no',  
                            esc_html__('Yes', 'lambert-add-ons') => 'yes',
                            
                                                                                                              
                            ),
            "description" => esc_html__("Show avatar", 'lambert-add-ons'),    
            "std" => "yes"     
        ),
        array(
            "type" => "dropdown",
            "heading" => esc_html__("Show Title", 'lambert-add-ons'),
            "param_name" => "show_title",
  
            "value" => array( 
                esc_html__('No', 'lambert-add-ons') => 'no',  
                esc_html__('Yes', 'lambert-add-ons') => 'yes',   
                
                  
            ),
            "std"=>'no', 
        ),
        array(
            "type" => "dropdown",
            "heading" => esc_html__("Show Rating", 'lambert-add-ons'),
            "param_name" => "show_rating",
          
            "value" => array( 
                esc_html__('No', 'lambert-add-ons') => 'no',  
                esc_html__('Yes', 'lambert-add-ons') => 'yes',   
                
                  
            ),
            "std"=>'yes', 
        ),


        
        


        array(
            "type" => "textfield",
            "heading" => esc_html__("Items", 'lambert-add-ons'),
            "param_name" => "items",
            "description" => esc_html__("The number of items you want to see on the screen. Ex: 3", 'lambert-add-ons'),
            "value" => "1"
        ),
        array(
            "type" => "textfield",
            "heading" => esc_html__("Slide By Items", 'lambert-add-ons'),
            "param_name" => "slideby",
            "description" => esc_html__("The number of items which navigation slide by. Ex: 1", 'lambert-add-ons'),
            "value" => "1"
        ),
        array(
            "type" => "dropdown",
            "heading" => esc_html__("Center", 'lambert-add-ons'),
            "param_name" => "center",
            "description" => esc_html__("Center item. Works well with even an odd number of items.", 'lambert-add-ons'),
            "value" => array(   
                esc_html__('No', 'lambert-add-ons') => 'no',  
                esc_html__('Yes', 'lambert-add-ons') => 'yes',   
            ),
            "std"=>'no', 
        ),
        array(
            "type" => "textfield",
            "heading" => esc_html__("smartSpeed", 'lambert-add-ons'),
            "param_name" => "smartspeed",
            "value"=>'500',
            "description" => esc_html__("Speed Calculate, milisecond number. Ex: 250", 'lambert-add-ons')
        ), 
        array(
            "type" => "dropdown",
            "heading" => esc_html__("Loop", 'lambert-add-ons'),
            "param_name" => "loop",
            
            "value" => array(  
                esc_html__('Yes', 'lambert-add-ons') => 'yes',  
                esc_html__('No', 'lambert-add-ons') => 'no',  
                  
            ),
            "std"=>'yes', 
        ),
        array(
            "type" => "dropdown",
            "heading" => esc_html__("Auto Height", 'lambert-add-ons'),
            "param_name" => "autoheight",
            
            "value" => array(   
                esc_html__('Yes', 'lambert-add-ons') => 'yes', 
                esc_html__('No', 'lambert-add-ons') => 'no',  
                  
            ),
            "std"=>'yes', 
        ),
        array(
            "type" => "dropdown",
            "heading" => esc_html__("Auto Width", 'lambert-add-ons'),
            "param_name" => "autowidth",
            "description" => esc_html__("Set non grid content. Try using width style on divs.", 'lambert-add-ons'),
            "value" => array(   
                esc_html__('No', 'lambert-add-ons') => 'no',  
                esc_html__('Yes', 'lambert-add-ons') => 'yes',   
            ),
            "std"=>'no', 
        ),
        array(
            "type" => "dropdown",
            "heading" => esc_html__("Auto Play", 'lambert-add-ons'),
            "param_name" => "autoplay",
            
            "value" => array(   
                esc_html__('No', 'lambert-add-ons') => 'no',  
                esc_html__('Yes', 'lambert-add-ons') => 'yes',   
            ),
            "std"=>'no', 
        ),
        array(
            "type" => "textfield",
            "heading" => esc_html__("autoplayTimeout", 'lambert-add-ons'),
            "param_name" => "autoplaytimeout",
            "value"=>'2000',
            "description" => esc_html__("Time after display next slide (in milisecond)", 'lambert-add-ons')
        ),

        array(
            "type" => "textfield",
            "heading" => esc_html__("autoplaySpeed", 'lambert-add-ons'),
            "param_name" => "autoplayspeed",
            "value"=>'500',
            "description" => esc_html__("Duration of transition between slides (in ms) or boolen", 'lambert-add-ons')
        ), 
        array(
            "type" => "textfield",
            "heading" => esc_html__("responsive", 'lambert-add-ons'),
            "param_name" => "responsive",
            "description" => esc_html__("The format is: screen-size:number-items-display,larger-screen-size:number-items-display. Ex: 320:1,768:1,992:3,1200:3", 'lambert-add-ons'),
            "value" => ""
        ),
        array(
            "type" => "dropdown",
            "heading" => esc_html__("Show Navigation", 'lambert-add-ons'),
            "param_name" => "nav",
     
            "value" => array( 
                esc_html__('No', 'lambert-add-ons') => 'no',  
                esc_html__('Yes', 'lambert-add-ons') => 'yes',   
                
                  
            ),
            "std"=>'no', 
        ),

        array(
            "type" => "textfield",
            "heading" => esc_html__("Extra class name", 'lambert-add-ons'),
            "param_name" => "el_class",
            "description" => esc_html__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'lambert-add-ons')
        ),
        array(
            'type' => 'css_editor',
            'heading' => esc_html__( 'Css', 'lambert-add-ons' ),
            'param_name' => 'css',
            'group' => esc_html__( 'Design options', 'lambert-add-ons' ),
        ),
    )));

if ( class_exists( 'WPBakeryShortCode' ) ) {
    class WPBakeryShortCode_Lambert_Testimonials_Slider extends WPBakeryShortCode {}
}
