<?php 
/* add_ons_php */

vc_map( array(
    "name" => esc_html__("Section Title", 'lambert-add-ons'),
    //"description" => esc_html__("Section Title for Lambert",'lambert'),
    "base" => "lambert_section_title",
    "content_element" => true,
    "icon"      => BBT_DIR_URL . "/assets/cththemes-logo.png",
    "category"  => 'Lambert Theme',
    "show_settings_on_create" => true,
    "params" => array(
        
        array(
            "type"      => "textfield",
            "admin_label"     => true,
            "heading"   => esc_html__("Title Text", 'lambert-add-ons'),
            "param_name"=> "title_text",
            "value"     => "Discover",

        ),
        array(
            "type"      => "textfield",
            "admin_label"     => true,
            "heading"   => esc_html__("SubTitle Text", 'lambert-add-ons'),
            "param_name"=> "subtitle_text",
            "value"     => "OUR STORY",

        ),
        array(
            "type" => "dropdown",
            "heading" => esc_html__("Is Subtitle Decor?", 'lambert-add-ons'),
            "param_name" => "sub_decor",
        
            "value" => array( 
                esc_html__('No', 'lambert-add-ons') => 'no',  
                esc_html__('Yes', 'lambert-add-ons') => 'yes',   
                
                  
            ),
            "std"=>'yes', 
            'dependency' => array(
                'element' => 'subtitle_text',
                'value' => '',
                'not_empty' => true,
            ),
        ),
        array(
            "type" => "dropdown",
            "heading" => esc_html__("Show Separator Image", 'lambert-add-ons'),
            "param_name" => "show_decor",
        
            "value" => array( 
                esc_html__('No', 'lambert-add-ons') => 'no',  
                esc_html__('Yes', 'lambert-add-ons') => 'yes',   
                
                  
            ),
            "std"=>'yes', 
        ),
        array(
            "type"      => "attach_image",
            "holder"    => "div",
            "class"     => "ajax-vc-img",
            "heading"   => esc_html__("Separator Image", 'lambert-add-ons'),
            "param_name"=> "decor_img",
        ),
        array(
            "type"      => "textarea_html",
            "holder"    => "div",
            "heading"   => esc_html__("More Info", 'lambert-add-ons'),
            "param_name"=> "content",
            
        ),  
        array(
            "type" => "textfield",
            "heading" => esc_html__("Extra class name", 'lambert-add-ons'),
            "param_name" => "el_class",
            "description" => esc_html__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'lambert-add-ons'),
            "value" => "",
        ),

        array(
            'type' => 'css_editor',
            'heading' => esc_html__( 'Css', 'lambert-add-ons' ),
            'param_name' => 'css',
            'group' => esc_html__( 'Design options', 'lambert-add-ons' ),
        ),
        
        
        
    )
));

if ( class_exists( 'WPBakeryShortCode' ) ) {
    class WPBakeryShortCode_Lambert_Section_Title extends WPBakeryShortCode {     
    }
}