<?php 
/* add_ons_php */
vc_map( array(
    "name" => __("Owl Carousel", 'lambert-add-ons'),
    "description" => __("Slider using owl carousel plugin",'lambert-add-ons'),
    "base" => 'do'.'mik'."_owl_carousel",
    "category"  => 'Lambert Theme',
    "as_parent" => array('only' => 'do'.'mik'.'_owl_carousel_item'), // Use only|except attributes to limit child shortcodes (separate multiple values with comma)
    "content_element" => true,
    "show_settings_on_create" => false,
    "class"=> 'lambert_owl_carousel',
    "icon"                     => BBT_DIR_URL . "/assets/cththemes-logo.png",
    "params" => array(
        
        array(
            "type" => "dropdown",
            "class"=>"",
            "heading" => __('Layout', 'lambert-add-ons'),
            "param_name" => "layout",
            "value" => array(   
                            __('Default', 'lambert-add-ons') => 'default',  
                            __('Testimonial', 'lambert-add-ons') => 'testimonial',                                                                                
                        ),
            "std"=>'default',
            "description" => __("Slider Layout", 'lambert-add-ons'), 
        ),


        array(
            "type" => "textfield",
            "heading" => esc_html__("Items", 'lambert-add-ons'),
            "param_name" => "items",
            "description" => esc_html__("The number of items you want to see on the screen. Ex: 1", 'lambert-add-ons'),
            "value" => "1"
        ),

        array(
            "type" => "textfield",
            "heading" => esc_html__("Slide By Items", 'lambert-add-ons'),
            "param_name" => "slideby",
            "description" => esc_html__("The number of items which navigation slide by. Ex: 1", 'lambert-add-ons'),
            "value" => "1"
        ),

        

        array(
            "type" => "dropdown",
            "heading" => esc_html__("Center", 'lambert-add-ons'),
            "param_name" => "center",
            "description" => esc_html__("Center item. Works well with even and odd number of items.", 'lambert-add-ons'),
            "value" => array(   
                esc_html__('No', 'lambert-add-ons') => 'no',  
                esc_html__('Yes', 'lambert-add-ons') => 'yes',   
            ),
            "std"=>'no', 
        ),
        array(
            "type" => "textfield",
            "heading" => esc_html__("Speed", 'lambert-add-ons'),
            "param_name" => "slidespeed",
            "value"=>'500',
            "description" => esc_html__("Speed Calculate, milisecond number. Ex: 500", 'lambert-add-ons')
        ), 
        array(
            "type" => "dropdown",
            "heading" => esc_html__("Loop", 'lambert-add-ons'),
            "param_name" => "loop",
            "value" => array(   
                esc_html__('No', 'lambert-add-ons') => 'no',  
                esc_html__('Yes', 'lambert-add-ons') => 'yes',   
            ),
            "std"=>'yes', 
        ),
        // array(
        //     "type" => "dropdown",
        //     "heading" => esc_html__("Auto Height", 'lambert'),
        //     "param_name" => "autoheight",
        //     "value" => array(   
        //         esc_html__('Yes', 'lambert') => 'yes', 
        //         esc_html__('No', 'lambert') => 'no',  
                  
        //     ),
        //     "std"=>'no', 
        // ),
        // array(
        //     "type" => "dropdown",
        //     "heading" => esc_html__("Auto Width", 'lambert'),
        //     "param_name" => "autowidth",
        //     "description" => esc_html__("Set non grid content. Try using width style on divs.", 'lambert'),
        //     "value" => array(   
        //         esc_html__('No', 'lambert') => 'no',  
        //         esc_html__('Yes', 'lambert') => 'yes',   
        //     ),
        //     "std"=>'no', 
        // ),
        array(
            "type" => "dropdown",
            "heading" => esc_html__("Auto Play", 'lambert-add-ons'),
            "param_name" => "autoplay",
            "value" => array(   
                esc_html__('No', 'lambert-add-ons') => 'no',  
                esc_html__('Yes', 'lambert-add-ons') => 'yes',   
            ),
            "std"=>'no', 
        ),
        array(
            "type" => "textfield",
            "heading" => esc_html__("autoplayTimeout", 'lambert-add-ons'),
            "param_name" => "autoplaytimeout",
            "value"=>'2000',
            "description" => esc_html__("Time after display next slide (in milisecond)", 'lambert-add-ons')
        ),

        array(
            "type" => "textfield",
            "heading" => esc_html__("autoplaySpeed", 'lambert-add-ons'),
            "param_name" => "autoplayspeed",
            "value"=>'500',
            "description" => esc_html__("Duration of transition between slides (in ms) or boolen", 'lambert-add-ons')
        ), 
        array(
            "type" => "textfield",
            "heading" => esc_html__("responsive", 'lambert-add-ons'),
            "param_name" => "itemscustom",
            "description" => esc_html__("The format is: screen-size:number-items-display,larger-screen-size:number-items-display. Ex: 300:1,768:2,992:3,1200:4", 'lambert-add-ons'),
            "value" => "300:1,768:1,992:1,1200:1"
        ),
        array(
            "type" => "dropdown",
            "heading" => esc_html__("Show Navigation", 'lambert-add-ons'),
            "param_name" => "nav",
            "value" => array( 
                esc_html__('Yes', 'lambert-add-ons') => 'yes',   
                esc_html__('No', 'lambert-add-ons') => 'no',  
                  
            ),
            "std"=>'yes', 
        ),
        array(
            "type" => "dropdown",
            "heading" => esc_html__("Show Pagination", 'lambert-add-ons'),
            "param_name" => "dots",
            "value" => array( 
                esc_html__('Yes', 'lambert-add-ons') => 'yes',   
                esc_html__('No', 'lambert-add-ons') => 'no',  
                  
            ),
            "std"=>'yes', 

            'dependency' => array(
                'element' => 'layout',
                'value' => array( 'default' ),
                'not_empty' => false,
            ),
        ),



        array(
            "type" => "textfield",
            "heading" => __("ID", 'lambert-add-ons'),
            "param_name" => "el_id",
            "description" => __("Slider id", 'lambert-add-ons')
        ),


        array(
            "type" => "textfield",
            "heading" => esc_html__("Extra class name", 'lambert-add-ons'),
            "param_name" => "el_class",
            "description" => esc_html__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'lambert-add-ons')
        ),
        array(
            'type' => 'css_editor',
            'heading' => esc_html__( 'Css', 'lambert-add-ons' ),
            'param_name' => 'css',
            'group' => esc_html__( 'Design options', 'lambert-add-ons' ),
        ),


        
    ),
    "js_view" => 'VcColumnView',
    // 'admin_enqueue_js' => get_template_directory_uri() . "/vc_extend/lambert-elements.js",
));

vc_map( array(
    "name" => __("Slide Item", 'lambert-add-ons'),
    "base" => 'do'.'mik'."_owl_carousel_item",
    "content_element" => true,
    "icon"                     => BBT_DIR_URL . "/assets/cththemes-logo.png",
    "as_child" => array('only' => 'do'.'mik'.'_owl_carousel'),
    "params" => array(
        array(
            "type" => "textfield",
            "heading" => __("Extra class name", 'lambert-add-ons'),
            "param_name" => "el_class",
            "description" => __("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'lambert-add-ons')
        ),
        array(
            "type"      => "attach_image",
            "holder"    => "div",
            "class"     => "ajax-vc-img",
            "heading"   => __("Slide Image", 'lambert-add-ons'),
            "param_name"=> "slideimg",
            "description" => __("Slide Image", 'lambert-add-ons')
        ),
        // array(
        //     "type"      => "textfield",
        //     "class"     => "",
        //     "heading"   => __("Title", 'lambert'),
        //     "param_name"=> "title",
        //     "value"     => "Super flat design for online business ",
        //     "description" => __("", 'lambert')
        // ),
        array(
            "type"      => "textarea_html",
            "holder"    => "div",
            "class"     => "",
            "heading"   => __("Caption", 'lambert-add-ons'),
            "param_name"=> "content",
            "description" => __("Caption", 'lambert-add-ons')
        ),   
    ),
    // 'js_view'=>'LambertImagesView'
));

//Your "container" content element should extend WPBakeryShortCodesContainer class to inherit all required functionality
if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_Domik_Owl_Carousel extends WPBakeryShortCodesContainer {}
}
if ( class_exists( 'WPBakeryShortCode' ) ) {
    class WPBakeryShortCode_Domik_Owl_Carousel_Item extends WPBakeryShortCode {}
}