<?php 
/* add_ons_php */
vc_map( array(
    "name"      => esc_html__("Menu Grid", 'lambert-add-ons'),
    "base"      => "lambert_menu",
    "icon"                     => BBT_DIR_URL . "/assets/cththemes-logo.png",
    "category"  => 'Lambert Theme',
    "show_settings_on_create" => true,
    "params"    => array( 
        array(
            "type" => "textfield",
            'admin_label'=>true, 
            "heading" => esc_html__("Menu Category IDs to include", 'lambert-add-ons'), 
            "param_name" => "cat_ids", 
            "description" => esc_html__("Enter menu category ids to include, separated by a comma. Leave empty to get menus from all categories.", 'lambert-add-ons')
        ), 
        array(
            "type" => "textfield", 
            'admin_label'=>true,
            "heading" => esc_html__("Enter Menu IDs", 'lambert-add-ons'), 
            "param_name" => "ids", 
            "description" => esc_html__("Enter Menu ids to show, separated by a comma. Leave empty to show all.", 'lambert-add-ons')
        ), 
        array(
            "type" => "textfield", 
            'admin_label'=>true,
            "heading" => esc_html__("Or Menu IDs to Exclude", 'lambert-add-ons'), 
            "param_name" => "ids_not", 
            "description" => esc_html__("Enter menu ids to exclude, separated by a comma (,). Use if the 'Enter Menu IDs' field above is empty.", 'lambert-add-ons')
        ), 
        
        array(
            "type" => "dropdown", 
            "heading" => esc_html__('Order Menu by', 'lambert-add-ons'), 
            "param_name" => "order_by", 
            "value" => array(
                esc_html__('Date', 'lambert-add-ons') => 'date', 
                esc_html__('ID', 'lambert-add-ons') => 'ID', 
                esc_html__('Author', 'lambert-add-ons') => 'author', 
                esc_html__('Title', 'lambert-add-ons') => 'title', 
                esc_html__('Modified', 'lambert-add-ons') => 'modified',
                esc_html__('Random', 'lambert-add-ons') => 'rand',
                esc_html__('Comment Count', 'lambert-add-ons') => 'comment_count',
                esc_html__('Menu Order', 'lambert-add-ons') => 'menu_order',
            ), 
            "description" => esc_html__("Select how to sort retrieved posts. More at ", 'lambert-add-ons').'<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex</a>.', 
            "std" => 'date',
        ), 
        array(
            "type" => "dropdown", 
            "heading" => esc_html__('Sort Order', 'lambert-add-ons'), 
            "param_name" => "order", 
            "value" => array(
                esc_html__('Ascending', 'lambert-add-ons') => 'ASC',
                esc_html__('Descending', 'lambert-add-ons') => 'DESC', 
                
            ), 
            "description" => esc_html__("Select Ascending or Descending order. More at", 'lambert-add-ons').'<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex</a>.', 
            "std" => 'DESC',
        ), 
        array(
            "type" => "textfield",
            'admin_label'=>true,
            "heading" => esc_html__("Galleries to show", 'lambert-add-ons'),
            "param_name" => "posts_per_page",
            "description" => esc_html__("Number of galleries to show (-1 for all).", 'lambert-add-ons'),
            "value"=> '-1',
        ),

        // array(
        //     "type" => "dropdown", 
        //     "class" => "", 
        //     "heading" => esc_html__('Show Filter', 'lambert'), 
        //     "param_name" => "show_filter", 
        //     "value" => array(
        //         esc_html__('Yes', 'lambert') => 'yes', 
        //         esc_html__('No', 'lambert') => 'no', 
        //     ), 
        //     "description" => esc_html__("Show Filter", 'lambert'), 
        //     "std" => 'yes',
        // ), 

        array(
            "type" => "dropdown", 
            "heading" => esc_html__('Columns Grid', 'lambert-add-ons'), 
            "param_name" => "columns_grid", 
            "value" => array(
                esc_html__('One Column', 'lambert-add-ons') => '12',
                esc_html__('Two Columns', 'lambert-add-ons') => '6', 
                esc_html__('Three Columns', 'lambert-add-ons') => '4', 
                esc_html__('Four Columns', 'lambert-add-ons') => '3', 
                esc_html__('Six Columns', 'lambert-add-ons') => '2', 
                
            ), 
            
            "std" => '6',
        ),
        array(
            "type" => "dropdown", 
            "heading" => esc_html__('Click action', 'lambert-add-ons'), 
            "param_name" => "click_action", 
            "value" => array(
                esc_html__('Open image popup', 'lambert-add-ons') => 'popup', 
                esc_html__('Go to menu details page', 'lambert-add-ons') => 'single', 
            ), 
            
            "std" => 'single',
        ), 

        array(
            "type"      => "attach_image",
            "holder"    => "div",
            "class"     => "ajax-vc-img",
            "heading"   => esc_html__("Background Image", 'lambert-add-ons'),
            "param_name"=> "parallax_img",
        ),

        array(
            "type"      => "dropdown",
            "heading"   => esc_html__("Background parallax direction", 'lambert-add-ons'),
            "param_name"=> "parallax_dir",
            "value" => array(
                esc_html__('Left to Right', 'lambert-add-ons') => 'left', 
                esc_html__('Right to Left', 'lambert-add-ons') => 'right', 
            ),
            'std'=> 'left',
            // 'dependency' => array(
            //     'element' => 'parallax_img',
            //     'value' => array(),
            //     'not_empty' => true,
            // ),
        ),

        array(
            "type" => "textfield",
            "heading" => esc_html__("Parallax value", 'lambert-add-ons'),
            "param_name" => "parallax_val",
            "description" => esc_html__("Pixel number. Which we are telling the browser is to move Background Image down/left every time we scroll down 100% of the viewport height and move Background Image up/right every time we scroll up 100% of the viewport height. Ex: 200  or -200 for reverse direction.", 'lambert-add-ons'),
            "value"=> '200',
            // 'dependency' => array(
            //     'element' => 'parallax_img',
            //     'value' => array(),
            //     'not_empty' => true,
            // ),
        ),

        array(
            "type" => "dropdown",
            "heading" => esc_html__("Show Separator Image", 'lambert-add-ons'),
            "param_name" => "show_decor",
        
            "value" => array( 
                esc_html__('No', 'lambert-add-ons') => 'no',  
                esc_html__('Yes', 'lambert-add-ons') => 'yes',   
                
                  
            ),
            "std"=>'yes', 
        ),
        array(
            "type"      => "attach_image",
            "heading"   => esc_html__("Separator Image", 'lambert-add-ons'),
            "param_name"=> "decor_img",
            "value"=>''
        ),
        
        array(
            "type" => "textfield",
            "heading" => esc_html__("Extra class name", 'lambert-add-ons'),
            "param_name" => "el_class",
            "description" => esc_html__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'lambert-add-ons')
        ),
        array(
            'type' => 'css_editor',
            'heading' => esc_html__( 'Css', 'lambert-add-ons' ),
            'param_name' => 'css',
            'group' => esc_html__( 'Design options', 'lambert-add-ons' ),
        ),

    ),
    // "js_view" => 'LambertImagesView',
    // 'admin_enqueue_js' => get_template_directory_uri() . "/vc_extend/lambert-elements.js",
));


if ( class_exists( 'WPBakeryShortCode' ) ) {
    class WPBakeryShortCode_Lambert_Menu extends WPBakeryShortCode {}
}