<?php 
/* add_ons_php */
vc_map( array(
    "name" => __("Home Parallax Video Background", 'lambert-add-ons'),
    "base" => 'do'.'mik'."_home_video",
    "content_element" => true,
    "icon"                     => BBT_DIR_URL . "/assets/cththemes-logo.png",
    "category"=>"Lambert Theme",
    "params" => array(
        array(
            "type" => "dropdown",
            "class"=>"",
            "heading" => __('Video Type', 'lambert-add-ons'),
            "param_name" => "video_type",
            "value" => array(   
                            __('Youtube Video', 'lambert-add-ons') => 'youtube',  
                            __('Vimeo Video', 'lambert-add-ons') => 'vimeo',                                                                                
                        ),
            // "description" => __("", 'lambert'), 
        ),
        array(
            "type"      => "textfield",
            "class"     => "",
            "heading"   => __("Your Youtube Video ID", 'lambert-add-ons'),
            "param_name"=> "video",
            "value"     => "ScT73ywdGrs",
            "description" => __("Your Video ID (Youtube or Vimeo video): ScT73ywdGrs", 'lambert-add-ons')
        ),
        array(
            "type" => "textfield",
            "heading" => __("Containment", 'lambert-add-ons'),
            "param_name" => "containment",
            "value"     => ".video-container",
            "description" => __("CSS selector of the DOM element where you want the video background played on.", 'lambert-add-ons')
        ),
        array(
            "type" => "dropdown",
            "class"=>"",
            "heading" => __('Auto Play', 'lambert-add-ons'),
            "param_name" => "autoplay",
            "value" => array(   
                            __('Yes', 'lambert-add-ons') => '1',  
                            __('No', 'lambert-add-ons') => '0',                                                                                
                        ),
            // "description" => __("", 'lambert'), 
        ),
        array(
            "type" => "dropdown",
            "class"=>"",
            "heading" => __('Mute', 'lambert-add-ons'),
            "param_name" => "mute",
            "value" => array(   
                            __('Yes', 'lambert-add-ons') => '1',  
                            __('No', 'lambert-add-ons') => '0',                                                                                
                        ),
            // "description" => __("", 'lambert'), 
        ),
        array(
            "type"      => "attach_image",
            "holder"    => "div",
            "class"     => "ajax-vc-img",
            "heading"   => __("Background Image", 'lambert-add-ons'),
            "param_name"=> "bgimg",
            "description" => __("Background image for mobile device", 'lambert-add-ons')
        ),
        array(
            "type"      => "textarea_raw_html",
            //"holder"    => "div",
            "class"     => "",
            // "ace_mode"=>"html",
            // "ace_style"=>"min-height:200px;border:1px solid #bbb;",
            "heading"   => __("Content", 'lambert-add-ons'),
            "param_name"=> "content",
            "description" => __("Content", 'lambert-add-ons')
        ),  
        array(
            "type" => "textfield",
            "heading" => esc_html__('Video Parallax Value', 'lambert-add-ons'),
            "param_name" => "parallax_val",
            "value" => "300",
            "description" => esc_html__("Pixel number. Which we are telling the browser is to move Video down every time we scroll down 100% of the viewport height and move Video up every time we scroll up 100% of the viewport height. Ex: 300 or -300 for reverse direction.", 'lambert-add-ons'),
        ) ,
        array(
            "type" => "textfield",
            "heading" => __("Extra class name", 'lambert-add-ons'),
            "param_name" => "el_class",
            "description" => __("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'lambert-add-ons')
        ),
        
        
        
    ),
    // "js_view" => 'LambertImagesView',
    // 'admin_enqueue_js' => get_template_directory_uri() . "/vc_extend/lambert-elements.js",
));

if ( class_exists( 'WPBakeryShortCode' ) ) {
    class WPBakeryShortCode_Domik_Home_Video extends WPBakeryShortCode {     
    }
}


