<?php 
/* add_ons_php */
vc_map( array(
    "name"      => __("Google Map", 'lambert-add-ons'),
    "description" => __("Google Map",'lambert-add-ons'),
    "base"      => 'do'.'mik'."_gmap",
    "class"     => "",
    "icon"                     => BBT_DIR_URL . "/assets/cththemes-logo.png",
    "category"  => 'Lambert Theme',
    "params"    => array(
        array(
            "type"      => "textfield",
            "class"     => "",
            "holder"     => "span",
            "heading"   => __("Address Latitude", 'lambert-add-ons'),
            "param_name"=> "latitude",
            "value"     => "40.7143528",
            "description" => __("Enter your address latitude. You can get your value from: <a href='http://www.gps-coordinates.net/' target='_blank'>http://www.gps-coordinates.net/</a>", 'lambert-add-ons')
        ),
        array(
            "type"      => "textfield",
            "class"     => "",
            "holder"     => "span",
            "heading"   => __("Address Longitude", 'lambert-add-ons'),
            "param_name"=> "longitude",
            "value"     => "-74.0059731",
            "description" => __("Enter your address longitude. You can get your value from: <a href='http://www.gps-coordinates.net/' target='_blank'>http://www.gps-coordinates.net/</a>", 'lambert-add-ons')
        ),
        array(
            "type"      => "textfield",
            "class"     => "",
            "holder"     => "span",
            "heading"   => __("Address String", 'lambert-add-ons'),
            "param_name"=> "address",
            "value"     => "Lambert - New York City",
            "description" => __("Address string", 'lambert-add-ons')
        ),
        array(
            "type"      => "textarea",
            "class"     => "",
            //"holder"     => "span",
            "heading"   => __("Additional Address Setting", 'lambert-add-ons'),
            "param_name"=> "add_address",
            "value"     => "40.7168183;-73.9973402;Lambert - Washington|40.73334016;-73.99330616;Lambert - Florida",
            "description" => __("Address must be separated by `|`. Format: Latitude;Longitude;String_Address<br>Default: 40.7168183;-73.9973402;Lambert - Washington|40.73334016;-73.99330616;Lambert - Florida", 'lambert-add-ons')
        ),
        array(
            "type"      => "textfield",
            "class"     => "",
            //"holder"     => "span",
            "heading"   => __("Zoom", 'lambert-add-ons'),
            "param_name"=> "zoom",
            "value"     => "14",
            // "description" => __("", 'lambert')
        ),
        array(
            "type"      => "attach_image",
            "class"     => "",
            "heading"   => __("Marker", 'lambert-add-ons'),
            "param_name"=> "marker",
            "value"     => '',
            "description" => __("Upload google map marker or leave it empty to use default.", 'lambert-add-ons')
        ),
        array(
            "type" => "textfield",
            "heading" => esc_html__('Gmap Parallax Value', 'lambert-add-ons'),
            "param_name" => "parallax_val",
            "value" => "300",
            "description" => esc_html__("Pixel number. Which we are telling the browser is to move Gmap down every time we scroll down 100% of the viewport height and move Gmap up every time we scroll up 100% of the viewport height. Ex: 300 or -300 for reverse direction.", 'lambert-add-ons'),
        ) ,
        array(
            "type" => "textfield",
            "heading" => __("Extra class name", 'lambert-add-ons'),
            "param_name" => "el_class",
            "description" => __("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'lambert-add-ons')
        ),
    )
));

if ( class_exists( 'WPBakeryShortCode' ) ) {
    class WPBakeryShortCode_Domik_Gmap extends WPBakeryShortCode {}
}


