<?php 
/* add_ons_php */
vc_map( array(
    "name"      => esc_html__("Popup Gallery", 'lambert-add-ons'),
    "description" => esc_html__("with images selected",'lambert-add-ons'),
    "base"      => "lambert_images_gallery",
    "icon"                     => BBT_DIR_URL . "/assets/cththemes-logo.png",
    "category"  => 'Lambert Theme',
 
    "params"    => array(

        array(
            "type"      => "attach_images",
            "holder"    => "div",
            "class"     => "ajax-vc-img",
            "heading"   => esc_html__("Gallery Photos", 'lambert-add-ons'),
            "param_name"=> "galleryimgs",
          
        ),

        array(
            "type" => "textfield",
            "heading" => esc_html__("First Load items", 'lambert-add-ons'),
            "param_name" => "loaded",
            "value"=>'10',
            "description" => esc_html__("Number of images you want to display in the first load. Should be maller than your total images number to use INFINITE scroll option bellow.", 'lambert-add-ons')
        ),

        array(
            "type" => "dropdown",
             
            "heading" => esc_html__('Use INFINITE scroll load more items?', 'lambert-add-ons'),
            "param_name" => "show_loadmore",
            "value" => array(   
                esc_html__('Yes', 'lambert-add-ons') => 'yes',  
                esc_html__('No', 'lambert-add-ons') => 'no',  
                    

            ), 
            "std"=>'yes',    
            "description" => esc_html__("Images will automatically load and adding when you scroll to the bottom.", 'lambert-add-ons')
        ),

        array(
            "type" => "textfield",
            "heading" => esc_html__("Load more items", 'lambert-add-ons'),
            "param_name" => "lmore_items",
            "value"=>'3',
            "description" => esc_html__("Number of images you want to get in the next loadings.", 'lambert-add-ons'),
            'dependency' => array(
                'element' => 'show_loadmore',
                'value' => array( 'yes'),
                'not_empty' => false,
            ),
        ),



        array(
            "type" => "dropdown", 
            "class" => "", 
            "heading" => esc_html__('Columns Grid', 'lambert-add-ons'), 
            "param_name" => "columns_grid", 
            "value" => array(
                esc_html__('One Column', 'lambert-add-ons') => 'one',
                esc_html__('Two Columns', 'lambert-add-ons') => 'two', 
                esc_html__('Three Columns', 'lambert-add-ons') => 'three', 
                esc_html__('Four Columns', 'lambert-add-ons') => 'four', 
                esc_html__('Five Columns', 'lambert-add-ons') => 'five', 
                
            ), 
            
            "std" => 'three',
        ),
        array(
            "type" => "dropdown", 
            "class" => "", 
            "heading" => esc_html__('Spacing', 'lambert-add-ons'), 
            "param_name" => "spacing", 
            "value" => array(
                esc_html__('Extra Small', 'lambert-add-ons') => 'extrasmall', 
                esc_html__('Small', 'lambert-add-ons') => 'small', 
                esc_html__('Medium', 'lambert-add-ons') => 'medium',
                esc_html__('Big', 'lambert-add-ons') => 'big',
                esc_html__('None', 'lambert-add-ons') => 'none', 
                 
                
            ), 
            
            "std" => 'small',
        ),

        array(
            "type" => "dropdown",
             
            "heading" => esc_html__('Show filter', 'lambert-add-ons'),
            "param_name" => "show_filter",
            "value" => array(   
                esc_html__('Yes', 'lambert-add-ons') => 'yes',  
                esc_html__('No', 'lambert-add-ons') => 'no',  
                    

            ), 
            "std"=>'yes',    
        ),

        array(
            "type"      => "textarea",
            
            "heading"   => esc_html__("Filter List", 'lambert-add-ons'),
            "param_name"=> "filter_list",
            "value"     => 'Menu|Restaurant|Video',
            "description" => esc_html__("Note: separate filter texts with | character. Ex: \"Menu|Restaurant|Video\". Each image can have one or more filter texts in its caption field wrapped with \"-f-FILTER_TEXT-f-\" and separate by a space or linebreak, as in this screenshot: ", 'lambert-add-ons').'<a href="'.esc_url('http://prntscr.com/dx98np').'"  target="_blank">'.esc_url('http://prntscr.com/dx98np').'</a>',
            'dependency' => array(
                'element' => 'show_filter',
                'value' => array( 'yes'),
                'not_empty' => false,
            ),
        ),


        // array(
        //     "type" => "dropdown", 
        //     "heading" => esc_html__('Enable Gallery', 'lambert'), 
        //     "param_name" => "enable_gallery", 
        //     "value" => array(
        //         esc_html__('Yes', 'lambert') => 'yes', 
        //         esc_html__('No', 'lambert') => 'no', 
        //     ), 
            
        //     "std" => 'yes',
        // ), 

        
        array(
            "type" => "textfield",
            "heading" => esc_html__("Extra class name", 'lambert-add-ons'),
            "param_name" => "el_class",
            "description" => esc_html__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'lambert-add-ons')
        ),
        array(
            'type' => 'css_editor',
            'heading' => esc_html__( 'Css', 'lambert-add-ons' ),
            'param_name' => 'css',
            'group' => esc_html__( 'Design options', 'lambert-add-ons' ),
        ),
    ),
    // "js_view" => 'LambertImagesView',
    // 'admin_enqueue_js' => get_template_directory_uri() . "/vc_extend/lambert-elements.js",
));

if ( class_exists( 'WPBakeryShortCode' ) ) {
    class WPBakeryShortCode_Lambert_Images_Gallery extends WPBakeryShortCode {}
}

