<?php 
/* add_ons_php */
vc_map( array(
    "name"      => esc_html__("Gallery Grid", 'lambert-add-ons'),
    "base"      => "lambert_gallery",
    "icon"                     => BBT_DIR_URL . "/assets/cththemes-logo.png",
    "category"  => 'Lambert Theme',
    "show_settings_on_create" => true,
    "params"    => array( 
        array(
            "type" => "textfield", 
            "heading" => esc_html__("Gallery Category IDs to include", 'lambert-add-ons'), 
            "param_name" => "cat_ids", 
            "description" => esc_html__("Enter gallery category ids to include, separated by a comma. Leave empty to get gallery from all categories.", 'lambert-add-ons')
        ), 
        array(
            "type" => "textfield", 
            "holder" => "div",
            "heading" => esc_html__("Enter Gallery IDs", 'lambert-add-ons'), 
            "param_name" => "ids", 
            "description" => esc_html__("Enter Gallery ids to show, separated by a comma. Leave empty to show all.", 'lambert-add-ons')
        ), 
        array(
            "type" => "textfield", 
          
            "heading" => esc_html__("Or Gallery IDs to Exclude", 'lambert-add-ons'), 
            "param_name" => "ids_not", 
            "description" => esc_html__("Enter gallery ids to exclude, separated by a comma (,). Use if the field above is empty.", 'lambert-add-ons')
        ), 
        
        array(
            "type" => "dropdown", 
            "class" => "", 
            "heading" => esc_html__('Order Gallery by', 'lambert-add-ons'), 
            "param_name" => "order_by", 
            "value" => array(
                esc_html__('Date', 'lambert-add-ons') => 'date', 
                esc_html__('ID', 'lambert-add-ons') => 'ID', 
                esc_html__('Author', 'lambert-add-ons') => 'author', 
                esc_html__('Title', 'lambert-add-ons') => 'title', 
                esc_html__('Modified', 'lambert-add-ons') => 'modified',
                esc_html__('Random', 'lambert-add-ons') => 'rand',
                esc_html__('Comment Count', 'lambert-add-ons') => 'comment_count',
                esc_html__('Menu Order', 'lambert-add-ons') => 'menu_order',
            ), 
            "description" => esc_html__("Select how to sort retrieved posts. More at ", 'lambert-add-ons').'<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex</a>.', 
            "std" => 'date',
        ), 
        array(
            "type" => "dropdown", 
            "class" => "", 
            "heading" => esc_html__('Sort Order', 'lambert-add-ons'), 
            "param_name" => "order", 
            "value" => array(
                esc_html__('Ascending', 'lambert-add-ons') => 'ASC',
                esc_html__('Descending', 'lambert-add-ons') => 'DESC', 
                
            ), 
            "description" => esc_html__("Select Ascending or Descending order. More at", 'lambert-add-ons').'<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex</a>.', 
            "std" => 'DESC',
        ), 
        array(
            "type" => "textfield",
            'admin_label'=>true,
            "heading" => esc_html__("Galleries to show", 'lambert-add-ons'),
            "param_name" => "posts_per_page",
            "description" => esc_html__("Number of galleries to show (-1 for all).", 'lambert-add-ons'),
            "value"=> '8',
        ),

        array(
            "type" => "dropdown", 
            "class" => "", 
            "heading" => esc_html__('Show Filter', 'lambert-add-ons'), 
            "param_name" => "show_filter", 
            "value" => array(
                esc_html__('Yes', 'lambert-add-ons') => 'yes', 
                esc_html__('No', 'lambert-add-ons') => 'no', 
            ), 
            "description" => esc_html__("Show Filter", 'lambert-add-ons'), 
            "std" => 'yes',
        ), 

        array(
            "type" => "dropdown", 
            "class" => "", 
            "heading" => esc_html__('Columns Grid', 'lambert-add-ons'), 
            "param_name" => "columns_grid", 
            "value" => array(
                esc_html__('One Column', 'lambert-add-ons') => 'one',
                esc_html__('Two Columns', 'lambert-add-ons') => 'two', 
                esc_html__('Three Columns', 'lambert-add-ons') => 'three', 
                esc_html__('Four Columns', 'lambert-add-ons') => 'four', 
                esc_html__('Five Columns', 'lambert-add-ons') => 'five', 
                
            ), 
            
            "std" => 'three',
        ),
        array(
            "type" => "dropdown", 
            "class" => "", 
            "heading" => esc_html__('Spacing', 'lambert-add-ons'), 
            "param_name" => "spacing", 
            "value" => array(
                esc_html__('Extra Small', 'lambert-add-ons') => 'extrasmall', 
                esc_html__('Small', 'lambert-add-ons') => 'small', 
                esc_html__('Medium', 'lambert-add-ons') => 'medium',
                esc_html__('Big', 'lambert-add-ons') => 'big',
                esc_html__('None', 'lambert-add-ons') => 'none', 
                 
                
            ), 
            
            "std" => 'small',
        ),
        array(
            "type" => "dropdown", 
            "heading" => esc_html__('Enable Gallery', 'lambert-add-ons'), 
            "param_name" => "enable_gallery", 
            "value" => array(
                esc_html__('Yes', 'lambert-add-ons') => 'yes', 
                esc_html__('No', 'lambert-add-ons') => 'no', 
            ), 
            
            "std" => 'yes',
        ), 
        array(
            "type" => "dropdown", 
            "heading" => esc_html__('Show Pagination', 'lambert-add-ons'), 
            "param_name" => "show_pagination", 
            "value" => array(
                esc_html__('Yes', 'lambert-add-ons') => 'yes', 
                esc_html__('No', 'lambert-add-ons') => 'no', 
            ), 
            
            "std" => 'no',
        ), 

        array(
            "type" => "dropdown", 
            "class" => "", 
            "heading" => esc_html__('Show Load More', 'lambert-add-ons'), 
            "param_name" => "show_loadmore", 
            "value" => array(
                esc_html__('Yes', 'lambert-add-ons') => 'yes', 
                esc_html__('No', 'lambert-add-ons') => 'no', 
            ), 
            
            "std" => 'yes',
        ), 
        array(
            "type" => "textfield",
            'admin_label'=>true,
            "heading" => esc_html__("Loadmore items per page", 'lambert-add-ons'),
            "param_name" => "lmore_items",
            "description" => esc_html__("Number of items to show per page.", 'lambert-add-ons'),
            "value"=> '2',
            'dependency' => array(
                'element' => 'show_loadmore',
                'value' => array( 'yes' ),
                'not_empty' => false,
            ),
        ),
        array(
            "type" => "textfield",
            "heading" => esc_html__("Extra class name", 'lambert-add-ons'),
            "param_name" => "el_class",
            "description" => esc_html__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'lambert-add-ons')
        ),
        array(
            'type' => 'css_editor',
            'heading' => esc_html__( 'Css', 'lambert-add-ons' ),
            'param_name' => 'css',
            'group' => esc_html__( 'Design options', 'lambert-add-ons' ),
        ),

    )));


if ( class_exists( 'WPBakeryShortCode' ) ) {
    class WPBakeryShortCode_Lambert_Gallery extends WPBakeryShortCode {}
}