<?php 
/* add_ons_php */
vc_map( array(
    "name" => __("Gallery", 'lambert-add-ons'),
    "description" => __("Gallery",'lambert-add-ons'),
    "base" => "cth_gallery",
    "category"=>'Lambert Old',
    "as_parent" => array('only' => 'cth_gallery_item'), // Use only|except attributes to limit child shortcodes (separate multiple values with comma)
    "content_element" => true,
    "show_settings_on_create" => false,
    "class"=>'cth_gallery',
    "icon"                     => BBT_DIR_URL . "/assets/cththemes-logo.png",
    "params" => array(
        array(
            "type" => "dropdown",
            "class"=>"",
            "heading" => __('Item Padding', 'lambert-add-ons'),
            "param_name" => "padding",
            "value" => array(   
                            __('Yes', 'lambert-add-ons') => 'true',  
                            __('No', 'lambert-add-ons') => 'false',                                                                                
                        ),
            //"description" => __("Set this to No to hide filter buttons bar.", "lambert"), 
        ),
        array(
            "type" => "dropdown",
            "class"=>"",
            "heading" => __('Columns', 'lambert-add-ons'),
            "param_name" => "columns",
            "value" => array(   
                            __('One Column', 'lambert-add-ons') => 'one-coulms',  
                            __('Two Columns', 'lambert-add-ons') => 'two-coulms',                                                                                
                            __('Three Columns', 'lambert-add-ons') => 'three-coulms',                                                                                
                            __('Four Columns', 'lambert-add-ons') => 'four-coulms',                                                                                
                            __('Five Columns', 'lambert-add-ons') => 'five-coulms',                                                                                
                            __('Six Columns', 'lambert-add-ons') => 'six-coulms',                                                                                
                        ),
            "default"=>'three-coulms',
            //"description" => __("Set this to No to hide filter buttons bar.", "lambert"), 
        ),
        array(
            "type" => "dropdown",
            "class"=>"",
            "heading" => __('Show Filter', 'lambert-add-ons'),
            "param_name" => "showfilter",
            "value" => array(   
                            __('Yes', 'lambert-add-ons') => 'true',  
                            __('No', 'lambert-add-ons') => 'false',                                                                                
                        ),
            "description" => __("Set this to No to hide filter buttons bar.", 'lambert-add-ons'), 
        ),
        array(
            "type" => "textfield",
            "heading" => __("Extra class name", 'lambert-add-ons'),
            "param_name" => "el_class",
            "description" => __("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'lambert-add-ons')
        ),
        
    ),
    "js_view" => 'VcColumnView'
));

vc_map( array(
    "name" => __("Gallery Item", 'lambert-add-ons'),
    "base" => "cth_gallery_item",
    "content_element" => true,
    "icon"                     => BBT_DIR_URL . "/assets/cththemes-logo.png",
    "as_child" => array('only' => 'cth_gallery'),
    "params" => array(
        array(
            "type"      => "textfield",
            "class"     => "",
            "holder"    => "div",
            "heading"   => __("Title", 'lambert-add-ons'),
            "param_name"=> "title",
            "value"     => "Image Information",
            "description" => __("Image Title for popup info", 'lambert-add-ons')
        ),
        array(
            "type"      => "attach_image",
            //"holder"    => "div",
            "class"     => "",
            "heading"   => __("Thumbnail Image", 'lambert-add-ons'),
            "param_name"=> "thumb",
            "description" => __("Thumbnail Image", 'lambert-add-ons')
        ),
        array(
            "type"      => "textfield",
            "class"     => "",
            "holder"    => "div",
            "heading"   => __("Filter Tags", 'lambert-add-ons'),
            "param_name"=> "filter",
            "value"     => "Menu,Restaurant",
            "description" => __("Item filter tags that used to classify works. Separated by a comma (ex: Menu,Restaurant)", 'lambert-add-ons')
        ),
        array(
            "type" => "dropdown",
            "class"=>"",
            "heading" => __('PopUp Type', 'lambert-add-ons'),
            "param_name" => "popup",
            "value" => array(   
                            //__('None', 'lambert') => '',  
                            __('Image', 'lambert-add-ons') => 'image-popup',  
                            __('Youtube', 'lambert-add-ons') => 'popup-youtube',                                                                                
                            __('Vimeo', 'lambert-add-ons') => 'popup-vimeo',                                                                                
                            __('Gallery', 'lambert-add-ons') => 'popup-gallery',                                                                                
                                                                                                          
                        ),
            //"description" => __("Set this to Yes if you want to display single item only", 'lambert'), 
        ),
        array(
            "type" => "attach_image",
            "class"=>"",
            //"holder"    => "div",
            "heading" => __('Popup Image', 'lambert-add-ons'),
            "param_name" => "large",
            
            //"description" => __("Set this to Yes if you want to display single item only", 'lambert'), 
            'dependency' => array(
                'element' => 'popup',
                'value' => array( 'image-popup' ),
                'not_empty' => false,
            ),
        ),
        array(
            "type" => "attach_images",
            "class"=>"",
            //"holder"    => "div",
            "heading" => __('Gallery Images', 'lambert-add-ons'),
            "param_name" => "gallery_imgs",
            
            //"description" => __("Set this to Yes if you want to display single item only", 'lambert'), 
            'dependency' => array(
                'element' => 'popup',
                'value' => array( 'popup-gallery' ),
                'not_empty' => false,
            ),
        ),
        array(
            "type" => "textfield",
            "holder"    => "div",
            "heading" => __("Video Link", 'lambert-add-ons'),
            "param_name" => "video_link",
            "description" => __("Enter Youtube or Vimeo video link.", 'lambert-add-ons'),
            'dependency' => array(
                'element' => 'popup',
                'value' => array( 'popup-youtube', 'popup-vimeo' ),
                'not_empty' => false,
            ),
        ),
        array(
            "type" => "textfield",
            "heading" => __("Extra class name", 'lambert-add-ons'),
            "holder"    => "div",
            "param_name" => "el_class",
            "description" => __("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'lambert-add-ons')
        ),
    )
));

//Your "container" content element should extend WPBakeryShortCodesContainer class to inherit all required functionality
if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_Cth_Gallery extends WPBakeryShortCodesContainer {}
}
if ( class_exists( 'WPBakeryShortCode' ) ) {
    class WPBakeryShortCode_Cth_Gallery_Item extends WPBakeryShortCode {}
}

