<?php
/* add_ons_php */


function lambert_addons_register_wpbakerry_elements()
{
    //header
    require_once BBT_ABSPATH . 'includes/vc_elements/section_title.php';
    require_once BBT_ABSPATH . 'includes/vc_elements/parallax_sec_title.php';
    require_once BBT_ABSPATH . 'includes/vc_elements/owl_carousel.php';
    require_once BBT_ABSPATH . 'includes/vc_elements/owl_carousel_imgs.php';
    require_once BBT_ABSPATH . 'includes/vc_elements/member.php';
    require_once BBT_ABSPATH . 'includes/vc_elements/gmap.php';
    require_once BBT_ABSPATH . 'includes/vc_elements/home_video.php';
    require_once BBT_ABSPATH . 'includes/vc_elements/home_image.php';
    require_once BBT_ABSPATH . 'includes/vc_elements/home_slideshow.php';
    require_once BBT_ABSPATH . 'includes/vc_elements/home_carousel.php';
    require_once BBT_ABSPATH . 'includes/vc_elements/parallax_video.php';
    require_once BBT_ABSPATH . 'includes/vc_elements/parallax_image.php';
    require_once BBT_ABSPATH . 'includes/vc_elements/parallax_menu.php';
    require_once BBT_ABSPATH . 'includes/vc_elements/deal.php';
    require_once BBT_ABSPATH . 'includes/vc_elements/menu.php';
    require_once BBT_ABSPATH . 'includes/vc_elements/team_new.php';
    require_once BBT_ABSPATH . 'includes/vc_elements/team.php';

    require_once BBT_ABSPATH . 'includes/vc_elements/gallery.php'; // old shortcode

    require_once BBT_ABSPATH . 'includes/vc_elements/reservation_form.php';
    require_once BBT_ABSPATH . 'includes/vc_elements/ace.php';
    require_once BBT_ABSPATH . 'includes/vc_elements/testimonials.php';
    require_once BBT_ABSPATH . 'includes/vc_elements/testimonial.php';
    require_once BBT_ABSPATH . 'includes/vc_elements/gallery_grid.php';
    require_once BBT_ABSPATH . 'includes/vc_elements/gallery_popup.php';
    require_once BBT_ABSPATH . 'includes/vc_elements/menus_grid.php';

}
add_action('vc_before_init', 'lambert_addons_register_wpbakerry_elements');

// Add new Param in Row
function lambert_add_ons_add_vc_param()
{
    if (function_exists('vc_set_shortcodes_templates_dir')) {
        vc_set_shortcodes_templates_dir(BBT_ABSPATH . '/vc_templates/');
    }

    $new_row_params = array(
        array(
            "type"        => "dropdown",
            "heading"     => __('Section Layout', 'lambert-add-ons'),
            "param_name"  => "cth_layout",
            "value"       => array(
                __('Default', 'lambert-add-ons')                                                                     => 'default',

                __('Hero Header Section - Version 2', 'lambert-add-ons')                                             => 'hero_head_sec',
                __('Fullwidth Page Section - Version 2', 'lambert-add-ons')                                          => 'fullwidth_sec',
                __('Fullwidth Image Background Parallax Section - Version 2', 'lambert-add-ons')                     => 'fullwidth_image_parallax_sec',
                __('Fullwidth Video Background Parallax Section - Version 2', 'lambert-add-ons')                     => 'fullwidth_video_parallax_sec',

                __('Home Image Page Header Section (background image from `Design Options` tab)', 'lambert-add-ons') => 'hero_image_sec',
                __('Page Header Section', 'lambert-add-ons')                                                         => 'header_sec',
                __('Lambert Page Section with triangle top decoration', 'lambert-add-ons')                           => 'triangle_sec',
                __('Lambert Page Section', 'lambert-add-ons')                                                        => 'row_sec',
                __('Parallax Background Section (image from `Design Options` tab)', 'lambert-add-ons')               => 'parallax_sec',
                __('Home Full Height', 'lambert-add-ons')                                                            => 'hero_sec',

            ),
            "description" => __("Select one of the pre made page sections or using default", 'lambert-add-ons'),
            "group"       => esc_html__("Lambert Theme", 'lambert-add-ons'),
        ),
        array(

            "type"       => "dropdown",
            "heading"    => esc_html__('Remove Border', 'lambert-add-ons'),
            "param_name" => "remove_border",
            "value"      => array(
                esc_html__('Yes', 'lambert-add-ons') => 'yes',
                esc_html__('No', 'lambert-add-ons')  => 'no',

            ),
            "std"        => 'no',

            'dependency' => array(
                'element'   => 'cth_layout',
                'value'     => array('hero_head_sec'),
                'not_empty' => false,
            ),

            "group"      => esc_html__("Lambert Theme", 'lambert-add-ons'),
        ),
        array(

            "type"       => "dropdown",
            "heading"    => esc_html__('No Padding', 'lambert-add-ons'),
            "param_name" => "no_padding",
            "value"      => array(
                esc_html__('Yes', 'lambert-add-ons') => 'yes',
                esc_html__('No', 'lambert-add-ons')  => 'no',

            ),
            "std"        => 'no',

            'dependency' => array(
                'element'   => 'cth_layout',
                'value'     => array('fullwidth_sec', 'fullwidth_image_parallax_sec', 'fullwidth_video_parallax_sec'),
                'not_empty' => false,
            ),

            "group"      => esc_html__("Lambert Theme", 'lambert-add-ons'),
        ),
        array(

            "type"       => "dropdown",
            "heading"    => esc_html__('Video Type', 'lambert-add-ons'),
            "param_name" => "video_type",
            "value"      => array(
                esc_html__('Youtube Video ID', 'lambert-add-ons')  => 'youtube',
                esc_html__('Vimeo Video ID', 'lambert-add-ons')    => 'vimeo',
                esc_html__('Hosted Video Link', 'lambert-add-ons') => 'hosted',
                esc_html__('Parallax Image', 'lambert-add-ons')    => 'bg-image',

            ),
            "std"        => 'youtube',

            'dependency' => array(
                'element'   => 'cth_layout',
                'value'     => array('fullwidth_video_parallax_sec', 'hero_head_sec'),
                'not_empty' => false,
            ),

            "group"      => esc_html__("Lambert Theme", 'lambert-add-ons'),
        ),
        array(
            "type"        => "textfield",
            // "class"     => "",
            "heading"     => esc_html__("Background Video", 'lambert-add-ons'),
            "param_name"  => "bg_video",
            "value"       => "ScT73ywdGrs",
            "description" => esc_html__("Your Video ID (Youtube or Vimeo video) or hosted video link ( http://your_domain.com/video_name.mp4 ). Ex: ScT73ywdGrs", 'lambert-add-ons'),

            'dependency'  => array(
                'element'   => 'video_type',
                'value'     => array('youtube', 'vimeo', 'hosted'),
                'not_empty' => false,
            ),

            "group"       => esc_html__("Lambert Theme", 'lambert-add-ons'),
        ),
        array(

            "type"       => "dropdown",
            "heading"    => esc_html__('Mute', 'lambert-add-ons'),
            "param_name" => "is_mute",
            "value"      => array(
                esc_html__('Yes', 'lambert-add-ons') => '1',
                esc_html__('No', 'lambert-add-ons')  => '0',

            ),
            "std"        => '1',

            'dependency' => array(
                'element'   => 'video_type',
                'value'     => array('youtube', 'vimeo', 'hosted'),
                'not_empty' => false,
            ),

            "group"      => esc_html__("Lambert Theme", 'lambert-add-ons'),
        ),
        array(
            "type"       => "attach_image",
            // "class"=>"",
            "heading"    => esc_html__('Parallax Background Image', 'lambert-add-ons'),
            "param_name" => "parallax_inner",

            // "description" => esc_html__("Select your parallax background image for left image page section layout.", 'lambert'),
            'dependency' => array(
                'element'   => 'cth_layout',
                'value'     => array('fullwidth_image_parallax_sec', 'fullwidth_video_parallax_sec', 'hero_head_sec'),
                'not_empty' => false,
            ),

            "group"      => esc_html__("Lambert Theme", 'lambert-add-ons'),
        ),
        array(
            "type"        => "textfield",
            // "class"     => "",
            "heading"     => esc_html__("Overlay Opacity", 'lambert-add-ons'),
            "param_name"  => "parallax_inner_op",
            "value"       => "0.5",
            "description" => esc_html__("Overlay Opacity value 0.0 - 1. Ex: 0.5", 'lambert-add-ons'),

            'dependency'  => array(
                'element'   => 'parallax_inner',
                //'value' => array( 'lambert_fullheight_sec','lambert_page_sec'),
                'not_empty' => true,
            ),

            "group"       => esc_html__("Lambert Theme", 'lambert-add-ons'),
        ),
        array(
            "type"        => "textfield",
            "heading"     => esc_html__('Background Parallax Value', 'lambert-add-ons'),
            "param_name"  => "parallax_inner_val",
            "value"       => "300",
            "description" => esc_html__("Pixel number. Which we are telling the browser is to move Background Image down every time we scroll down 100% of the viewport height and move Background Image up every time we scroll up 100% of the viewport height. Ex: 300 or -300 for reverse direction.", 'lambert-add-ons'),

            'dependency'  => array(
                'element'   => 'parallax_inner',
                //'value' => array( 'lambert_fullheight_sec','lambert_page_sec'),
                'not_empty' => true,
            ),

            "group"       => esc_html__("Lambert Theme", 'lambert-add-ons'),
        ),
        array(

            "type"       => "textfield",
            "heading"    => esc_html__('Scroll Link', 'lambert-add-ons'),
            "param_name" => "scroll_link",
            "value"      => '#sec1',

            'dependency' => array(
                'element'   => 'cth_layout',
                'value'     => array('hero_head_sec'),
                'not_empty' => false,
            ),

            "group"      => esc_html__("Lambert Theme", 'lambert-add-ons'),
        ),
    );
    if (function_exists('vc_add_params')) {
        vc_add_params('vc_row', $new_row_params);
    }

}

add_action('init', 'lambert_add_ons_add_vc_param');

// // change vc_templates from child theme
// add_action( 'init', function(){
//     if (function_exists('vc_set_shortcodes_templates_dir')) {
//         vc_set_shortcodes_templates_dir( get_stylesheet_directory() . '/vc_templates/');
//     }

// }, 20 );
