<?php
/* add_ons_php */


add_action( 'cmb2_admin_init', 'lambert_addons_cmb2_metaboxes' );
/**
 * Define the metabox and field configurations.
 */
function lambert_addons_cmb2_metaboxes() {

    // Start with an underscore to hide fields from custom fields list
    $prefix = '_cmb_';

    /**
     * Initiate Post metabox
     */
    $post_cmb = new_cmb2_box( array(
        'id'            => 'post_options',
        'title'         => esc_html__( 'Post Format Options', 'lambert-add-ons' ),
        'object_types'  => array( 'post'), // Post type
        'context'       => 'normal',// normal, side and advanced
        'priority'      => 'high',// default, high and low - core
        'show_names'    => true, // Show field names on the left
    ) );

    $post_cmb->add_field( array(
        'name' => esc_html__('Post Slider Images', 'lambert-add-ons' ),
        'id'   => $prefix . 'post_slider_images',
        'type' => 'file_list',
        'preview_size' => array( 150, 150 ), // Default: array( 50, 50 )
    ) );

    $post_cmb->add_field( array(
        'name'       => esc_html__('oEmbed for Post Format', 'lambert-add-ons' ),
        'desc'       => wp_kses(__('Enter a youtube, twitter, or instagram URL. Supports services listed at <a href="http://codex.wordpress.org/Embeds">http://codex.wordpress.org/Embeds</a>.', 'lambert-add-ons' ),array('a'=>array('href'=>array()))),
        'id'   => $prefix . 'embed_video',
        'type' => 'oembed',
    ) );

    /**
     * Initiate Post metabox
     */

    $post2_cmb = new_cmb2_box( array(
        'id'            => 'post_header_options',
        'title'         => esc_html__( 'Header Options', 'lambert-add-ons' ),
        'object_types'  => array( 'post'), // Post type
        'context'       => 'normal',// normal, side and advanced
        'priority'      => 'high',// default, high and low - core
        'show_names'    => true, // Show field names on the left
    ) );


    $post2_cmb->add_field( array(
        'name' => esc_html__('Header Image', 'lambert-add-ons' ),
        'desc' => esc_html__('Select header image for this single post page. Will override the option from `Lambert Options` panel.','lambert-add-ons' ),
        'id'   => $prefix . 'single_header_image',
        'type'    => 'file',
        // Optional:
        'options' => array(
            'url' => true, // Hide the text input for the url
        ),
    ) );

    /**
     * Initiate Page metabox
     */

    $page_cmb = new_cmb2_box( array(
        'id'            => 'page_header_options',
        'title'         => esc_html__( 'Header Options', 'lambert-add-ons' ),
        'object_types'  => array( 'page','member'), // Post type
        'context'       => 'normal',// normal, side and advanced
        'priority'      => 'high',// default, high and low - core
        'show_names'    => true, // Show field names on the left
    ) );


    $page_cmb->add_field( array(
        'name' => esc_html__('Header Image', 'lambert-add-ons' ),
        'desc' => esc_html__('Select header image for this page. Will override the option from `Lambert Options` panel.','lambert-add-ons' ),
        'id'   => $prefix . 'single_header_image',
        'type'    => 'file',
        // Optional:
        'options' => array(
            'url' => true, // Hide the text input for the url
        ),
    ) );

    /**
     * Initiate member metabox
     */

    $memeber_cmb = new_cmb2_box( array(
        'id'            => 'member_options',
        'title'         => esc_html__( 'Additional Options', 'lambert-add-ons' ),
        'object_types'  => array( 'member'), // Post type
        'context'       => 'normal',// normal, side and advanced
        'priority'      => 'high',// default, high and low - core
        'show_names'    => true, // Show field names on the left
    ) );


    $memeber_cmb->add_field( array(
        'name' => esc_html__('Job Description', 'lambert-add-ons' ),
        
        'id'   => $prefix . 'mem_job',
        'type'    => 'textarea_small',
    ) );

    /**
     * Initiate Member Profile metabox
     */
    $member_cmb = new_cmb2_box( array(
        'id'            => 'member_popup_options',
        'title'         => esc_html__( 'Popup Details', 'lambert-add-ons' ),
        'object_types'  => array( 'member'), // Post type
        'context'       => 'normal',// normal, side and advanced
        'priority'      => 'low',// default, high and low - core
        'show_names'    => true, // Show field names on the left
    ) );


    $member_cmb->add_field( array(
        'name' => esc_html__( 'Facebook URL', 'lambert-add-ons' ),
      
        'id'   => $prefix . 'facebookurl',
        'type' => 'text_url',
        
    ) );

    $member_cmb->add_field( array(
        'name' => esc_html__( 'Twitter URL', 'lambert-add-ons' ),
        
        'id'   => $prefix . 'twitterurl',
        'type' => 'text_url',
        
    ) );
    $member_cmb->add_field( array(
        'name' => esc_html__( 'Google+ URL', 'lambert-add-ons' ),
        
        'id'   => $prefix . 'googleplusurl',
        'type' => 'text_url',
        
    ) );

    $member_cmb->add_field( array(
       'name' => esc_html__( 'Dribbble URL', 'lambert-add-ons' ),
        
        'id'   => $prefix . 'dribbbleurl',
        'type' => 'text_url',
        
    ) );

    
    $member_cmb->add_field( array(
       'name' => esc_html__( 'Linkedin URL', 'lambert-add-ons' ),
        
        'id'   => $prefix . 'linkedinurl',
        'type' => 'text_url',
        
    ) );
    $member_cmb->add_field( array(
       'name' => esc_html__( 'Instagram URL', 'lambert-add-ons' ),
        
        'id'   => $prefix . 'instagramurl',
        'type' => 'text_url',
        
    ) );
    $member_cmb->add_field( array(
       'name' => esc_html__( 'Tumblr URL', 'lambert-add-ons' ),
        
        'id'   => $prefix . 'tumblrurl',
        'type' => 'text_url',
        
    ) );
    $member_cmb->add_field( array(
       'name' => esc_html__( 'Pinterest URL', 'lambert-add-ons' ),
        
        'id'   => $prefix . 'pinterestrurl',
        'type' => 'text_url',
        
    ) );

    /**
     * Initiate Testimonials metabox
     */
    $testim_cmb = new_cmb2_box( array(
        'id'            => 'testimonial_mtb',
        'title'         => esc_html__('Testimonial Meta Options', 'lambert-add-ons' ),
        'object_types'  => array( 'testimonial'), // Post type
        'context'       => 'normal',// normal, side and advanced
        'priority'      => 'high',// default, high and low - core
        'show_names'    => true, // Show field names on the left
    ) );

    $testim_cmb->add_field( array(
        'name' => esc_html__( 'Rating Stars', 'lambert-add-ons' ),
       
        'id' => $prefix . 'testim_rate',
        'type'             => 'select',
        'show_option_none' => false,
        'default'          => '5',
        'options' => array(
            'no' => esc_html__( 'Not Rate', 'lambert-add-ons' ),
            '1' => esc_html__( '1 Star', 'lambert-add-ons' ),
            '1.5' => esc_html__( '1.5 Stars', 'lambert-add-ons' ),
            '2' => esc_html__( '2 Stars', 'lambert-add-ons' ),
            '2.5' => esc_html__( '2.5 Stars', 'lambert-add-ons' ),
            '3' => esc_html__( '3 Stars', 'lambert-add-ons' ),
            '3.5' => esc_html__( '3.5 Stars', 'lambert-add-ons' ),
            '4' => esc_html__( '4 Stars', 'lambert-add-ons' ),
            '4.5' => esc_html__( '4.5 Stars', 'lambert-add-ons' ),
            '5' => esc_html__( '5 Stars', 'lambert-add-ons' ),
            
        ),
    ) );


    /**
     * Initiate cthgallery metabox
     */
    $cthgallery_cmb = new_cmb2_box( array(
        'id'            => 'cthgallery_options',
        'title'         => esc_html__( 'Gallery Images Options', 'lambert-add-ons' ),
        'object_types'  => array( 'cthgallery'), // Post type
        'context'       => 'normal',// normal, side and advanced
        'priority'      => 'high',// default, high and low - core
        'show_names'    => true, // Show field names on the left
    ) );

    $cthgallery_cmb->add_field( array(
        'name' => esc_html__( 'Masonry Size', 'lambert-add-ons' ),
        'desc' => esc_html__( 'Choose the size of item thumbnail that show in gallery grid. You must select a Featured image for this gallery item.', 'lambert-add-ons' ),
        'id' => $prefix . 'masonry_size',
        'type'             => 'select',
        'show_option_none' => false,
        'default'          => 'one',
        'options' => array(
            'one' => esc_html__( 'Size One', 'lambert-add-ons' ),
            //'one-tall' => esc_html__( 'Size One - Two Tall', 'lambert' ),
            'second' => esc_html__( 'Size Two', 'lambert-add-ons' ),
            'three' => esc_html__( 'Size Three', 'lambert-add-ons' ),
        ),
    ) );

    $cthgallery_cmb->add_field( array(
        'name' => esc_html__('Gallery Images', 'lambert-add-ons' ),
        'id'   => $prefix . 'gallery_images',
        'type' => 'file_list',
        'preview_size' => array( 150, 150 ), // Default: array( 50, 50 )
    ) );

    $cthgallery_cmb->add_field( array(
        'name' => esc_html__('Gallery Columns', 'lambert-add-ons' ),
        'id'   => $prefix . 'gallery_cols',
        'type'    => 'select',
        'default'=>'three',
        'options' => array(
            'one' => esc_html__( 'One column', 'lambert-add-ons' ),
            'two'   => esc_html__( 'Two columns', 'lambert-add-ons' ),
            'three'   => esc_html__( 'Three columns', 'lambert-add-ons' ),
            'four'   => esc_html__( 'Four columns', 'lambert-add-ons' ),
            'five'   => esc_html__( 'Five columns', 'lambert-add-ons' ),
            
        ),
    ) );

    $cthgallery_cmb->add_field( array(
        'name' => esc_html__('Gallery Popup Image or Video (Galleries grid)', 'lambert-add-ons' ),
        'desc' => esc_html__('Select image or Youtube, Vimeo video link for popup. Leave empty for single gallery page link.', 'lambert-add-ons' ),
        'id'   => $prefix . 'gallery_popup_link',
        'type'    => 'file',
        // Optional:
        'options' => array(
            'url' => true, // Hide the text input for the url
        ),
    ) );

    $cthgallery_cmb->add_field( array(
        'name' => esc_html__('Header Image', 'lambert-add-ons' ),
        'desc' => esc_html__('Select header image for this single post page. Will override the option from `Lambert Options` panel.','lambert-add-ons' ),
        'id'   => $prefix . 'single_header_image',
        'type'    => 'file',
        // Optional:
        'options' => array(
            'url' => true, // Hide the text input for the url
        ),
    ) );


    /**
     * Initiate cthmenu metabox
     */
    $cthmenu_cmb = new_cmb2_box( array(
        'id'            => 'cthmenu_options',
        'title'         => esc_html__( 'Menu Options', 'lambert-add-ons' ),
        'object_types'  => array( 'cthmenu'), // Post type
        'context'       => 'normal',// normal, side and advanced
        'priority'      => 'high',// default, high and low - core
        'show_names'    => true, // Show field names on the left
    ) );

    $cthmenu_cmb->add_field( array(
        'name' => esc_html__('Menu Price', 'lambert-add-ons' ),
        'id'   => $prefix . 'menu_price',
        'type' => 'text',
    ) );

    $cthmenu_cmb->add_field( array(
        'name' => esc_html__('Menu Hot Deal Label', 'lambert-add-ons' ),
        'id'   => $prefix . 'menu_promo_label',
        'type' => 'text',
    ) );

    $cthmenu_cmb->add_field( array(
        'name' => esc_html__('Header Image', 'lambert-add-ons' ),
        'desc' => esc_html__('Select header image for this single post page. Will override the option from `Lambert Options` panel.','lambert-add-ons' ),
        'id'   => $prefix . 'single_header_image',
        'type'    => 'file',
        // Optional:
        'options' => array(
            'url' => true, // Hide the text input for the url
        ),
    ) );


    

    



    /**
     * Initiate User Profile metabox
     */
    $user_cmb = new_cmb2_box( array(
        'id'         => 'user_edit',
        'title'      => esc_html__( 'User Profile Metabox', 'lambert-add-ons' ),
        'object_types'  => array( 'user' ), // Tells CMB to use user_meta vs post_meta
        'context'       => 'normal',// normal, side and advanced
        'priority'      => 'core',// default, high and low - core
        'show_names'    => true, // Show field names on the left
    ) );


    $user_cmb->add_field( array(
        'name' => esc_html__( 'Facebook URL', 'lambert-add-ons' ),
      
        'id'   => $prefix . 'facebookurl',
        'type' => 'text_url',
        
    ) );

    $user_cmb->add_field( array(
        'name' => esc_html__( 'Twitter URL', 'lambert-add-ons' ),
        
        'id'   => $prefix . 'twitterurl',
        'type' => 'text_url',
        
    ) );
    $user_cmb->add_field( array(
        'name' => esc_html__( 'Google+ URL', 'lambert-add-ons' ),
        
        'id'   => $prefix . 'googleplusurl',
        'type' => 'text_url',
        
    ) );
    $user_cmb->add_field( array(
       'name' => esc_html__( 'Linkedin URL', 'lambert-add-ons' ),
        
        'id'   => $prefix . 'linkedinurl',
        'type' => 'text_url',
        
    ) );
    $user_cmb->add_field( array(
       'name' => esc_html__( 'Instagram URL', 'lambert-add-ons' ),
        
        'id'   => $prefix . 'instagramurl',
        'type' => 'text_url',
        
    ) );
    $user_cmb->add_field( array(
       'name' => esc_html__( 'Tumblr URL', 'lambert-add-ons' ),
        
        'id'   => $prefix . 'tumblrurl',
        'type' => 'text_url',
        
    ) );

}