<?php 
/* add_ons_php */

defined( 'ABSPATH' ) || exit;


class Bbt_Class_Install{
    public static function install(){
        

        // http://www.wpexplorer.com/wordpress-page-templates-plugin/
        $exists_options = get_option( 'lambert-addons-options', array() );
        // add new pages
        // - page args
        $_p = array();
        // $_p['post_content']   = '';
        $_p['post_status']    = 'publish';
        $_p['post_type']      = 'page';
        $_p['comment_status'] = 'closed';
        $_p['ping_status']    = 'closed';

        $_p['page_template']    = 'homepage.php';

        // - dashboard page
        $_page_title = __('Reservation Confirm Page','lambert-add-ons');
        $_page = get_page_by_title($_page_title);
        if (!$_page){
            $_p['post_title']     = $_page_title;
            $_p['post_content']   = __("This reservation comfirm page was generated by the plugin. Please don't edit or delete.",'lambert-add-ons');
            // Insert the post into the database
            $exists_options['res_confirm_page'] = wp_insert_post($_p); // return post Id or 0 or WP_Error if not success
        }else{
            // the plugin may have been previously active and the page may just be trashed...
            // $dashboard_page_id = $_page->ID;

            //make sure the page is not trashed...
            $_page->post_status = 'publish';
            $_page->post_content = __("This reservation comfirm page was generated by the plugin. Please don't edit or delete.",'lambert-add-ons');
            // $_page->page_template = 'home-page.php';

            $exists_options['res_confirm_page'] = wp_update_post($_page); // return post Id or 0 if not success
        }
        // update plugin options
        update_option( 'lambert-addons-options', $exists_options );
        // end message
        update_option( 'lambert-addons-version', BBT_VERSION );
            
    }

    public static function uninstall(){
        // move pages to trash
        $force_delete = false;
        // trash listing pages
        $exists_options = get_option( 'lambert-addons-options', array() );
        if(isset($exists_options['res_confirm_page'])){
            wp_delete_post($exists_options['res_confirm_page'], $force_delete);
        }
    }
}