<?php 
/* add_ons_php */

defined( 'ABSPATH' ) || exit;

class Bbt_Class_Frontend_Scripts {

    private static $plugin_url;

    public static function init(){
        self::$plugin_url = plugin_dir_url(BBT_PLUGIN_FILE);    
        add_action( 'wp_enqueue_scripts', array(get_called_class(), 'enqueue_scripts') );
        // add_action( 'wp_footer', array(get_called_class(), 'footer_markup') );       
    }

    public static function footer_markup(){
        ?>
        <!-- Quik search -->
        <div class="dlab-quik-search">
            <form action="<?php echo esc_url(home_url( '/' ) ); ?>">
                <input name="s" value="<?php echo get_search_query() ?>" type="text" class="form-control" placeholder="<?php esc_attr_e( 'Enter Your Keyword ...', 'lambert-add-ons' ); ?>">
                <span id="quik-search-remove"><i class="ti-close"></i></span>
            </form>
        </div>
        <?php
    }
    public static function enqueue_scripts(){

        // wp_enqueue_style( 'lambert-addon-icons', self::$plugin_url .'assets/css/lambert-icons.css' ); 
        // wp_enqueue_style( 'lambert-add-ons', self::$plugin_url .'assets/css/lambert-add-ons.min.css' ); 

        wp_enqueue_script( 'lambert-addons', self::$plugin_url ."assets/js/lambert-add-ons.min.js" , array('jquery'), null , true );

        $wpmllw    = apply_filters( 'wpml_current_language', null );

        $_lambert_add_ons = array(
            'url'           => esc_url(admin_url( 'admin-ajax.php' ) ),
            'nonce'         => wp_create_nonce( 'lambert-add-ons' ),
            'like'          => esc_html__( 'Like', 'lambert-add-ons' ),
            'unlike'        => esc_html__( 'Unlike', 'lambert-add-ons' ),

            'posted_on'     => __('Posted on ','lambert-add-ons'),
            'reply'         => __('Reply','lambert-add-ons'),
            'retweet'       => __('Retweet','lambert-add-ons'),
            'favorite'      => __('Favorite','lambert-add-ons'),

            'gcaptcha'          => ( lambert_addons_get_option('enable_g_recaptcah') == 'yes' && lambert_addons_get_option('g_recaptcha_site_key') != '' )? true: false,
            'gcaptcha_key'      => lambert_addons_get_option('g_recaptcha_site_key'),

            'wpml'              => $wpmllw,
        );

        wp_localize_script( 'lambert-addons', '_lambert_add_ons', $_lambert_add_ons );
        if( $wpmllw == null ) $wpmllw = get_locale();
        // google reCAPTCHA - v2
        if( lambert_addons_get_option('enable_g_recaptcah') == 'yes' && lambert_addons_get_option('g_recaptcha_site_key') != '' )
            wp_enqueue_script( 'g-recaptcha', "https://www.google.com/recaptcha/api.js?hl=".$wpmllw."&onload=cthCaptchaCallback&render=explicit#cthasync#cthdefer" , array('lambert-addons'), null , true );
    }
}

Bbt_Class_Frontend_Scripts::init();