<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

$with_sidebar = ! ideapark_mod( 'shop_hide_sidebar' ) && is_active_sidebar( 'shop-sidebar' );

global $product, $woocommerce_loop;

// Ensure visibility
if ( empty( $product ) || ! $product->is_visible() ) {
	return;
}

remove_action( 'woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10 );
remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10 );
remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5 );
remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5 );

if ( empty( $woocommerce_loop['loop'] ) ) {
	$woocommerce_loop['loop'] = 0;
}

if ( empty( $woocommerce_loop['columns'] ) ) {
	$woocommerce_loop['columns'] = apply_filters( 'loop_shop_columns', 4 );
}

$product_link = ' href="' . esc_url( get_permalink() ) . '"';

if ( ideapark_mod( 'quickview_enabled' ) ) {
	$quickview_link = $product_link . ' onclick="return false;" data-title="' . __( 'Quick View', 'kidz' ) . '" data-product_id="' . esc_attr( $product->get_id() ) . '" class="ip-quickview-btn product_type_' . esc_attr( $product->get_type() ) . '"';
} else {
	$quickview_link = '';
}
?>
<div <?php if ( function_exists( 'wc_product_class' ) ) {
	wc_product_class( '', $product );
} else {
	post_class();
}; ?>>

	<?php
	/**
	 * woocommerce_before_shop_loop_item hook.
	 *
	 * @hooked woocommerce_template_loop_product_link_open - 10
	 */
	do_action( 'woocommerce_before_shop_loop_item' );
	?>

	<div class="ip-shop-loop-wrap">

		<div class="ip-shop-loop-thumb">
			<a<?php echo ideapark_wrap( $product_link ); ?>>
				<?php
				/**
				 * woocommerce_before_shop_loop_item_title hook.
				 *
				 * @hooked woocommerce_show_product_loop_sale_flash - 10
				 * @hooked woocommerce_template_loop_product_thumbnail - 10
				 */
				do_action( 'woocommerce_before_shop_loop_item_title' );
				?>

				<?php
				$placeholder_image = apply_filters( 'ideapark_shop_placeholder_img_src', IDEAPARK_THEME_URI . '/img/placeholder.gif' );

				if ( has_post_thumbnail() && ( $product_thumbnail_id = get_post_thumbnail_id() ) ) {
					if ( $image_meta = ideapark_image_meta( $product_thumbnail_id, 'woocommerce_thumbnail' ) ) {
						if ( ideapark_mod( 'product_small_mobile' ) == 'compact' ) {
							$mobile_add = " (max-width: 600px) and (min-width: 360px) 140px,";
						} elseif ( ideapark_mod( 'product_small_mobile' ) == 'small' ) {
							$mobile_add = " (max-width: 600px) and (min-width: 412px) 140px, (max-width: 411px) and (min-width: 360px) 100px,";
						} else {
							$mobile_add = "";
						}

						if ( is_front_page() ) {
							$product_thumbnail_sizes = "(min-width: 1200px) 210px, (min-width: 992px) 241px,{$mobile_add} 360px";
						} else {
							if ( ! $with_sidebar ) {
								$product_thumbnail_sizes = "(min-width: 1200px) 210px, (min-width: 992px) 241px, (min-width: 768px) 293px,{$mobile_add} 360px";
							} else {
								$product_thumbnail_sizes = "(min-width: 1200px) 210px, (min-width: 992px) 281px, (min-width: 768px) 293px,{$mobile_add} 360px";
							}
						}
						$image_meta['sizes'] = $product_thumbnail_sizes;
						echo ideapark_img( $image_meta, 'thumb-shop-catalog ' . ( is_front_page() ? 'front' : '' ) . ( ideapark_mod( 'outofstock_badge_text' ) ? ' thumb-shop-out-of-stock' : '' ) );
					}
				} else {
					if ( wc_placeholder_img_src() ) {
						echo '<img src="' . esc_url( wc_placeholder_img_src() ) . '" class="thumb-shop-catalog' . ( ideapark_mod( 'outofstock_badge_text' ) ? ' thumb-shop-out-of-stock' : '' ) . '" alt="' . esc_html__( 'Awaiting product image', 'woocommerce' ) . '"/>';
					}
				}
				?>
			</a>
		</div>

		<div class="ip-shop-loop-details">
			<h3><a<?php echo ideapark_wrap( $product_link ); ?> class="ip-shop-loop-title"><?php the_title(); ?></a>
			</h3>

			<?php if ( ideapark_mod( 'product_preview_rating' ) && get_option( 'woocommerce_enable_review_rating' ) === 'yes' ) { ?>
				<?php echo wc_get_rating_html( $product->get_average_rating() ); ?>
			<?php } ?>

			<div class="ip-shop-loop-after-title">
				<div class="ip-shop-loop-price">
					<?php
					/**
					 * woocommerce_after_shop_loop_item_title hook.
					 *
					 * @hooked woocommerce_template_loop_rating - 5
					 * @hooked woocommerce_template_loop_price - 10
					 */
					do_action( 'woocommerce_after_shop_loop_item_title' );
					?>
				</div>
				<div class="ip-shop-loop-actions">
					<?php
					/**
					 * woocommerce_after_shop_loop_item hook.
					 *
					 * @hooked woocommerce_template_loop_product_link_close - 5
					 * @hooked woocommerce_template_loop_add_to_cart - 10
					 */
					do_action( 'woocommerce_after_shop_loop_item' );
					if ( $quickview_link ) {
						echo '<a' . $quickview_link . '><svg><use xlink:href="' . esc_url( ideapark_svg_url() ) . '#svg-quick-view" /></svg></a>';
					}
					if ( ideapark_mod( 'wishlist_enabled' ) && class_exists( 'Ideapark_Wishlist' ) ) {
						echo Ideapark_Wishlist()->button();
					}
					?>
				</div>
			</div>
		</div>
	</div>
</div>