<?php if ( ideapark_mod( 'top_menu' ) ) {
	$ip_styles = [];

	if ( ( $n = ideapark_mod( "top_menu_background_color" ) ) && $n != ideapark_mod_default( "top_menu_background_color" ) ) {
		$ip_styles[] = 'background-color:' . esc_attr( $n );
	}

	if ( ( $n = ideapark_mod( "top_menu_color" ) ) && $n != ideapark_mod_default( "top_menu_color" ) ) {
		$ip_styles[] = 'color:' . esc_attr( $n );
	}
	?>
	<div id="home-top-menu"
		 class="top-menu <?php if ( ( $n = ideapark_mod( 'top_menu_background_color' ) ) && ! preg_match( '~^#f{3,6}$~i', $n ) ) { ?>with-bg<?php } ?>" <?php echo ideapark_wrap( implode( ';', $ip_styles ), 'style="', '"' ) ?>>
		<!--Navigation-->
		<div class="container">
			<nav>
				<?php
				echo function_exists( 'wp_nav_menu' ) ?
					wp_nav_menu( [
						'container'      => '',
						'echo'           => false,
						'theme_location' => 'primary',
						'fallback_cb'    => 'ideapark_default_menu',
						'after'          => '<a href="#" class="js-more"><i class="more"></i></a>'
					] ) : ideapark_default_menu();
				?>
			</nav>
			<?php if ( ideapark_mod( 'top_menu_text' ) ) { ?>
				<div
					class="text <?php if ( ! ideapark_mod( 'top_menu_auth' ) ) { ?> text--right<?php } ?>"><?php echo do_shortcode( ideapark_mod( 'top_menu_text_phone_clickable' ) ? ideapark_phone_wrap( ideapark_mod( 'top_menu_text' ) ) : ideapark_mod( 'top_menu_text' ) ); ?></div>
			<?php } ?>
			<?php if ( ideapark_woocommerce_on() && ideapark_mod( 'top_menu_auth' ) ) { ?>
				<div class="auth"><?php echo ideapark_get_account_link(); ?></div>
			<?php } ?>
		</div>
	</div>
<?php } ?>