<?php
/**
 * Single Product Image
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/product-image.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.5.1
 */

defined( 'ABSPATH' ) || exit;

// Note: `wc_get_gallery_image_html` was added in WC 3.3.2 and did not exist prior. This check protects against theme overrides being used on older versions of WC.
if ( ! function_exists( 'wc_get_gallery_image_html' ) ) {
	return;
}

global $product;
$gallery_style		= kapee_get_product_layout();
$columns           	= apply_filters( 'woocommerce_product_thumbnails_columns', 4 );
$post_thumbnail_id 	= $product->get_image_id();
$wrapper_classes   	= apply_filters( 'woocommerce_single_product_image_gallery_classes', array(
	'woocommerce-product-gallery',
	'woocommerce-product-gallery--' . ( $product->get_image_id() ? 'with-images' : 'without-images' ),
	'woocommerce-product-gallery--columns-' . absint( $columns ),
	'images',
) );
?>
<div class="<?php echo esc_attr( implode( ' ', array_map( 'sanitize_html_class', $wrapper_classes ) ) ); ?>" data-columns="<?php echo esc_attr( $columns ); ?>" style="opacity: 0; transition: opacity .25s ease-in-out;">
	<figure class="woocommerce-product-gallery__wrapper">
		<div class="product-gallery-image kapee-slick-slider" data-slick='{"slidesToShow": 1, "slidesToScroll": 1, "asNavFor": ".product-gallery-thumbnails", "infinite" :false, "fade":true, <?php if ( is_rtl()) echo '"rtl": true,'; ?>"responsive":[{"breakpoint": 639,"settings":{"dots": true}}]}'>
			<?php
			if ( $product->get_image_id() ) {
				$html = wc_get_gallery_image_html( $post_thumbnail_id, true );
			} else {
				$html  = '<div class="woocommerce-product-gallery__image--placeholder">';
				$html .= sprintf( '<img src="%s" alt="%s" class="wp-post-image" />', esc_url( wc_placeholder_img_src( 'woocommerce_single' ) ), esc_attr__( 'Awaiting product image', 'kapee' ) );
				$html .= '</div>';
			}

			echo apply_filters( 'woocommerce_single_product_image_thumbnail_html', $html, $post_thumbnail_id ); // phpcs:disable WordPress.XSS.EscapeOutput.OutputNotEscaped

			do_action( 'woocommerce_product_thumbnails' );
			?>
		</div>
		
		<div class="product-gallery-thumbnails kapee-slick-slider" data-slick='{"slidesToShow":4,"slidesToScroll": 1,"asNavFor": ".product-gallery-image", "infinite" :false, "arrows": true, "focusOnSelect": true, <?php if ( $gallery_style == 'product-gallery-left' ) echo '"vertical": true,'; ?> <?php if ( $gallery_style != 'product-gallery-left' && is_rtl()) echo '"rtl": true,'; ?> "responsive":[{"breakpoint": 639,"settings":{"slidesToShow": 4, "infinite" :false, "vertical":false <?php if ( is_rtl()) echo ',"rtl": true'; ?>}}]}'>
			<?php $attachment_ids = $product->get_gallery_image_ids();
			$attachment_ids = array_merge( array( (int)$post_thumbnail_id ), $attachment_ids );
			if ( $attachment_ids && $post_thumbnail_id ) {
				foreach ( $attachment_ids as $attachment_id ) {
					echo apply_filters( 'woocommerce_single_product_image_thumbnail_html', kapee_wc_get_gallery_image_html( $attachment_id ), $attachment_id ); // phpcs:disable WordPress.XSS.EscapeOutput.OutputNotEscaped
				}
			}?>
		</div>
	</figure>
	<?php do_action( 'kapee_product_image' ); ?>
</div>
