<?php
/**
 * Checkout Form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/form-checkout.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.5.0
 */

defined( 'ABSPATH' ) || exit;
?>
<div id="checkout-top">
	<?php
	wc_print_notices();

	do_action( 'woocommerce_before_checkout_form', $checkout );
	/*If checkout registration is disabled and not logged in, the user cannot checkout*/
	if ( ! $checkout->is_registration_enabled() && $checkout->is_registration_required() && ! is_user_logged_in() ) {
		echo apply_filters( 'woocommerce_checkout_must_be_logged_in_message', esc_html__( 'Giriş yapmalısınız.', 'kanews' ) ); // WPCS: XSS ok.
		return;
	}
	?>
</div>

<ul class="progressbar">
  <li class="active"><?php esc_html_e( 'Paket Seçimi', 'kanews' ); ?></li>
  <li class=""><?php esc_html_e( 'Fatura', 'kanews' ); ?></li>
  <li class=""><?php esc_html_e( 'Ödeme', 'kanews' ); ?></li>
  <li class=""><?php esc_html_e( 'Sipariş Onayı', 'kanews' ); ?></li>
</ul>

<form name="checkout" method="post" class="wc-section-inner checkout woocommerce-checkout" action="<?php echo esc_url( wc_get_checkout_url() ); ?>" enctype="multipart/form-data">
  <div class="row">

    <?php if ( $checkout->get_checkout_fields() ) : ?>
      <div class="wc-content col-12 col-lg-8">
        <div class="row">
          <?php do_action( 'woocommerce_checkout_before_customer_details' ); ?>
          <div class="col-12" id="customer_details">
            <?php do_action( 'woocommerce_checkout_billing' ); ?>
            <?php do_action( 'woocommerce_checkout_shipping' ); ?>
          </div>
          <?php do_action( 'woocommerce_checkout_after_customer_details' ); ?>
        </div>
      </div>
    <?php endif; ?>

    <div class="wc-sidebar col-12 col-lg-4 checkout-right">
      <?php do_action( 'woocommerce_checkout_before_order_review' ); ?>
      <div id="order_review" class="woocommerce-checkout-review-order">
        <?php do_action( 'woocommerce_checkout_order_review' ); ?>
      </div>
      <?php do_action( 'woocommerce_checkout_after_order_review' ); ?>
    </div>

  </div>
</form>

<?php
do_action( 'woocommerce_after_checkout_form', $checkout );
