<?php
/**
 * Empty cart page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/cart-empty.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 7.0.1
 */

defined( 'ABSPATH' ) || exit;
/*
 * @hooked wc_empty_cart_message - 10
 */
do_action( 'woocommerce_cart_is_empty' );
?>

<?php if ( wc_get_page_id( 'shop' ) > 0 ) : ?>
	<ul class="progressbar">
		<li class=""><?php esc_html_e( 'Paket Seçimi', 'kanews' ); ?></li>
		<li class=""><?php esc_html_e( 'Fatura', 'kanews' ); ?></li>
		<li class=""><?php esc_html_e( 'Ödeme', 'kanews' ); ?></li>
		<li class=""><?php esc_html_e( 'Sipariş Onayı', 'kanews' ); ?></li>
	</ul>
	<div class="wc-section-inner text-center">
		<h2 style="font-size: 42px"><?php esc_html_e( 'Paket Seçimi Yapmalısınız!', 'kanews' ); ?></h2>
		<p><?php esc_html_e( 'Kendinize uygun paket seçimi yaptıktan sonra devam edebilirsiniz.', 'kanews' ); ?></p>

		<a class="kanews-btn kanews-btn-sm kanews-btn-block bg-success mb-0" href="<?php echo kanews_insights_page_url(); ?>">
			<?php esc_html_e( 'Return to shop', 'woocommerce' ); ?>
		</a>
	</div>

<?php endif; ?>
