<?php
/**
 * The template for displaying all single comp
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Kanews
 */
defined( 'ABSPATH' ) || exit; // Exit if accessed directly
get_header();
while ( have_posts() ) : the_post();
kanews_page_header($post->ID); 
endwhile;

?>
	<?php do_action('kanews_header_ad'); ?>
  <main id="main" class="site-main">
    <div class="container">
      <div class="row">

        <?php while ( have_posts() ) : the_post(); ?>

        <?php $comp = [
            'ilan_price' => get_post_meta($post->ID, "ilan_price", true ) ? get_post_meta($post->ID, "ilan_price", true ) : '',
            'name' => get_post_meta($post->ID, "ilan_name", true ) ? get_post_meta($post->ID, "ilan_name", true ) : get_the_title(),
            'city' => get_post_meta($post->ID, "ilan_city", true ) ? get_post_meta($post->ID, "ilan_city", true ) : esc_html__( 'Türkiye', 'kanews' ),
            'town' => get_post_meta($post->ID, "ilan_town", true ) ? get_post_meta($post->ID, "ilan_town", true ) : esc_html__( 'Merkez', 'kanews' ),
            'phone' => get_post_meta($post->ID, "ilan_tel", true ) ? get_post_meta($post->ID, "ilan_tel", true ) : esc_html__( 'Belirtilmemiş', 'kanews' ),
            'phone2' => get_post_meta($post->ID, "ilan_tel2", true ) ? get_post_meta($post->ID, "ilan_tel2", true ) : '',
            'whatsapp' => get_post_meta($post->ID, "ilan_whatsapp", true ) ? get_post_meta($post->ID, "ilan_whatsapp", true ) : '',
            'map' => get_post_meta($post->ID, "ilan_map", true ),
            'mail' => get_post_meta($post->ID, "ilan_mail", true ) ? get_post_meta($post->ID, "ilan_mail", true ) : get_the_author_meta('user_email', $post->post_author)
          ];
          ?>

         <div class="col-12 col-lg-8">

            <article class="kanews-article kanews-section kanews-section-box kanews-article-1">  
              <div class="kanews-tab kanews-tab-4">
                <ul class="nav nav-tabs d-flex flex-wrap p-0 mb-0" id="kanewsTab-10" role="tablist" style="margin: -21px -21px 10px;width:auto">
    
                  <li class="nav-item" role="presentation"><div id="about-tab-1" data-toggle="tab" href="#about-1" role="tab" data-controls="about-1" data-selected="true" class="nav-link active"><?php _e('İlan Detayları', 'kanews'); ?></div></li>
                  <li class="nav-item" role="presentation"><div id="location-tab-2" data-toggle="tab" href="#location-2" role="tab" data-controls="location-2" data-selected="false" class="nav-link"><?php _e('Konumu', 'kanews'); ?></div></li>
                </ul>
              
                <div class="tab-content" id="kanewsTabContent-10">
                  <div class="tab-pane fade show active" id="about-1" role="tabpanel" data-labelledby="about-tab-1">
                    <div class="kanews-article-content entry-content" >
                    
                    <?php if ( !empty(get_post_meta($post->ID, "ilan_thumb1", true )['id']) || !empty(get_post_meta($post->ID, "ilan_thumb2", true )['id']) || !empty(get_post_meta($post->ID, "ilan_thumb3", true )['id']) || !empty(get_post_meta($post->ID, "ilan_thumb4", true )['id']) || !empty(get_post_meta($post->ID, "ilan_thumb5", true )['id']) ) : ?>
                      <div id="gallery-1" class="kanews-gallery kanews-gallery-lightbox d-flex justify-content-between align-items-center kanews-galleryid-<?php echo get_the_ID(); ?>">
                        <div class="kanews-gallery-thumbs">
                        <?php $ilan_thumb = get_post_meta($post->ID, "ilan_thumb1", true ); if ( isset($ilan_thumb['id']) && !empty($ilan_thumb['id']) ) : ?>
                            <figure class="kanews-gallery-item" title="<?php echo get_the_title(); ?>" data-mfp-src="<?php echo wp_get_attachment_image_src($ilan_thumb['id'], 'full')[0]; ?>">
                              <?php echo kanews_get_local_image(wp_get_attachment_image_src($ilan_thumb['id'], 'thumbnail')[0], array('width' => 150, 'height' => 150), '1e1'); ?>
                            </figure>
                          <?php endif; ?>
                          <?php $ilan_thumb = get_post_meta($post->ID, "ilan_thumb2", true ); if ( isset($ilan_thumb['id']) && !empty($ilan_thumb['id']) ) : ?>
                            <figure class="kanews-gallery-item" title="<?php echo get_the_title(); ?>" data-mfp-src="<?php echo wp_get_attachment_image_src($ilan_thumb['id'], 'full')[0]; ?>">
                              <?php echo kanews_get_local_image(wp_get_attachment_image_src($ilan_thumb['id'], 'thumbnail')[0], array('width' => 150, 'height' => 150), '1e1'); ?>
                            </figure>
                          <?php endif; ?>
                          <?php $ilan_thumb = get_post_meta($post->ID, "ilan_thumb3", true ); if ( isset($ilan_thumb['id']) && !empty($ilan_thumb['id']) ) : ?>
                            <figure class="kanews-gallery-item" title="<?php echo get_the_title(); ?>" data-mfp-src="<?php echo wp_get_attachment_image_src($ilan_thumb['id'], 'full')[0]; ?>">
                              <?php echo kanews_get_local_image(wp_get_attachment_image_src($ilan_thumb['id'], 'thumbnail')[0], array('width' => 150, 'height' => 150), '1e1'); ?>
                            </figure>
                          <?php endif; ?>
                          <?php $ilan_thumb = get_post_meta($post->ID, "ilan_thumb4", true ); if ( isset($ilan_thumb['id']) && !empty($ilan_thumb['id']) ) : ?>
                            <figure class="kanews-gallery-item" title="<?php echo get_the_title(); ?>" data-mfp-src="<?php echo wp_get_attachment_image_src($ilan_thumb['id'], 'full')[0]; ?>">
                              <?php echo kanews_get_local_image(wp_get_attachment_image_src($ilan_thumb['id'], 'thumbnail')[0], array('width' => 150, 'height' => 150), '1e1'); ?>
                            </figure>
                          <?php endif; ?>
                          <?php $ilan_thumb = get_post_meta($post->ID, "ilan_thumb5", true ); if ( isset($ilan_thumb['id']) && !empty($ilan_thumb['id']) ) : ?>
                            <figure class="kanews-gallery-item" title="<?php echo get_the_title(); ?>" data-mfp-src="<?php echo wp_get_attachment_image_src($ilan_thumb['id'], 'full')[0]; ?>">
                              <?php echo kanews_get_local_image(wp_get_attachment_image_src($ilan_thumb['id'], 'thumbnail')[0], array('width' => 150, 'height' => 150), '1e1'); ?>
                            </figure>
                          <?php endif; ?>
                        </div>
                        <div class="kanews-gallery-text"><?php esc_html_e( 'Galeriyi Görüntüle', 'kanews' ); ?></div>
                      </div>
                    <?php endif; ?>
                    <?php the_content(); ?>
                    
             
                  </div>
                  <?php kanews_post_share($post->ID);?>
                  </div>
                  <div class="tab-pane" id="location-2" role="tabpanel" data-labelledby="location-tab-2">
                    <?php if( !empty($comp['map']) ): ?>
                      <div class="col-12">
                        <br>
                        <iframe style="width: 100%" class="kanews-lazy" data-src="<?php echo $comp['map']; ?>" width="860" height="450" style="border:0;" allowfullscreen="" loading="lazy"></iframe>
                      </div>
                    <?php else: ?><br>
                      <p class="mb-0"><?php echo get_post_meta($post->ID, "ilan_adress", true ) ? get_post_meta($post->ID, "ilan_adress", true ) : esc_html__( 'Konum bilgisi eklenmemiş.', 'kanews' );  ?></p>
                    <?php endif; ?>
                  </div>
                </div>
              </div>
            </article>

            <?php do_action('kanews_entry_comment_above'); ?>

          </div>
          
          <div class="col-12 col-lg-4 kanews-sticky">
            <div class="row">
              <div class="col-12">
                <?php 
                $insights = 24 * HOUR_IN_SECONDS;
                $user_id = get_current_user_id(); 
                $subscribed = true;

                if( class_exists( 'WooCommerce' ) && kanews_get_option('ilan-insights') && $user_id == $post->post_author ) {
                  $insights  = get_user_meta($user_id, 'kanews_insights_ilan_update_loop', true) ? get_user_meta($user_id, 'kanews_insights_ilan_update_loop', true) : 24 * HOUR_IN_SECONDS;
                  $subscribed = kanews_insights_control($user_id);
                } 

                $last_update_date = get_user_option( 'ilan-last-update-date', $user_id );
                $timediff = strtotime("now") - $last_update_date; 
                if ( class_exists('Simple_Review') && is_user_logged_in() && kanews_get_option('ilan-sistemi') && kanews_get_option('ilan-update') && $user_id == $post->post_author && $subscribed && $timediff > $insights  ): ?>
                  <button id="kanews-ilan-update" data-pid="<?php the_ID(); ?>" data-puid="<?php echo $post->post_author; ?>" class="kanews-btn kanews-btn-block kanews-btn-sm mt-0"><?php esc_html_e( 'İlanı Yukarı Taşı', 'kanews' ); ?><div id="kanews-loader"></div></button>
                <?php endif; ?>
                <div class="kanews-section widget widget_pages">
                  <div class="col-12 text-left">
                    <?php the_post_thumbnail('full', array('class' => 'kanews-ilan-logo', 'style' => 'margin-bottom:20px;width:100%;height:auto')); ?> 
                    
                    <?php if ( $comp['ilan_price'] != ''): ?> <p class="mb-0" style="font-size: 2em;font-weight: 700;letter-spacing: -1px;"><i class="icon-dollar"></i> <?php echo esc_html($comp['ilan_price']); ?></p><?php endif; ?>

                    <h2 class="kanews-ilan-cities">
                    <?php echo (get_the_term_list( $post->ID, 'ilan-il', '', ', ' )) ? get_the_term_list( $post->ID, 'ilan-il', '', ' ' ) : $comp['city']; ?>
                    <?php echo ( get_the_term_list( $post->ID, 'ilan-ilce', '', ', ' )) ? get_the_term_list( $post->ID, 'ilan-ilce', '', ' ' ) : $comp['town']; ?>
                    </h2>        
                    
                    <h2 class="kanews-ilan-cities">
                      <?php echo (get_the_term_list( $post->ID, 'ilan-kategori', '', ', ' )); ?>
                      <?php echo ( get_the_term_list( $post->ID, 'ilan-etiket', '', ', ' )); ?>
                    </h2>

                    <ul class="kanews-ilan-list">
                      <li class="d-flex flex-wrarp align-items-center justify-content-between"><label><?php esc_html_e( 'İlan no', 'kanews' ); ?>:</label><div>#<?php echo get_the_ID(); ?></div></li>
                      <?php if( ($ilan_list = get_post_meta($post->ID, "ilan_list", true )) && is_array($ilan_list) ) : ?>
                        <?php foreach( $ilan_list as $list ) {
                          echo '<li class="d-flex flex-wrarp align-items-center justify-content-between"><label>'.$list['title'].'</label><div>'.$list['text'].'</div></li>';
                        } ?>
                      <?php endif; ?>
                    </ul>
                  </div>
                  <ul style="padding-top: 0">
                    <li class="page-item current_page_item" style="margin-left: 0;margin-right: 0"><a class="justify-content-between" style="display: flex;" href="tel:<?php echo $comp['phone']; ?>"><i class="icon-call"></i> <?php echo $comp['phone']; ?></a></li>
                    <?php if ( !empty($comp['phone2']) ): ?>
                      <li class="page-item current_page_item" style="margin-left: 0;margin-right: 0"><a style="display: flex;" class="bg-dark border-dark d-flex justify-content-between" href="tel:<?php echo $comp['phone2']; ?>"><i class="icon-call"></i> <?php echo $comp['phone2']; ?></a></li>
                    <?php endif; ?>
                    <?php if( $comp['whatsapp'] != '' ): ?>
                      <li class="page-item" style="margin-left: 0;margin-right: 0"><a style="display: flex;" class="justify-content-between color-whatsapp border-whatsapp" href="https://wa.me/<?php echo $comp['whatsapp']; ?>?text=<?php echo urlencode(sprintf(esc_html__('%s ilanınız hakkında konuşmak istiyorum. %s', 'kanews'), get_the_title($post->ID), get_the_permalink($post->ID)));?>"><i class="icon-whatsapp"></i> <?php esc_html_e( 'Whatsapp\'tan Yaz', 'kanews' ); ?></a></li>
                    <?php endif; ?>
                  </ul>
                  

                </div>
              </div>
            
              
              
            </div>
          </div>
          
        <?php endwhile;	?>
	
			</div>
		</div>
	</main>


<?php
get_footer();
