<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Kanews
 */
defined( 'ABSPATH' ) || exit; // Exit if accessed directly
$default_layout = (kanews_get_option('single-layout')) ? kanews_get_option('single-layout') : '1';
$single_layout = (get_post_meta( get_the_ID(), 'select_post_layout', true )) ? get_post_meta( get_the_ID(), 'select_post_layout', true ) : '';

if( has_post_format( 'video' ) ) {
  $pid = get_the_ID();
?>
<div class="col-12">
    <div class="kanews-video-playlist kanews-section">
      <div class="d-flex flex-wrap">
        <div class="col-12 col-lg-8 no-gutter">
          <div class="kanews-video-playlist-main">
            <?php 
            // Ana video alanı
            $video_url = get_post_meta($pid, 'video_embed', true);
            if (empty($video_url)) {
                $video_url = get_post_meta($pid, 'iframe_src', true);
            }
            if (empty($video_url)) {
                $video_url = get_post_meta($pid, 'video_src', true);
            }
            
            if($video_url):
                // Video URL'sini temizle ve platform kontrolü yap
                $video_url = esc_url($video_url);
                
                if(strpos($video_url, 'youtube.com') !== false || strpos($video_url, 'youtu.be') !== false) {
                    // YouTube video ID'sini al
                    preg_match('/(?:youtube\.com\/(?:[^\/]+\/.+\/|(?:v|e(?:mbed)?)\/|.*[?&]v=)|youtu\.be\/)([^"&?\/\s]{11})/', $video_url, $matches);
                    $video_id = $matches[1];
                    
                    // YouTube Embed URL'sini oluştur
                    $embed_url = 'https://www.youtube.com/embed/' . $video_id . '?enablejsapi=1&rel=0&showinfo=0&autoplay=1';
                    
                    echo '<div class="kanews-video" data-video-id="' . esc_attr($video_id) . '" data-video-type="youtube">';
                    echo '<iframe 
                            src="' . esc_url($embed_url) . '" 
                            frameborder="0" 
                            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" 
                            allowfullscreen
                            loading="lazy"></iframe>';
                    echo '</div>';
                    
                } elseif(strpos($video_url, 'vimeo.com') !== false) {
                    // Vimeo video ID'sini al
                    preg_match('/vimeo\.com\/([0-9]+)/', $video_url, $matches);
                    $video_id = $matches[1];
                    
                    // Vimeo Embed URL'sini oluştur
                    $embed_url = 'https://player.vimeo.com/video/' . $video_id;
                    
                    echo '<div class="kanews-video" data-video-id="' . esc_attr($video_id) . '" data-video-type="vimeo">';
                    echo '<iframe 
                            width="100%" 
                            height="100%" 
                            src="' . esc_url($embed_url) . '" 
                            frameborder="0" 
                            allow="autoplay; fullscreen; picture-in-picture" 
                            allowfullscreen></iframe>';
                    echo '</div>';
                } else {
                    // Diğer video platformları veya direkt iframe/video src için
                    if (filter_var($video_url, FILTER_VALIDATE_URL)) {
                        if (pathinfo($video_url, PATHINFO_EXTENSION)) {
                            // Direkt video dosyası
                            echo '<div class="kanews-video" data-video-type="direct">';
                            echo '<video width="100%" height="100%" controls>
                                    <source src="' . esc_url($video_url) . '" type="video/mp4">
                                  </video>';
                            echo '</div>';
                        } else {
                            // iframe src
                            echo '<div class="kanews-video" data-video-type="iframe">';
                            echo '<iframe 
                                    src="' . esc_url($video_url) . '" 
                                    frameborder="0" 
                                    allowfullscreen></iframe>';
                            echo '</div>';
                        }
                    }
                }

            endif; 
            ?>
          </div>
        </div>

        <div class="col-12 col-lg-4 no-gutter">
          <div class="kanews-video-playlist-sidebar">
            <?php 
            // İlgili videoları getir
            $related_args = array(
                'post_type' => 'post',
                'posts_per_page' => 6,
                'post__not_in' => array($pid),
                'tax_query' => array(
                    array(
                        'taxonomy' => 'post_format',
                        'field' => 'slug',
                        'terms' => array('post-format-video')
                    )
                )
            );
            
            $related_query = new WP_Query($related_args);
            
            if($related_query->have_posts()): 
                while($related_query->have_posts()): 
                    $related_query->the_post();
                    $video_url = get_post_meta(get_the_ID(), 'video_embed', true);
                    if (empty($video_url)) {
                        $video_url = get_post_meta(get_the_ID(), 'iframe_src', true);
                    }
                    if (empty($video_url)) {
                        $video_url = get_post_meta(get_the_ID(), 'video_src', true);
                    }
            ?>
                    <div class="kanews-post-item kanews-post-small-item" data-video-url="<?php echo esc_url($video_url); ?>">
                        <?php kanews_post_thumbnail('thumbnail', 'kanews-post-thumb'); ?>
                        <div class="kanews-post-content">
                            <div class="kanews-post-headline truncate-3 truncate">
                                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                            </div>
                        </div>
                    </div>
            <?php 
                endwhile;
                wp_reset_postdata();
            endif; 
            ?>
          </div>
        </div>
      </div>
    </div>
  </div>
<?php 
}

if($single_layout == '' || $single_layout == 'default')
get_template_part( 'template-parts/content/content-'.$default_layout);
else
get_template_part( 'template-parts/content/content-'.$single_layout);