<?php 
$cat = get_post_meta(get_queried_object_id(), 'custom_page_related', true) != 0 && get_post_meta(get_queried_object_id(), 'custom_page_related', true) != '' ? get_post_meta(get_queried_object_id(), 'custom_page_related', true) : 'no';
// Setup defaults
$array_defaults = array( 
  'posts_per_page' => 20,
  's' => '',
); 
  
$args = wp_parse_args($args, $array_defaults );

$paged = isset($_GET['pagi']) ? $_GET['pagi'] : 1;
$kanews_query = new WP_Query(
  array( 
    'posts_per_page' => $args['posts_per_page'],
    'post_type'     => array('post', 'columist'),
    's' => $args['s'],
    'paged' => $paged, 
  )
);

if ( $cat != 'no' && $kanews_query->have_posts() ) : ?>

  <div class="kanews-section kanews-section-flat kanews-widgets-top column_x_gutter">
    <?php echo kanews_widget_title(sprintf(esc_html__( 'En yeni %s haberleri', 'kanews' ), $args['s']), 'h2'); ?>
    <div class="row"  kanews-data-load-more data-status="1">
      <?php $counter=0; while($kanews_query->have_posts()): $kanews_query->the_post(); global $post; $counter++; 
        $cat_color = get_term_meta( (int) Kanews\Helper_Wp::primary_category_id($post->ID), '_category_color', true );
        $col = 'col-6 col-md-3';
        $thumbnail = 'kanews-manset-5';
        $big_class = '';
        if($counter % 5 == 1) {
          $big_class = 'kanews-post-big';
          $col = 'col-12 col-md-6';
          $thumbnail = 'kanews-manset-3';
        }
        ?>
        <div class="<?php echo $col; ?> toinfinite">
          <?php get_template_part('template-parts/post-blocks/block-4', null, array('cat_color' => $cat_color, 'thumbnail' => $thumbnail, 'item_class' => $big_class)); ?>
        </div>
      <?php endwhile; wp_reset_postdata(); ?>
    </div>
    <?php
      $total_pages = $kanews_query->max_num_pages;
      if ($total_pages > 1){
        echo '<nav class="navigation pagination" style="width: 100%" hidden role="navigation"><div class="nav-links">';
        $current_page = max(1, get_query_var('pagi'));
        echo '<a href="'.esc_url(add_query_arg( 'pagi', ($current_page+1), $_SERVER['REQUEST_URI'])).'" class="next"></a>';
        echo '</div></nav>';
      }
    ?> 
    <div id="load-more-posts-button-wrapper">
      <div style="display:none" class="page-load-status">
        <div class="loader-ellips infinite-scroll-request">
          <svg version="1.1" id="loader-1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="40px" height="40px" viewBox="0 0 40 40" enable-background="new 0 0 40 40" xml:space="preserve"> <path opacity="0.2" fill="#000" d="M20.201,5.169c-8.254,0-14.946,6.692-14.946,14.946c0,8.255,6.692,14.946,14.946,14.946 s14.946-6.691,14.946-14.946C35.146,11.861,28.455,5.169,20.201,5.169z M20.201,31.749c-6.425,0-11.634-5.208-11.634-11.634 c0-6.425,5.209-11.634,11.634-11.634c6.425,0,11.633,5.209,11.633,11.634C31.834,26.541,26.626,31.749,20.201,31.749z"/> <path fill="#000" d="M26.013,10.047l1.654-2.866c-2.198-1.272-4.743-2.012-7.466-2.012h0v3.312h0 C22.32,8.481,24.301,9.057,26.013,10.047z"> <animateTransform attributeType="xml" attributeName="transform" type="rotate" from="0 20 20" to="360 20 20" dur="0.5s" repeatCount="indefinite"/> </path> </svg>
        </div>
        <p class="infinite-scroll-last"><?php _e('Daha fazla gösterilecek yazı bulunamadı!', 'kanews'); ?></p>
        <p class="infinite-scroll-error"><?php _e('Tekrar deneyiniz.', 'kanews'); ?></p>
      </div>
    </div>
  </div>

<?php endif; ?>